/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBTable;

public final class DBModel
extends DBObject<Object> {
    private static final String FQ_TBL_NAME_SEPARATOR = ".";
    private Map<String, DBTable> tables = new HashMap<String, DBTable>();
    private int dbType;

    public synchronized void addTable(DBTable table) {
        if (table != null) {
            String fqName = this.getFullyQualifiedTableName(table);
            table.setParentObject(this);
            this.tables.put(fqName, table);
        }
    }

    public boolean equals(Object refObj) {
        if (this == refObj) {
            return true;
        }
        boolean result = false;
        if (refObj instanceof DBModel) {
            DBModel aSrc = (DBModel)refObj;
            if (this.tables != null && aSrc.tables != null) {
                Set<String> objTbls = aSrc.tables.keySet();
                Set<String> myTbls = this.tables.keySet();
                boolean tblCheck = myTbls.containsAll(objTbls) && objTbls.containsAll(myTbls);
                result &= tblCheck;
            }
        }
        return result;
    }

    public String getFullyQualifiedTableName(DBTable tbl) {
        if (tbl != null) {
            String tblName = tbl.getName();
            String schName = tbl.getSchema();
            String catName = tbl.getCatalog();
            StringBuilder buf = new StringBuilder(50);
            if (catName != null && catName.trim().length() != 0) {
                buf.append(catName.trim());
                buf.append(FQ_TBL_NAME_SEPARATOR);
            }
            if (schName != null && schName.trim().length() != 0) {
                buf.append(schName.trim());
                buf.append(FQ_TBL_NAME_SEPARATOR);
            }
            buf.append(tblName.trim());
            return buf.toString();
        }
        return null;
    }

    public DBTable getTable(String fqTableName) {
        return this.tables.get(fqTableName);
    }

    public int getDBType() {
        return this.dbType;
    }

    public int hashCode() {
        int myHash = 0;
        if (this.tables != null) {
            myHash += ((Object)this.tables.keySet()).hashCode();
        }
        return myHash;
    }

    public String toString() {
        return this.getDisplayName();
    }

    void setDBType(int dbType) {
        this.dbType = dbType;
    }
}

