/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.progress;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.progress.ProgressListener;

public final class CompositeProgress
extends Progress
implements ProgressListener {
    private List<Progress> progresses = new LinkedList<Progress>();
    private List<Integer> percentages = new LinkedList<Integer>();
    private boolean synchronizeDetails = false;
    public static final String ERROR_WRONG_PERCENTAGE = ResourceUtils.getString(CompositeProgress.class, "CP.error.percentage");
    public static final String ERROR_WRONG_PROGRESS = ResourceUtils.getString(CompositeProgress.class, "CP.error.progress");

    public CompositeProgress() {
    }

    public CompositeProgress(ProgressListener initialListener) {
        this();
        this.addProgressListener(initialListener);
    }

    public int getPercentage() {
        int total = 0;
        for (int i = 0; i < this.progresses.size(); ++i) {
            total += this.progresses.get(i).getPercentage() * this.percentages.get(i);
        }
        total = total / 100 + this.percentage;
        return total;
    }

    public void setPercentage(int percentage) {
        if (this.percentage != percentage) {
            if (!this.evaluatePercentage(percentage)) {
                throw new IllegalArgumentException(StringUtils.format(ERROR_WRONG_PERCENTAGE, percentage, 0, 100));
            }
            this.percentage = percentage;
            this.notifyListeners();
        }
    }

    public void addPercentage(int addition) {
        int result = this.percentage + addition;
        if (this.percentage != result) {
            if (!this.evaluatePercentage(result)) {
                throw new IllegalArgumentException(StringUtils.format(ERROR_WRONG_PERCENTAGE, addition, 0, 100));
            }
            this.percentage = result;
            this.notifyListeners();
        }
    }

    public void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        for (Progress child : this.progresses) {
            child.setCanceled(canceled);
        }
    }

    public void addChild(Progress progress, int percentage) {
        if (!this.evaluatePercentage(percentage)) {
            throw new IllegalArgumentException(StringUtils.format(ERROR_WRONG_PERCENTAGE, percentage, 0, 100));
        }
        this.progresses.add(progress);
        this.percentages.add(percentage);
        progress.addProgressListener(this);
        this.notifyListeners();
    }

    public void removeChild(Progress progress) {
        int index = this.progresses.indexOf(progress);
        if (index == -1) {
            throw new IllegalArgumentException(StringUtils.format(ERROR_WRONG_PROGRESS, new Object[0]));
        }
        this.percentages.remove(index);
        this.progresses.remove(index);
        progress.removeProgressListener(this);
    }

    public void synchronizeDetails(boolean synchronizeDetails) {
        this.synchronizeDetails = synchronizeDetails;
    }

    public void progressUpdated(Progress progress) {
        if (this.synchronizeDetails) {
            this.setDetail(progress.getDetail());
        }
        this.notifyListeners();
    }

    private boolean evaluatePercentage(int percentage) {
        int total = percentage;
        for (Integer value : this.percentages) {
            total += value.intValue();
        }
        return total >= 0 && total <= 100;
    }
}

