/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.runprofiles;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Env
implements Cloneable {
    private Vector<String[]> environ = new Vector();

    public void removeAll() {
        this.environ = new Vector();
    }

    public void removeByName(String name) {
        if (name == null) {
            return;
        }
        String[] entry = this.getenvAsPair(name);
        this.environ.removeElement(entry);
    }

    public String getenvEntry(String name) {
        String value = this.getenv(name);
        if (value != null) {
            return name + "=" + value;
        }
        return null;
    }

    public String[] getenvAsPair(String name) {
        for (String[] nameValue : this.environ) {
            if (!nameValue[0].equals(name)) continue;
            return nameValue;
        }
        return null;
    }

    public String getenv(String name) {
        for (String[] nameValue : this.environ) {
            if (!nameValue[0].equals(name)) continue;
            return nameValue[1];
        }
        return null;
    }

    public String toString() {
        String[] envStrings = this.getenv();
        boolean addSep = false;
        StringBuilder envString = new StringBuilder();
        for (int i = 0; i < envStrings.length; ++i) {
            if (addSep) {
                envString.append(";");
            }
            envString.append(envStrings[i]);
            addSep = true;
        }
        return envString.toString();
    }

    public String encode() {
        return this.toString();
    }

    public void decode(String envlist) {
        StringTokenizer tokenizer = new StringTokenizer(envlist, " ;");
        while (tokenizer.hasMoreTokens()) {
            this.putenv(tokenizer.nextToken());
        }
    }

    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof Env) {
            Env env = (Env)o;
            eq = this.toString().equals(env.toString());
        }
        return eq;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void putenv(String entry) {
        int equalx = entry.indexOf(61);
        if (equalx == -1) {
            System.err.println("Env.putenv(): odd entry '" + entry + "'");
            return;
        }
        String name = entry.substring(0, equalx);
        String value = entry.substring(equalx + 1);
        this.putenv(name, value);
    }

    public void putenv(String name, String value) {
        String[] entry = this.getenvAsPair(name);
        if (entry != null) {
            entry[1] = value;
        } else {
            this.environ.add(new String[]{name, value});
        }
    }

    public String[] getenv() {
        String[] array = new String[this.environ.size()];
        int index = 0;
        for (String[] nameValue : this.environ) {
            array[index++] = nameValue[0] + "=" + nameValue[1];
        }
        return array;
    }

    public String[][] getenvAsPairs() {
        String[][] array = new String[this.environ.size()][2];
        int index = 0;
        for (String[] nameValue : this.environ) {
            array[index++] = nameValue;
        }
        return array;
    }

    public Map<String, String> getenvAsMap() {
        HashMap<String, String> res = new HashMap<String, String>(this.environ.size());
        for (String[] nameValue : this.environ) {
            res.put(nameValue[0], nameValue[1]);
        }
        return res;
    }

    public void assign(Env env) {
        if (this != env) {
            this.removeAll();
            String[][] pairs = env.getenvAsPairs();
            for (int i = 0; i < pairs.length; ++i) {
                this.putenv(pairs[i][0], pairs[i][1]);
            }
        }
    }

    public Env clone() {
        Env clone = new Env();
        String[][] pairs = this.getenvAsPairs();
        for (int i = 0; i < pairs.length; ++i) {
            clone.putenv(pairs[i][0], pairs[i][1]);
        }
        return clone;
    }
}

