/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils.locale.converters;

import com.sun.org.apache.commons.beanutils.locale.BaseLocaleConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DateLocaleConverter
extends BaseLocaleConverter {
    private SimpleDateFormat formatter;

    public DateLocaleConverter() {
        this(false);
    }

    public DateLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public DateLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public DateLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public DateLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public DateLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
        this.formatter = new SimpleDateFormat(this.pattern, this.locale);
    }

    public DateLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public DateLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue, locale, pattern, locPattern);
        this.formatter = new SimpleDateFormat(this.pattern, this.locale);
    }

    public boolean isLenient() {
        return this.formatter.isLenient();
    }

    public void setLenient(boolean lenient) {
        this.formatter.setLenient(lenient);
    }

    protected Object parse(Object value, String pattern) throws ParseException {
        if (this.locPattern) {
            this.formatter.applyLocalizedPattern(pattern);
        } else {
            this.formatter.applyPattern(pattern);
        }
        return this.formatter.parse((String)value);
    }
}

