/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.xerces.util.XMLChar;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.BrowseFolders;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagTargetPanelProvider;
import org.netbeans.modules.web.wizards.targetpanel.providers.XmlOptionPanelManager;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

class TagUIManager
extends XmlOptionPanelManager {
    private static final String TAG_FILE_IN_JAVALIB_FOLDER = "META-INF/tags";
    private static final String TAG_FILE_FOLDER = "tags";
    private static final Logger LOG = Logger.getLogger(TagUIManager.class.getName());
    private JCheckBox myTldCheckBox;
    private JTextField myTldTextField;
    private JButton myBrowseButton;
    private JTextField myTagNameTextField;
    private String myTagName;
    private FileObject myTldFileObject;
    private Set<?> myTagValues;
    boolean isTagFileValid = true;

    TagUIManager() {
    }

    @Override
    public void initComponents(JPanel jPanel, TargetChooserPanel<FileType> targetChooserPanel, final TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        super.initComponents(jPanel, targetChooserPanel, targetChooserPanelGUI);
        targetChooserPanelGUI.setNameLabel(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_TagFileName"));
        this.getJspSyntaxButton().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_TagFileJsp"));
        this.getJspSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFile"));
        this.getXmlSyntaxButton().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_TagFileXml"));
        this.getXmlSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileXml"));
        this.getSegmentBox().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_TagFileSegment"));
        this.getSegmentBox().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_DESC_TagFile_segment"));
        this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFile"));
        targetChooserPanelGUI.addLocationListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                targetChooserPanelGUI.changedUpdate(null);
            }
        });
    }

    @Override
    protected int doInitComponents(JPanel jPanel, final TargetChooserPanel<FileType> targetChooserPanel, final TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        int n = super.doInitComponents(jPanel, targetChooserPanel, targetChooserPanelGUI);
        this.myTldCheckBox = new JCheckBox();
        this.myTldCheckBox.setMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_AddToTLD_mnem").charAt(0));
        this.myTldCheckBox.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_addTagFileToTLD"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 2, 0);
        jPanel.add((Component)this.myTldCheckBox, gridBagConstraints);
        this.myTldCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_addToTLD"));
        JLabel jLabel = new JLabel();
        jLabel.setDisplayedMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_TLDName_mnem").charAt(0));
        jLabel.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_tldFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.myTldTextField = new JTextField();
        this.myTldTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        jPanel.add((Component)this.myTldTextField, gridBagConstraints);
        this.myTldTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_DESC_TLDFile"));
        jLabel.setLabelFor(this.myTldTextField);
        this.myBrowseButton = new JButton();
        this.myBrowseButton.setMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_Browse1_Mnemonic").charAt(0));
        this.myBrowseButton.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_Browse"));
        this.myBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TagUIManager.this.browse(actionEvent, (TargetChooserPanel<FileType>)targetChooserPanel, (TargetChooserPanelGUI<FileType>)targetChooserPanelGUI);
            }
        });
        this.myBrowseButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel.add((Component)this.myBrowseButton, gridBagConstraints);
        this.myBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_Browse"));
        this.myTldCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                TagUIManager.this.myTagNameTextField.setEditable(TagUIManager.this.myTldCheckBox.isSelected());
                TagUIManager.this.myBrowseButton.setEnabled(TagUIManager.this.myTldCheckBox.isSelected());
                if (TagUIManager.this.myTldCheckBox.isSelected() && TagUIManager.this.myTagName == null && (string = targetChooserPanelGUI.getDocumentName()).length() > 0) {
                    TagUIManager.this.myTagNameTextField.setText(string);
                    TagUIManager.this.myTagName = string;
                }
                targetChooserPanel.fireChange();
            }
        });
        JLabel jLabel2 = new JLabel();
        jLabel2.setDisplayedMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_TagName_mnem").charAt(0));
        jLabel2.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_tagName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.myTagNameTextField = new JTextField();
        this.myTagNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        jPanel.add((Component)this.myTagNameTextField, gridBagConstraints);
        this.myTagNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_DESC_TagName"));
        jLabel2.setLabelFor(this.myTagNameTextField);
        this.myTagNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TagUIManager.this.myTagName = TagUIManager.this.myTagNameTextField.getText().trim();
                targetChooserPanel.fireChange();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return n;
    }

    @Override
    protected int initSyntaxButton(int n, TargetChooserPanel<FileType> targetChooserPanel, TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        int n2 = super.initSyntaxButton(n, targetChooserPanel, targetChooserPanelGUI);
        this.getJspSyntaxButton().setMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_TagStandard_mnem").charAt(0));
        return n2;
    }

    public String getAccessibleDescription() {
        return "tag_file";
    }

    public String getErrorMessage(TargetChooserPanel<FileType> targetChooserPanel) {
        this.isTagFileValid = true;
        if (this.getWebModule() != null) {
            boolean bl = targetChooserPanel.getComponent().getSelectedFolder().equals("WEB-INF");
            if (!(targetChooserPanel.getComponent().getNormalizedFolder().startsWith("WEB-INF/tags") || targetChooserPanel.getComponent().getNormalizedFolder().startsWith(TAG_FILE_FOLDER) && bl)) {
                this.isTagFileValid = false;
                return NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_TagFile");
            }
        } else if (!targetChooserPanel.getComponent().getNormalizedFolder().startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
            this.isTagFileValid = false;
            return NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_TagFileInJavalib");
        }
        return null;
    }

    @Override
    public void initFolderValue(TargetChooserPanel<FileType> targetChooserPanel, String string, JTextField jTextField) {
        if (string != null && !string.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
            string = null;
        }
        if (this.getWebModule() != null) {
            boolean bl = targetChooserPanel.getComponent().getSelectedFolder().equals("WEB-INF");
            String string2 = "";
            if (!bl) {
                string2 = "WEB-INF/";
            }
            if (string == null || !string.startsWith(string2 + TAG_FILE_FOLDER)) {
                jTextField.setText(string2 + TAG_FILE_FOLDER + "/");
            } else {
                jTextField.setText(string);
            }
        } else if (string == null || !string.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
            jTextField.setText("META-INF/tags/");
        } else {
            jTextField.setText(string);
        }
    }

    public boolean isPanelValid() {
        return this.isTagFileValid;
    }

    @Override
    protected void checkBoxChanged(ItemEvent itemEvent, TargetChooserPanel<FileType> targetChooserPanel, TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        if (this.isSegment()) {
            if (this.isXml()) {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileSegmentXml"));
            } else {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileSegment"));
            }
            String string = targetChooserPanelGUI.getFile();
            if (string.endsWith("tagx")) {
                targetChooserPanelGUI.setFile(string.substring(0, string.length() - 1) + "f");
            } else if (string.endsWith("tag")) {
                targetChooserPanelGUI.setFile(string + "f");
            }
        } else {
            String string = targetChooserPanelGUI.getFile();
            if (this.isXml()) {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileXml"));
                if (string.endsWith("tagf")) {
                    targetChooserPanelGUI.setFile(string.substring(0, string.length() - 1) + "x");
                } else if (string.endsWith("tag")) {
                    targetChooserPanelGUI.setFile(string + "x");
                }
            } else {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFile"));
                if (string.endsWith("tagf") || string.endsWith("tagx")) {
                    targetChooserPanelGUI.setFile(string.substring(0, string.length() - 1));
                }
            }
        }
        targetChooserPanel.fireChange();
    }

    String getTagName() {
        return this.myTagName;
    }

    FileObject getTldFileObject() {
        return this.myTldFileObject;
    }

    boolean isTldCheckBoxSelected() {
        return this.myTldCheckBox.isSelected();
    }

    boolean tagNameExists(String string) {
        return this.myTagValues != null && this.myTagValues.contains(string);
    }

    boolean isValidTagName(String string) {
        if (string == null) {
            return false;
        }
        return XMLChar.isValidNCName((String)string);
    }

    boolean isTagNameEmpty(String string) {
        if (string == null) {
            return true;
        }
        return "".equals(string);
    }

    private void browse(ActionEvent actionEvent, TargetChooserPanel<FileType> targetChooserPanel, TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        Sources sources;
        FileObject fileObject = null;
        if (targetChooserPanel.getSourceGroups() != null) {
            fileObject = BrowseFolders.showDialog((SourceGroup[])targetChooserPanel.getSourceGroups(), TLDDataObject.class, (String)targetChooserPanelGUI.getFolder().replace(File.separatorChar, '/'));
        } else {
            sources = ProjectUtils.getSources((Project)targetChooserPanel.getProject());
            fileObject = BrowseFolders.showDialog((SourceGroup[])sources.getSourceGroups("generic"), DataFolder.class, (String)targetChooserPanelGUI.getFolder().replace(File.separatorChar, '/'));
        }
        if (fileObject != null) {
            this.myTldFileObject = fileObject;
            sources = Templates.getTargetFolder((WizardDescriptor)targetChooserPanel.getTemplateWizard());
            WebModule webModule = sources == null ? null : WebModule.getWebModule((FileObject)sources);
            this.myTldTextField.setText(FileUtil.getRelativePath((FileObject)(webModule == null ? targetChooserPanel.getProject().getProjectDirectory() : webModule.getDocumentBase()), (FileObject)fileObject));
            try {
                InputStream inputStream = this.myTldFileObject.getInputStream();
                this.myTagValues = Util.getTagValues(inputStream, new String[]{"tag", "tag-file"}, "name");
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "error", iOException);
            }
            catch (SAXException sAXException) {
                LOG.log(Level.FINE, "error", sAXException);
            }
            targetChooserPanel.fireChange();
        }
    }
}

