/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.css.visual.model.BorderModel;
import org.netbeans.modules.css.visual.model.ColorModel;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;

public class BorderData
extends PropertyData {
    PropertyData styleValue = new PropertyData();
    PropertyData colorValue = new PropertyData();
    PropertyWithUnitData widthValue = new PropertyWithUnitData();
    ColorModel colorModel = new ColorModel();
    public static final int ALL = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    private int borderSide = 0;

    public void setBorder(String boderStr) {
        this.setBorder(boderStr, 0);
    }

    public void setBorder(String boderStr, int side) {
        this.borderSide = side;
        if (boderStr != null) {
            StringTokenizer st;
            if ((boderStr = boderStr.toLowerCase()).indexOf("rgb") >= 0) {
                String borderColor = boderStr.substring(boderStr.indexOf("rgb"));
                String borderColorTrimmed = borderColor.replaceAll(" ", "");
                boderStr = boderStr.substring(0, boderStr.indexOf("rgb")) + " " + borderColorTrimmed;
            }
            if ((st = new StringTokenizer(boderStr)).hasMoreTokens()) {
                this.setWidth(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.setStyle(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.setColor(st.nextToken());
            }
        }
    }

    public void setWidth(String widthStr) {
        this.widthValue.setUnit(this.getUnit(widthStr));
        this.widthValue.setValue(widthStr.replaceAll(this.widthValue.getUnit(), "").trim());
    }

    private String getUnit(String positionStr) {
        DefaultComboBoxModel unitList = new BorderModel().getWidthUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!positionStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setStyle(String style) {
        this.styleValue.setValue(style);
    }

    public void setColor(String color) {
        if (color.toLowerCase().trim().startsWith("rgb")) {
            color = color.replaceAll(" ", "");
        }
        this.colorValue.setValue(color);
    }

    public void setWidthValue(String width) {
        this.widthValue.setValue(width);
    }

    public void setWidthUnit(String widthUnit) {
        this.widthValue.setUnit(widthUnit);
    }

    public String getStyle() {
        return this.styleValue.getValue();
    }

    public String getColor() {
        return this.colorValue.getValue();
    }

    public String getWidthValue() {
        return this.widthValue.getValue();
    }

    public String getWidthUnit() {
        return this.widthValue.getUnit();
    }

    @Override
    public String toString() {
        String borderString = "";
        if (!this.widthValue.toString().equals("")) {
            borderString = borderString + " " + this.widthValue.toString();
        }
        if (!this.styleValue.toString().equals("")) {
            borderString = borderString + " " + this.styleValue.toString();
        }
        if (!this.colorValue.toString().equals("")) {
            borderString = borderString + " " + this.colorValue.toString();
        }
        return borderString.trim();
    }
}

