/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.model.MarginPaddingModel;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class PaddingWidthField
extends JPanel {
    PropertyWithUnitData borderPaddingData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private JComboBox borderPaddingCombo;
    private JComboBox borderPaddingUnitCombo;

    public PaddingWidthField() {
        this.initComponents();
        this.borderPaddingCombo.setModel(this.marginPaddingModel.getPaddingList());
        this.borderPaddingUnitCombo.setModel(this.marginPaddingModel.getPaddingUnitList());
        final JTextField borderPaddingComboEditor = (JTextField)this.borderPaddingCombo.getEditor().getEditorComponent();
        borderPaddingComboEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaddingWidthField.this.borderPaddingUnitCombo.setEnabled(Utils.isInteger(borderPaddingComboEditor.getText()));
                    }
                });
            }
        });
    }

    public void setPaddingString(String paddingStr) {
        if (paddingStr != null && !paddingStr.equals("")) {
            if (Utils.isInteger(paddingStr)) {
                this.setWidthValue(paddingStr);
            } else {
                String unit = this.getUnit(paddingStr);
                this.setWidthUnit(unit);
                this.setWidthValue(paddingStr.replaceAll(unit, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    public String getPaddingString() {
        return this.borderPaddingData.toString();
    }

    private String getUnit(String paddingStr) {
        DefaultComboBoxModel unitList = this.marginPaddingModel.getPaddingUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!paddingStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setWidthValue(String value) {
        if (value == null || value.equals("")) {
            this.borderPaddingCombo.setSelectedIndex(0);
        } else {
            this.borderPaddingCombo.setSelectedItem(value);
            this.borderPaddingData.setValue(value);
        }
    }

    public void setWidthUnit(String value) {
        if (value == null || value.equals("")) {
            this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(value) != -1) {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf(value));
            } else {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
            }
            this.borderPaddingData.setUnit(value);
        }
    }

    private void initComponents() {
        this.borderPaddingCombo = new JComboBox();
        this.borderPaddingUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(5, 0));
        this.borderPaddingCombo.setEditable(true);
        this.borderPaddingCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaddingWidthField.this.borderPaddingComboActionPerformed(evt);
            }
        });
        this.borderPaddingCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PaddingWidthField.this.borderPaddingComboFocusLost(evt);
            }
        });
        this.borderPaddingCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PaddingWidthField.this.borderPaddingComboItemStateChanged(evt);
            }
        });
        this.add((Component)this.borderPaddingCombo, "Center");
        this.borderPaddingCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDIN_WIDTH_ACCESS_NAME"));
        this.borderPaddingCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDING_WIDTH_FIELD_ACCESS_DESC"));
        this.borderPaddingUnitCombo.setEnabled(false);
        this.borderPaddingUnitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PaddingWidthField.this.borderPaddingUnitComboItemStateChanged(evt);
            }
        });
        this.borderPaddingUnitCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PaddingWidthField.this.borderPaddingUnitComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderPaddingUnitCombo, "East");
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDING_WIDTH_UNIT_ACCESS_NAME"));
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PaddingWidthField.class, (String)"PADDING_WIDTH_UNIT_ACCESS_DESC"));
    }

    private void borderPaddingUnitComboFocusLost(FocusEvent evt) {
        this.setBorderPadding();
    }

    private void borderPaddingUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBorderPadding();
        }
    }

    public void setAccessibleName(String comboName, String unitName) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleName(comboName);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleName(unitName);
    }

    public void setAccessibleDescription(String comboDesc, String unitDesc) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleDescription(comboDesc);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleDescription(unitDesc);
    }

    private void borderPaddingComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.borderPaddingUnitCombo.setEnabled(Utils.isInteger(this.borderPaddingCombo.getSelectedItem().toString()));
            this.setBorderPadding();
        }
    }

    private void borderPaddingComboFocusLost(FocusEvent evt) {
        this.setBorderPadding();
    }

    private void borderPaddingComboActionPerformed(ActionEvent evt) {
        this.setBorderPadding();
    }

    private void setBorderPadding() {
        String oldValue = this.borderPaddingData.toString();
        this.borderPaddingData.setUnit(this.borderPaddingUnitCombo.getSelectedItem().toString());
        this.borderPaddingData.setValue(this.borderPaddingCombo.getSelectedItem().toString());
        this.firePropertyChange("margin-width", oldValue, this.borderPaddingData.toString());
    }
}

