/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.revert;

import java.io.File;
import java.util.Set;
import org.netbeans.modules.localhistory.ui.revert.RevertFileChanges;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.LifecycleManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RevertToAction
extends NodeAction {
    public RevertToAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        LifecycleManager.getDefault().saveAll();
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        File[] roots = rootSet.toArray(new File[rootSet.size()]);
        RevertFileChanges revertChanges = new RevertFileChanges();
        revertChanges.show(roots[0]);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null) {
            return false;
        }
        File[] roots = rootSet.toArray(new File[rootSet.size()]);
        return roots.length == 1 && roots[0].isFile();
    }

    public String getName() {
        return RevertToAction.getMenuName();
    }

    public static String getMenuName() {
        return NbBundle.getMessage(RevertToAction.class, (String)"LBL_RevertToAction");
    }
}

