/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchInfo;
import org.openidex.search.Utils;

final class SubnodesSearchInfo
implements SearchInfo.Files {
    private final Node node;

    public SubnodesSearchInfo(Node node) {
        this.node = node;
    }

    @Override
    public boolean canSearch() {
        Node[] nodes = this.node.getChildren().getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            SearchInfo searchInfo = Utils.getSearchInfo(nodes[i]);
            if (searchInfo == null || !searchInfo.canSearch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<DataObject> objectsToSearch() {
        return Utils.toDataObjectIterator(this.filesToSearch());
    }

    @Override
    public Iterator<FileObject> filesToSearch() {
        Node[] nodes = this.node.getChildren().getNodes(true);
        if (nodes.length == 0) {
            return SimpleSearchInfo.EMPTY_SEARCH_INFO.filesToSearch();
        }
        ArrayList<SearchInfo> searchInfoElements = new ArrayList<SearchInfo>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            SearchInfo subInfo = Utils.getSearchInfo(nodes[i]);
            if (subInfo == null || !subInfo.canSearch()) continue;
            searchInfoElements.add(subInfo);
        }
        int size = searchInfoElements.size();
        switch (size) {
            case 0: {
                return Collections.emptyList().iterator();
            }
            case 1: {
                return Utils.getFileObjectsIterator((SearchInfo)searchInfoElements.get(0));
            }
        }
        return new CompoundSearchIterator(searchInfoElements.toArray(new SearchInfo[size]));
    }
}

