/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class SourcesCurrentModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private static Logger logger = Logger.getLogger(SourcesCurrentModel.class.getName());
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = Collections.emptyList();
    private String[] unorderedOriginalSourceRoots;
    private String[] sortedOriginalSourceRoots;
    private int[] sourcePathPermutation;
    private Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private String projectRoot;
    private PropertyChangeListener mainProjectListener;
    private DebuggerManagerListener debuggerListener;
    private SourcePathProviderImpl currentSourcePathProvider;
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (SourcesCurrentModel.this.newSourceFileChooser == null) {
                SourcesCurrentModel.this.newSourceFileChooser = new JFileChooser();
                SourcesCurrentModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesCurrentModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            return false;
                        }
                    }
                });
            }
            if ((n = SourcesCurrentModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File file = SourcesCurrentModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!file.isDirectory() && !FileUtil.isArchiveFile((URL)file.toURI().toURL())) {
                        return;
                    }
                    String string = file.getCanonicalPath();
                    SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
                    synchronized (sourcesCurrentModel) {
                        SourcesCurrentModel.this.additionalSourceRoots.add(string);
                        SourcesCurrentModel.access$402(SourcesCurrentModel.this, SourcesCurrentModel.resize(SourcesCurrentModel.this.unorderedOriginalSourceRoots, 1));
                        SourcesCurrentModel.access$602(SourcesCurrentModel.this, SourcesCurrentModel.resize(SourcesCurrentModel.this.sortedOriginalSourceRoots, 1));
                        SourcesCurrentModel.access$702(SourcesCurrentModel.this, SourcesCurrentModel.resize(SourcesCurrentModel.this.sourcePathPermutation, 1));
                        ((SourcesCurrentModel)SourcesCurrentModel.this).unorderedOriginalSourceRoots[((SourcesCurrentModel)SourcesCurrentModel.this).unorderedOriginalSourceRoots.length - 1] = string;
                        ((SourcesCurrentModel)SourcesCurrentModel.this).sortedOriginalSourceRoots[((SourcesCurrentModel)SourcesCurrentModel.this).sortedOriginalSourceRoots.length - 1] = string;
                        ((SourcesCurrentModel)SourcesCurrentModel.this).sourcePathPermutation[((SourcesCurrentModel)SourcesCurrentModel.this).sourcePathPermutation.length - 1] = SourcesCurrentModel.this.sourcePathPermutation.length - 1;
                        SourcePathProviderImpl.storeSourceRootsOrder(SourcesCurrentModel.this.projectRoot, SourcesCurrentModel.this.unorderedOriginalSourceRoots, SourcesCurrentModel.this.sourcePathPermutation);
                    }
                    SourcesCurrentModel.this.saveAdditionalSourceRoots();
                    SourcesCurrentModel.this.fireTreeChanged();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                for (int i = 0; i < n; ++i) {
                    ArrayList<String> arrayList;
                    String string = (String)objectArray[i];
                    SourcesCurrentModel.this.additionalSourceRoots.remove(string);
                    SourcesCurrentModel.this.disabledSourceRoots.remove(string);
                    ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(SourcesCurrentModel.this.unorderedOriginalSourceRoots));
                    int n2 = arrayList2.indexOf(string);
                    if (n2 >= 0) {
                        int n3;
                        arrayList2.remove(n2);
                        SourcesCurrentModel.access$402(SourcesCurrentModel.this, arrayList2.toArray(new String[0]));
                        int n4 = SourcesCurrentModel.this.sourcePathPermutation[n2];
                        for (n3 = 0; n3 < SourcesCurrentModel.this.sourcePathPermutation.length; ++n3) {
                            if (SourcesCurrentModel.this.sourcePathPermutation[n3] <= n4) continue;
                            int[] nArray = SourcesCurrentModel.this.sourcePathPermutation;
                            int n5 = n3;
                            nArray[n5] = nArray[n5] - 1;
                        }
                        for (n3 = n2; n3 < SourcesCurrentModel.this.sourcePathPermutation.length - 1; ++n3) {
                            ((SourcesCurrentModel)SourcesCurrentModel.this).sourcePathPermutation[n3] = SourcesCurrentModel.this.sourcePathPermutation[n3 + 1];
                        }
                    }
                    if ((n2 = (arrayList = new ArrayList<String>(Arrays.asList(SourcesCurrentModel.this.sortedOriginalSourceRoots))).indexOf(string)) < 0) continue;
                    arrayList.remove(n2);
                    SourcesCurrentModel.access$602(SourcesCurrentModel.this, arrayList.toArray(new String[0]));
                }
                SourcesCurrentModel.access$702(SourcesCurrentModel.this, SourcesCurrentModel.resize(SourcesCurrentModel.this.sourcePathPermutation, -n));
                SourcesCurrentModel.this.saveAdditionalSourceRoots();
                SourcesCurrentModel.this.saveDisabledSourceRoots();
                SourcePathProviderImpl.storeSourceRootsOrder(SourcesCurrentModel.this.projectRoot, SourcesCurrentModel.this.unorderedOriginalSourceRoots, SourcesCurrentModel.this.sourcePathPermutation);
            }
            SourcesCurrentModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_UP_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_MoveUpSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object object) {
            if ("Root".equals(object)) {
                return false;
            }
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                return SourcesCurrentModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesCurrentModel.this.sortedOriginalSourceRoots[0].equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                String[] stringArray = SourcesCurrentModel.this.sortedOriginalSourceRoots;
                int n2 = stringArray.length;
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    for (n3 = 0; n3 < n && !stringArray[i].equals(objectArray[n3]); ++n3) {
                    }
                    if (n3 < n) {
                        if (i <= 0) continue;
                        nArray[i] = nArray[i - 1];
                        nArray[i - 1] = i;
                        continue;
                    }
                    nArray[i] = i;
                }
                if (SourcesCurrentModel.this.currentSourcePathProvider != null) {
                    SourcesCurrentModel.this.currentSourcePathProvider.reorderOriginalSourceRoots(nArray);
                } else {
                    SourcesCurrentModel.this.reorderOriginalSourceRoots(nArray);
                }
            }
            SourcesCurrentModel.this.fireTreeChanged();
            SourcesCurrentModel.this.fireSelectedNodes(objectArray);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_DOWN_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_MoveDownSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object object) {
            if ("Root".equals(object)) {
                return false;
            }
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                return SourcesCurrentModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesCurrentModel.this.sortedOriginalSourceRoots[SourcesCurrentModel.this.sortedOriginalSourceRoots.length - 1].equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                String[] stringArray = SourcesCurrentModel.this.sortedOriginalSourceRoots;
                int n2 = stringArray.length;
                int[] nArray = new int[n2];
                for (int i = n2 - 1; i >= 0; --i) {
                    int n3;
                    for (n3 = 0; n3 < n && !stringArray[i].equals(objectArray[n3]); ++n3) {
                    }
                    if (n3 < n) {
                        if (i >= n2 - 1) continue;
                        nArray[i] = nArray[i + 1];
                        nArray[i + 1] = i;
                        continue;
                    }
                    nArray[i] = i;
                }
                if (SourcesCurrentModel.this.currentSourcePathProvider != null) {
                    SourcesCurrentModel.this.currentSourcePathProvider.reorderOriginalSourceRoots(nArray);
                } else {
                    SourcesCurrentModel.this.reorderOriginalSourceRoots(nArray);
                }
            }
            SourcesCurrentModel.this.fireTreeChanged();
            SourcesCurrentModel.this.fireSelectedNodes(objectArray);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action RESET_ORDER_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_ResetOrderSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            if (SourcesCurrentModel.this.currentSourcePathProvider != null) {
                SourcesCurrentModel.this.currentSourcePathProvider.reorderOriginalSourceRoots(null);
            } else {
                SourcesCurrentModel.this.reorderOriginalSourceRoots(null);
            }
            SourcesCurrentModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesCurrentModel() {
        this.bindWithSourcePathProvider();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.MOVE_UP_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.MOVE_DOWN_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.RESET_ORDER_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
    }

    private void bindWithSourcePathProvider() {
        this.debuggerListener = new DebuggerManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("currentSession".equals(string)) {
                    Object object;
                    Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
                    SourcePathProviderImpl sourcePathProviderImpl = null;
                    if (session != null) {
                        object = session.lookup(null, SourcePathProvider.class);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            SourcePathProvider sourcePathProvider = (SourcePathProvider)iterator.next();
                            if (!(sourcePathProvider instanceof SourcePathProviderImpl)) continue;
                            sourcePathProviderImpl = (SourcePathProviderImpl)sourcePathProvider;
                            SourcesCurrentModel.this.setSources(sourcePathProviderImpl);
                            break;
                        }
                    }
                    object = this;
                    synchronized (object) {
                        SourcesCurrentModel.this.currentSourcePathProvider = sourcePathProviderImpl;
                    }
                    SourcesCurrentModel.this.fireTreeChanged();
                }
            }
        };
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.debuggerListener, (Object)DebuggerManager.getDebuggerManager()));
    }

    private synchronized void setSources(SourcePathProviderImpl sourcePathProviderImpl) {
        this.currentSourcePathProvider = sourcePathProviderImpl;
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            String[] stringArray = this;
            synchronized (this) {
                String[] stringArray2;
                List<Object> list;
                if (this.currentSourcePathProvider != null) {
                    this.sortedOriginalSourceRoots = this.currentSourcePathProvider.getSourceRoots();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.sortedOriginalSourceRoots;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (this.mainProjectListener == null) {
                    this.mainProjectListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            SourcesCurrentModel.this.fireTreeChanged();
                        }
                    };
                    MainProjectManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.mainProjectListener, (Object)MainProjectManager.getDefault()));
                }
                stringArray = MainProjectManager.getDefault().getMainProject();
                String string = null;
                if (stringArray != null) {
                    list = SourcesCurrentModel.getProjectSources((Project)stringArray);
                    stringArray2 = new String[list.size()];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray2[i] = SourcePathProviderImpl.getRoot(list.get(i));
                    }
                    try {
                        string = stringArray.getProjectDirectory().getURL().toExternalForm();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {}
                } else {
                    stringArray2 = new String[]{};
                }
                list = null;
                String[] stringArray3 = this;
                synchronized (this) {
                    if (string != null) {
                        list = this.loadAdditionalSourceRoots(string);
                    }
                    list = list == null ? new ArrayList<FileObject>() : new ArrayList<FileObject>(list);
                    this.additionalSourceRoots = list;
                    this.disabledSourceRoots = this.loadDisabledSourceRoots(string);
                    this.disabledSourceRoots = this.disabledSourceRoots == null ? new HashSet<String>() : new HashSet<String>(this.disabledSourceRoots);
                    this.projectRoot = string;
                    // ** MonitorExit[var8_11] (shouldn't be in output)
                    stringArray3 = new String[stringArray2.length + list.size()];
                    System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                    System.arraycopy(list.toArray(), 0, stringArray3, stringArray2.length, list.size());
                    Map<String, Integer> map = SourcePathProviderImpl.getSourceRootsOrder(string);
                    Object[] objectArray = new String[stringArray3.length];
                    int[] nArray = SourcePathProviderImpl.createPermutation(stringArray3, map, (String[])objectArray);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("getChildren(): orderIndexes = " + map + ", sourcePathPermutation = " + Arrays.toString(nArray));
                        logger.fine("    sorted roots = " + Arrays.toString(objectArray));
                        logger.fine("  sourcePathPermutation = " + Arrays.toString(nArray));
                    }
                    n2 = Math.min(objectArray.length, n2);
                    n = Math.min(objectArray.length, n);
                    Object[] objectArray2 = new Object[n2 - n];
                    System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
                    String[] stringArray4 = this;
                    synchronized (this) {
                        this.unorderedOriginalSourceRoots = stringArray3;
                        this.sortedOriginalSourceRoots = objectArray;
                        this.sourcePathPermutation = nArray;
                        // ** MonitorExit[var13_17] (shouldn't be in output)
                        return objectArray2;
                    }
                }
            }
        }
        throw new UnknownTypeException(object);
    }

    private List<String> loadAdditionalSourceRoots(String string) {
        if (string == null) {
            return null;
        }
        return (List)this.sourcesProperties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(string);
    }

    private Set<String> loadDisabledSourceRoots(String string) {
        if (string == null) {
            return null;
        }
        return (Set)this.sourcesProperties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(string);
    }

    private static List<FileObject> getProjectSources(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/boot");
            if (classPath == null) continue;
            SourcesCurrentModel.addSourceRoots(classPath, arrayList, hashSet, hashSet2);
        }
        for (SourceGroup sourceGroup : sourceGroupArray) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/execute");
            if (classPath == null) continue;
            SourcesCurrentModel.addSourceRoots(classPath, arrayList, hashSet, hashSet2);
        }
        for (SourceGroup sourceGroup : sourceGroupArray) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/source");
            if (classPath == null) continue;
            SourcesCurrentModel.addSourceRoots(classPath, arrayList, hashSet2);
        }
        return arrayList;
    }

    private static void addSourceRoots(ClassPath classPath, List<FileObject> list, Set<FileObject> set, Set<FileObject> set2) {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = classPath.getRoots()) {
            if (set.contains(fileObject)) continue;
            set.add(fileObject);
            try {
                FileObject[] fileObjectArray2;
                for (FileObject fileObject2 : fileObjectArray2 = SourceForBinaryQuery.findSourceRoots((URL)fileObject.getURL()).getRoots()) {
                    if (set2.contains(fileObject2)) continue;
                    list.add(fileObject2);
                    set2.add(fileObject2);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
    }

    private static void addSourceRoots(ClassPath classPath, List<FileObject> list, Set<FileObject> set) {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = classPath.getRoots()) {
            if (set.contains(fileObject) || fileObject.isVirtual()) continue;
            list.add(fileObject);
            set.add(fileObject);
        }
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    private void fireSelectedNodes(Object[] objectArray) {
        ModelEvent.SelectionChanged selectionChanged = new ModelEvent.SelectionChanged((Object)this, objectArray);
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)selectionChanged);
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (this.additionalSourceRoots.contains((String)object)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String string) {
        SourcesCurrentModel sourcesCurrentModel = this;
        synchronized (sourcesCurrentModel) {
            return !this.disabledSourceRoots.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String string, boolean bl) {
        SourcesCurrentModel sourcesCurrentModel = this;
        synchronized (sourcesCurrentModel) {
            if (bl) {
                this.disabledSourceRoots.remove(string);
            } else {
                this.disabledSourceRoots.add(string);
            }
            this.saveDisabledSourceRoots();
        }
    }

    private synchronized void saveDisabledSourceRoots() {
        Map map = this.sourcesProperties.getProperties("source_roots").getMap("project_disabled", new HashMap());
        map.put(this.projectRoot, this.disabledSourceRoots);
        this.sourcesProperties.getProperties("source_roots").setMap("project_disabled", map);
    }

    private synchronized void saveAdditionalSourceRoots() {
        Map map = this.sourcesProperties.getProperties("additional_source_roots").getMap("project", new HashMap());
        map.put(this.projectRoot, this.additionalSourceRoots);
        this.sourcesProperties.getProperties("additional_source_roots").setMap("project", map);
    }

    public boolean isCheckable(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public void setSelected(NodeModel nodeModel, Object object, Boolean bl) throws UnknownTypeException {
        if (object instanceof String) {
            this.setEnabled((String)object, bl);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getDisplayName(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getShortDescription(object);
    }

    public synchronized void reorderOriginalSourceRoots(int[] nArray) {
        String[] stringArray = this.sortedOriginalSourceRoots;
        if (nArray == null) {
            for (int i = 0; i < this.sourcePathPermutation.length; ++i) {
                this.sourcePathPermutation[i] = i;
            }
            this.sortedOriginalSourceRoots = this.unorderedOriginalSourceRoots;
            stringArray = this.unorderedOriginalSourceRoots;
        } else {
            int n;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("reorderOriginalSourceRoots(" + Arrays.toString(nArray));
            }
            if (stringArray.length != nArray.length) {
                throw new IllegalArgumentException("Bad length of permutation: " + nArray.length + ", have " + stringArray.length + " source roots.");
            }
            int n2 = nArray.length;
            String[] stringArray2 = this.unorderedOriginalSourceRoots;
            Object[] objectArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.sourcePathPermutation[nArray[n]];
                objectArray[n] = stringArray2[nArray[n]];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
            }
            for (n = 0; n < n2; ++n) {
                this.sourcePathPermutation[n] = nArray[n];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  => sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
                logger.fine("  => sorted roots = " + Arrays.toString(objectArray));
            }
            this.sortedOriginalSourceRoots = objectArray;
            stringArray = stringArray2;
        }
        SourcePathProviderImpl.storeSourceRootsOrder(this.projectRoot, stringArray, this.sourcePathPermutation);
    }

    private static String[] resize(String[] stringArray, int n) {
        int n2 = stringArray.length + n;
        String[] stringArray2 = new String[n2];
        n2 = Math.min(n2, stringArray.length);
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    private static int[] resize(int[] nArray, int n) {
        int n2 = nArray.length + n;
        int[] nArray2 = new int[n2];
        n2 = Math.min(n2, nArray.length);
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    static /* synthetic */ String[] access$402(SourcesCurrentModel sourcesCurrentModel, String[] stringArray) {
        sourcesCurrentModel.unorderedOriginalSourceRoots = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$602(SourcesCurrentModel sourcesCurrentModel, String[] stringArray) {
        sourcesCurrentModel.sortedOriginalSourceRoots = stringArray;
        return stringArray;
    }

    static /* synthetic */ int[] access$702(SourcesCurrentModel sourcesCurrentModel, int[] nArray) {
        sourcesCurrentModel.sourcePathPermutation = nArray;
        return nArray;
    }
}

