/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.openide.util.NbBundle;

public class FunctionBreakpoint
extends CndBreakpoint {
    public static final String PROP_FUNCTION_NAME = "functionName";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_FUNCTION_ENTRY = 1;
    public static final int TYPE_FUNCTION_EXIT = 2;
    private String function = "";
    private int type;

    private FunctionBreakpoint() {
    }

    public static FunctionBreakpoint create(String function) {
        FunctionBreakpointComparable b = new FunctionBreakpointComparable();
        b.setFunctionName(function);
        b.setPrintText(NbBundle.getBundle(FunctionBreakpoint.class).getString("CTL_Function_Breakpoint_Print_Text"));
        return b;
    }

    public String getFunctionName() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFunctionName(String function) {
        String old = this.function;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            int i;
            if (function == null) {
                function = "";
            }
            if ((i = function.indexOf("(void)")) > 0) {
                function = function.substring(0, i + 1) + function.substring(i + 5);
            }
            if (function.equals(this.function)) {
                return;
            }
            this.function = function;
            this.firePropertyChange(PROP_FUNCTION_NAME, old, function);
        }
    }

    public void setBreakpointType(int type) {
        this.type = type;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public String toString() {
        return "FunctionBreakpoint " + this.function;
    }

    private static class FunctionBreakpointComparable
    extends FunctionBreakpoint
    implements Comparable {
        private FunctionBreakpointComparable() {
        }

        public int compareTo(Object o) {
            if (o instanceof FunctionBreakpointComparable) {
                FunctionBreakpointComparable fbthis = this;
                FunctionBreakpoint fb = (FunctionBreakpoint)((Object)o);
                return ((FunctionBreakpoint)fbthis).function.compareTo(fb.function);
            }
            return -1;
        }
    }
}

