/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.ignore;

import java.io.File;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.nodes.Node;

public class IgnoreAction
extends AbstractSystemAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        int actionStatus = this.getActionStatus(activatedNodes, true);
        switch (actionStatus) {
            case 0: 
            case 1: {
                return "CTL_MenuItem_Ignore";
            }
            case 2: {
                return "CTL_MenuItem_Unignore";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    public int getActionStatus(Node[] nodes, boolean cached) {
        return this.getActionStatus((cached ? this.getCachedContext(nodes) : this.getContext(nodes)).getFiles(), cached);
    }

    @Override
    protected int getFileEnabledStatus() {
        return 6;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 6;
    }

    public int getActionStatus(File[] files, boolean cached) {
        int actionStatus = -1;
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            int status;
            FileInformation info = cached ? cache.getCachedStatus(files[i]) : cache.getStatus(files[i]);
            int n = status = info == null ? 8 : info.getStatus();
            if (status == 4) {
                actionStatus = actionStatus == -1 || actionStatus == 1 ? 1 : 0;
                continue;
            }
            if (status == 2) {
                actionStatus = actionStatus == -1 || actionStatus == 2 ? 2 : 0;
                continue;
            }
            actionStatus = 0;
            break;
        }
        return actionStatus == -1 ? 0 : actionStatus;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return this.getActionStatus(nodes, true) != 0;
    }

    @Override
    public void performCvsAction(Node[] nodes) {
        int actionStatus = this.getActionStatus(nodes, false);
        if (actionStatus == 1) {
            CvsVersioningSystem.getInstance().setIgnored(Utils.getCurrentContext(nodes).getFiles());
        } else if (actionStatus == 2) {
            CvsVersioningSystem.getInstance().setNotignored(Utils.getCurrentContext(nodes).getFiles());
        } else {
            throw new RuntimeException("Invalid action status: " + actionStatus);
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

