/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Date;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditorSupport;

public abstract class FileEnvironment
implements CloneableEditorSupport.Env {
    private static final long serialVersionUID = 1L;
    private String mime = "text/plain";
    private final File peer;
    private final String revision;
    private transient Date modified;

    public FileEnvironment(File baseFile, String revision, String mime) {
        if (baseFile == null) {
            throw new NullPointerException();
        }
        this.peer = baseFile;
        this.modified = new Date();
        this.revision = revision;
        if (mime != null) {
            this.mime = mime;
        }
    }

    public void markModified() throws IOException {
        throw new IOException("r/o");
    }

    public void unmarkModified() {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public boolean isModified() {
        return false;
    }

    public Date getTime() {
        return this.modified;
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
    }

    public boolean isValid() {
        return true;
    }

    public OutputStream outputStream() throws IOException {
        throw new IOException("r/o");
    }

    public String getMimeType() {
        return this.mime;
    }

    public InputStream inputStream() throws IOException {
        return new LazyInputStream();
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    private class LazyInputStream
    extends InputStream {
        private InputStream in;

        private InputStream peer() throws IOException {
            try {
                if (this.in == null) {
                    File remoteFile = VersionsCache.getInstance().getRemoteFile(FileEnvironment.this.peer, FileEnvironment.this.revision, null);
                    this.in = new FileInputStream(remoteFile);
                }
                return this.in;
            }
            catch (MalformedURLException ex) {
                ErrorManager err = ErrorManager.getDefault();
                IOException ioex = new IOException();
                err.annotate((Throwable)ioex, (Throwable)ex);
                err.annotate((Throwable)ioex, 256, null, null, null, null);
                throw ioex;
            }
            catch (IOException ex) {
                ErrorManager err = ErrorManager.getDefault();
                IOException ioex = new IOException();
                err.annotate((Throwable)ioex, (Throwable)ex);
                err.annotate((Throwable)ioex, 256, null, null, null, null);
                throw ioex;
            }
            catch (CommandException ex) {
                ErrorManager err = ErrorManager.getDefault();
                IOException ioex = new IOException();
                err.annotate((Throwable)ioex, (Throwable)ex);
                err.annotate((Throwable)ioex, 256, null, null, null, null);
                throw ioex;
            }
            catch (IllegalCommandException ex) {
                ErrorManager err = ErrorManager.getDefault();
                IOException ioex = new IOException();
                err.annotate((Throwable)ioex, (Throwable)ex);
                err.annotate((Throwable)ioex, 256, null, null, null, null);
                throw ioex;
            }
            catch (AuthenticationException ex) {
                ErrorManager err = ErrorManager.getDefault();
                IOException ioex = new IOException();
                err.annotate((Throwable)ioex, (Throwable)ex);
                err.annotate((Throwable)ioex, 256, null, null, null, null);
                throw ioex;
            }
            catch (NotVersionedException ex) {
                ErrorManager err = ErrorManager.getDefault();
                IOException ioex = new IOException();
                err.annotate((Throwable)ioex, (Throwable)ex);
                err.annotate((Throwable)ioex, 256, null, null, null, null);
                throw ioex;
            }
        }

        @Override
        public int available() throws IOException {
            return this.peer().available();
        }

        @Override
        public void close() throws IOException {
            this.peer().close();
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            return this.peer().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.peer().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.peer().read(b, off, len);
        }

        @Override
        public void reset() throws IOException {
            this.peer().reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.peer().skip(n);
        }
    }
}

