/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.sequece;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanel;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanelListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.preview.SequencePreviewPanel;
import org.openide.util.NbBundle;

public class SequenceContainerEditor
extends JPanel
implements SequenceEditingPanelListener,
SequenceContainerListener,
PropertyChangeListener {
    private SequenceContainer sequenceContainer;
    private Map<Sequence, JComponent> previewMap = new HashMap<Sequence, JComponent>();
    private JPanel previewsPanel;
    private JScrollPane scrollPreviews;
    private JPanel editorsPanel;
    private JScrollPane scrollEditors;
    private int syncComponentHeight = 0;
    private int maxFrameCount = 0;
    private int filmUnitWidth = 0;

    public SequenceContainerEditor(SequenceContainer sequenceContainer) {
        this.setBackground(Color.WHITE);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SequenceContainerEditor.class, (String)"SequenceContainerEditor.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SequenceContainerEditor.class, (String)"SequenceContainerEditor.accessible.description"));
        this.sequenceContainer = sequenceContainer;
        this.sequenceContainer.addSequenceContainerListener(this);
        this.sequenceContainer.addPropertyChangeListener(this);
        this.setSyncComponentHeight();
        this.rebuildUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
            Sequence sequence = (Sequence)propertyChangeEvent.getOldValue();
            Sequence sequence2 = (Sequence)propertyChangeEvent.getNewValue();
            SequencePreviewPanel sequencePreviewPanel = (SequencePreviewPanel)this.previewMap.get(sequence);
            SequencePreviewPanel sequencePreviewPanel2 = (SequencePreviewPanel)this.previewMap.get(sequence2);
            if (sequencePreviewPanel != null) {
                sequencePreviewPanel.setImportant(false);
            }
            if (sequencePreviewPanel2 != null) {
                sequencePreviewPanel2.setImportant(true);
            }
        }
    }

    private void rebuildUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SequenceContainerEditor.this.removeAll();
                SequenceContainerEditor.this.previewMap.clear();
                for (Sequence sequence : SequenceContainerEditor.this.sequenceContainer.getSequences()) {
                    ((SequenceEditingPanel)sequence.getEditor()).removeSequenceEditingPanelListener(SequenceContainerEditor.this);
                }
                SequenceContainerEditor.this.previewsPanel = new FastScrollPanel();
                SequenceContainerEditor.this.editorsPanel = new FastScrollPanel();
                SequenceContainerEditor.this.initScrolling();
                SequenceContainerEditor.this.initPreviews();
                SequenceContainerEditor.this.initEditors();
                SequenceContainerEditor.this.setLayout(new BorderLayout());
                SequenceContainerEditor.this.add((Component)SequenceContainerEditor.this.scrollPreviews, "West");
                SequenceContainerEditor.this.add((Component)SequenceContainerEditor.this.scrollEditors, "Center");
                SequenceContainerEditor.this.validate();
            }
        });
    }

    private void setSyncComponentHeight() {
        Sequence sequence = this.sequenceContainer.getDefaultSequence();
        JComponent jComponent = sequence.getPreview();
        JComponent jComponent2 = sequence.getEditor();
        this.syncComponentHeight = Math.max(jComponent.getPreferredSize().height, jComponent2.getPreferredSize().height);
    }

    private void initPreviews() {
        this.previewsPanel.setBackground(Color.WHITE);
        this.previewsPanel.setLayout(new BoxLayout(this.previewsPanel, 1));
        for (Sequence sequence : this.sequenceContainer.getSequences()) {
            this.addPreviewForSequence(sequence);
        }
    }

    private void addPreviewForSequence(Sequence sequence) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        SequencePreviewPanel sequencePreviewPanel = (SequencePreviewPanel)sequence.getPreview();
        sequencePreviewPanel.setSequenceContainer(this.sequenceContainer);
        if (this.sequenceContainer.getDefaultSequence() == sequence) {
            sequencePreviewPanel.setImportant(true);
        } else {
            sequencePreviewPanel.setImportant(false);
        }
        jPanel.add(sequencePreviewPanel);
        Dimension dimension = new Dimension(0, this.syncComponentHeight);
        Dimension dimension2 = new Dimension(0, this.syncComponentHeight);
        Dimension dimension3 = new Dimension(0, this.syncComponentHeight);
        jPanel.add(new Box.Filler(dimension, dimension2, dimension3));
        this.previewsPanel.add(jPanel);
        this.previewMap.put(sequence, sequencePreviewPanel);
    }

    private void initEditors() {
        this.editorsPanel.setBackground(Color.WHITE);
        this.editorsPanel.setLayout(new BoxLayout(this.editorsPanel, 1));
        Color color = new Color(245, 245, 255);
        Color color2 = Color.WHITE;
        int n = 0;
        for (Sequence sequence : this.sequenceContainer.getSequences()) {
            Color color3 = n++ % 2 == 0 ? color : color2;
            this.addEditorForSequence(sequence, color3);
        }
    }

    private void addEditorForSequence(Sequence sequence, Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        SequenceEditingPanel sequenceEditingPanel = (SequenceEditingPanel)sequence.getEditor();
        sequenceEditingPanel.setBackground(color);
        sequenceEditingPanel.addSequenceEditingPanelListener(this);
        sequenceEditingPanel.setSequenceContainer(this.sequenceContainer);
        jPanel.add(sequenceEditingPanel);
        Dimension dimension = new Dimension(0, this.syncComponentHeight);
        Dimension dimension2 = new Dimension(0, this.syncComponentHeight);
        Dimension dimension3 = new Dimension(0, this.syncComponentHeight);
        jPanel.add(new Box.Filler(dimension, dimension2, dimension3));
        this.editorsPanel.add(jPanel);
    }

    private void initScrolling() {
        this.scrollPreviews = new JScrollPane(this.previewsPanel);
        this.scrollPreviews.setHorizontalScrollBarPolicy(31);
        this.scrollPreviews.setVerticalScrollBarPolicy(21);
        this.scrollPreviews.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPreviews.getViewport().setBackground(Color.WHITE);
        this.scrollEditors = new JScrollPane(this.editorsPanel);
        this.scrollEditors.setBorder(BorderFactory.createEmptyBorder());
        this.scrollEditors.getViewport().setBackground(Color.WHITE);
        this.scrollEditors.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Point point = SequenceContainerEditor.this.scrollPreviews.getViewport().getViewPosition();
                Point point2 = SequenceContainerEditor.this.scrollEditors.getViewport().getViewPosition();
                Point point3 = new Point(point.x, point2.y);
                SequenceContainerEditor.this.scrollPreviews.getViewport().setViewPosition(point3);
            }
        });
    }

    @Override
    public void frameHilited(SequenceEditingPanel sequenceEditingPanel, int n) {
        ((SequencePreviewPanel)this.previewMap.get(sequenceEditingPanel.getSequence())).requestPreviewFrame(n);
    }

    @Override
    public void hiliteLost(SequenceEditingPanel sequenceEditingPanel) {
        ((SequencePreviewPanel)this.previewMap.get(sequenceEditingPanel.getSequence())).requestPreviewFrame(0);
    }

    @Override
    public void frameSelectionChange(SequenceEditingPanel sequenceEditingPanel, int[] nArray) {
    }

    @Override
    public void sequenceAdded(SequenceContainer sequenceContainer, Sequence sequence, int n) {
        this.rebuildUI();
    }

    @Override
    public void sequenceRemoved(SequenceContainer sequenceContainer, Sequence sequence, int n) {
        this.rebuildUI();
    }

    @Override
    public void sequenceMoved(SequenceContainer sequenceContainer, Sequence sequence, int n, int n2) {
    }

    class RulerHorizontal
    extends JComponent {
        private static final int SIZE = 18;
        private static final boolean DEBUG = false;

        public RulerHorizontal() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return NbBundle.getMessage(SequenceContainerEditor.class, (String)"SequenceContainerEditor.ruler.tooltip", (Object)this.getColumnAtPoint(mouseEvent.getPoint()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = SequenceContainerEditor.this.editorsPanel.getPreferredSize();
            dimension.height = 18;
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(rectangle);
            int n2 = 1 + SequenceContainerEditor.this.filmUnitWidth;
            for (int i = rectangle.x / n2 * n2; i <= rectangle.x + rectangle.width && (n = i / n2) < SequenceContainerEditor.this.maxFrameCount; i += n2) {
                boolean bl = true;
                graphics2D.setColor(new Color(240, 238, 230));
                graphics2D.fill3DRect(i, 0, n2, 18, bl);
            }
        }

        private int getColumnAtPoint(Point point) {
            return this.getColumnAtCoordinates(point.x, point.y);
        }

        private int getColumnAtCoordinates(int n, int n2) {
            return (n - 1) / (SequenceContainerEditor.this.filmUnitWidth + 1);
        }
    }

    private static class FastScrollPanel
    extends JPanel
    implements Scrollable {
        private FastScrollPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

