/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.TabContentPane;
import org.openide.util.ImageUtilities;

class TabbedPane
extends JPanel
implements Constants {
    private final JComponent[] tabs;
    private final TabButton[] buttons;
    private final JComponent tabHeader;
    private final JPanel tabContent;
    private boolean[] tabAdded;
    private int selTabIndex = -1;
    private static final Color COLOR_UNSEL = new Color(173, 175, 176);
    private static final Color COLOR_SEL = new Color(255, 255, 255);
    private static final Insets insets = new Insets(23, 19, 6, 10);

    public TabbedPane(JComponent ... tabs) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.tabs = tabs;
        this.tabAdded = new boolean[tabs.length];
        Arrays.fill(this.tabAdded, false);
        for (JComponent c : tabs) {
            c.putClientProperty("print.printable", Boolean.TRUE);
            c.putClientProperty("print.name", c.getName());
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabButton btn = (TabButton)e.getSource();
                TabbedPane.this.switchTab(btn.getTabIndex());
                WelcomeOptions.getDefault().setLastActiveTab(btn.getTabIndex());
            }
        };
        this.buttons = new TabButton[tabs.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new TabButton(tabs[i].getName(), i);
            this.buttons[i].addActionListener(al);
        }
        this.tabHeader = new TabHeader(this.buttons);
        this.add((Component)this.tabHeader, "North");
        this.tabContent = new TabContentPane();
        this.add((Component)this.tabContent, "Center");
        int activeTabIndex = WelcomeOptions.getDefault().getLastActiveTab();
        if (WelcomeOptions.getDefault().isSecondStart() && activeTabIndex < 0) {
            activeTabIndex = 1;
            WelcomeOptions.getDefault().setLastActiveTab(1);
        }
        activeTabIndex = Math.max(0, activeTabIndex);
        activeTabIndex = Math.min(activeTabIndex, tabs.length - 1);
        this.switchTab(activeTabIndex);
    }

    private void switchTab(int tabIndex) {
        if (!this.tabAdded[tabIndex]) {
            this.tabContent.add((Component)this.tabs[tabIndex], new GridBagConstraints(tabIndex, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tabAdded[tabIndex] = true;
        }
        if (this.selTabIndex >= 0) {
            this.buttons[this.selTabIndex].setSelected(false);
        }
        JComponent compToShow = this.tabs[tabIndex];
        JComponent compToHide = this.selTabIndex >= 0 ? this.tabs[this.selTabIndex] : null;
        this.selTabIndex = tabIndex;
        this.buttons[this.selTabIndex].setSelected(true);
        if (null != compToHide) {
            compToHide.setVisible(false);
        }
        compToShow.setVisible(true);
        compToShow.requestFocusInWindow();
    }

    @Override
    public Dimension getPreferredSize() {
        Container scroll;
        Dimension d = super.getPreferredSize();
        if (null != this.getParent() && null != this.getParent().getParent() && (scroll = this.getParent().getParent()).getWidth() > 0) {
            if (d.width > scroll.getWidth()) {
                d.width = Math.max(scroll.getWidth(), 600 + (int)((double)(FONT_SIZE - 11) / 11.0 * 600.0));
            } else if (d.width < scroll.getWidth()) {
                d.width = scroll.getWidth();
            }
        }
        d.width = Math.min(d.width, 1000);
        return d;
    }

    private class TabHeader
    extends JPanel {
        private final Image[] sel;
        private final Image[] unsel;
        private final TabButton[] buttons;
        private final Image imgSelTopLeft1;
        private final Image imgSelTopLeft2;
        private final Image imgSelTop;
        private final Image imgSelLeft1;
        private final Image imgSelLeft2;
        private final Image imgSelTopRight1;
        private final Image imgSelTopRight2;
        private final Image imgSelRight1;
        private final Image imgSelRight2;
        private final Image imgUnselTopLeft1;
        private final Image imgUnselLeft1;
        private final Image imgUnselLeftTop1;
        private final Image imgUnselBottomLeft1;
        private final Image imgUnselTopRight1;
        private final Image imgUnselRight1;
        private final Image imgUnselRightTop1;
        private final Image imgUnselBottomRight1;
        private final Image imgUnselTopLeft2;
        private final Image imgUnselLeft2;
        private final Image imgUnselBottomLeft2;
        private final Image imgUnselTopRight2;
        private final Image imgUnselRight2;
        private final Image imgUnselBottomRight2;
        private final Image imgUnselTopRight3;
        private final Image imgUnselRight3;
        private final Image imgUnselBottomRight3;
        private final Image imgUnselTop;
        private final Image imgUnselBottom;
        private final Image imgUnselFiller;

        public TabHeader(TabButton ... buttons) {
            super(new GridLayout(1, 0));
            this.imgSelTopLeft1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_topleft1.png");
            this.imgSelTopLeft2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_topleft2.png");
            this.imgSelTop = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_top.png");
            this.imgSelLeft1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_left1.png");
            this.imgSelLeft2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_left2.png");
            this.imgSelTopRight1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_topright1.png");
            this.imgSelTopRight2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_topright2.png");
            this.imgSelRight1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_right1.png");
            this.imgSelRight2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_right2.png");
            this.imgUnselTopLeft1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_topleft1.png");
            this.imgUnselLeft1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_left1.png");
            this.imgUnselLeftTop1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_lefttop1.png");
            this.imgUnselBottomLeft1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottomleft1.png");
            this.imgUnselTopRight1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_topright1.png");
            this.imgUnselRight1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_right1.png");
            this.imgUnselRightTop1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_righttop1.png");
            this.imgUnselBottomRight1 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottomright1.png");
            this.imgUnselTopLeft2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_topleft2.png");
            this.imgUnselLeft2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_left2.png");
            this.imgUnselBottomLeft2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottomleft2.png");
            this.imgUnselTopRight2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_topright2.png");
            this.imgUnselRight2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_right2.png");
            this.imgUnselBottomRight2 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottomright2.png");
            this.imgUnselTopRight3 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_topright3.png");
            this.imgUnselRight3 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_right3.png");
            this.imgUnselBottomRight3 = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottomright3.png");
            this.imgUnselTop = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_top.png");
            this.imgUnselBottom = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottom.png");
            this.imgUnselFiller = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_filler.png");
            this.setOpaque(false);
            this.buttons = buttons;
            Border b = BorderFactory.createEmptyBorder(12, 19, 2, 24);
            for (TabButton btn : buttons) {
                btn.setBorder(b);
                this.add(btn);
            }
            this.sel = new Image[13];
            this.unsel = new Image[13];
            for (int i = 0; i < this.sel.length; ++i) {
                this.sel[i] = ImageUtilities.loadImage((String)("org/netbeans/modules/welcome/resources/tab_sel_" + i + ".png"));
                this.unsel[i] = ImageUtilities.loadImage((String)("org/netbeans/modules/welcome/resources/tab_unsel_" + i + ".png"));
            }
        }

        private void paintTab(Graphics2D g, int tabIndex) {
            int width = this.getWidth();
            int height = this.getHeight();
            boolean selected = tabIndex == TabbedPane.this.selTabIndex;
            int tabWidth = width / this.buttons.length;
            int x = tabWidth * tabIndex;
            if (tabIndex == this.buttons.length - 1) {
                tabWidth += width % this.buttons.length;
            }
            if (selected) {
                Image imgTopLeft = tabIndex == 0 ? this.imgSelTopLeft1 : this.imgSelTopLeft2;
                g.drawImage(imgTopLeft, x, 0, this);
                int topLeftWidth = imgTopLeft.getWidth(this);
                int topLeftHeight = imgTopLeft.getHeight(this);
                Image imgTopRight = tabIndex == this.buttons.length - 1 ? this.imgSelTopRight1 : this.imgSelTopRight2;
                int topRightWidth = imgTopRight.getWidth(this);
                int topRightHeight = imgTopRight.getHeight(this);
                g.drawImage(imgTopRight, x + tabWidth - topRightWidth, 0, this);
                g.drawImage(this.imgSelTop, x + topLeftWidth, 0, tabWidth - topLeftWidth - topRightWidth, this.imgSelTop.getHeight(this), this);
                Image imgLeft = tabIndex == 0 ? this.imgSelLeft1 : this.imgSelLeft2;
                int leftWidth = imgLeft.getWidth(this);
                g.drawImage(imgLeft, x, topLeftHeight, leftWidth, height - topLeftHeight, this);
                Image imgRight = tabIndex == this.buttons.length - 1 ? this.imgSelRight1 : this.imgSelRight2;
                int rightWidth = imgRight.getWidth(this);
                g.drawImage(imgRight, x + tabWidth - rightWidth, topRightHeight, rightWidth, height - topRightHeight, this);
                g.setColor(COLOR_SEL);
                g.fillRect(x + leftWidth, topLeftHeight, tabWidth - leftWidth - rightWidth, height - topLeftHeight);
            } else {
                int bottomHeight;
                int topWidth;
                int topHeight;
                Rectangle fillRect = new Rectangle(x, 0, tabWidth, height);
                if (tabIndex == 0) {
                    g.drawImage(this.imgUnselTopLeft1, x, 0, this);
                    topHeight = this.imgUnselTopLeft1.getHeight(this);
                    topWidth = this.imgUnselTopLeft1.getWidth(this);
                    fillRect.x += topWidth;
                    fillRect.width -= topWidth;
                    g.drawImage(this.imgUnselLeftTop1, x, topHeight, this);
                    fillRect.y += (topHeight += this.imgUnselLeftTop1.getHeight(this));
                    fillRect.height -= topHeight;
                    bottomHeight = this.imgUnselBottomLeft1.getHeight(this);
                    g.drawImage(this.imgUnselBottomLeft1, x, height - bottomHeight, this);
                    g.drawImage(this.imgUnselLeft1, x, topHeight, this.imgUnselLeft1.getWidth(this), height - topHeight - bottomHeight, this);
                } else {
                    topHeight = this.imgUnselTopLeft1.getHeight(this);
                    fillRect.y += (topHeight += this.imgUnselLeftTop1.getHeight(this));
                    fillRect.height -= topHeight;
                    g.drawImage(this.imgUnselTopLeft2, x, 0, this);
                    topHeight = this.imgUnselTopLeft2.getHeight(this);
                    topWidth = this.imgUnselTopLeft2.getWidth(this);
                    fillRect.x += topWidth;
                    fillRect.width -= topWidth;
                    bottomHeight = this.imgUnselBottomLeft2.getHeight(this);
                    g.drawImage(this.imgUnselBottomLeft2, x, height - bottomHeight, this);
                    g.drawImage(this.imgUnselLeft2, x, topHeight, this.imgUnselLeft2.getWidth(this), height - topHeight - bottomHeight, this);
                }
                if (tabIndex == this.buttons.length - 1) {
                    topHeight = this.imgUnselTopRight1.getHeight(this);
                    topWidth = this.imgUnselTopRight1.getWidth(this);
                    g.drawImage(this.imgUnselTopRight1, x + tabWidth - topWidth, 0, this);
                    fillRect.width -= topWidth;
                    g.drawImage(this.imgUnselRightTop1, x + tabWidth - topWidth, topHeight, this);
                    bottomHeight = this.imgUnselBottomRight1.getHeight(this);
                    g.drawImage(this.imgUnselBottomRight1, x + tabWidth - topWidth, height - bottomHeight, this);
                    g.drawImage(this.imgUnselRight1, x + tabWidth - topWidth, topHeight += this.imgUnselRightTop1.getHeight(this), this.imgUnselRight1.getWidth(this), height - topHeight - bottomHeight, this);
                } else if (tabIndex + 1 == TabbedPane.this.selTabIndex) {
                    topHeight = this.imgUnselTopRight2.getHeight(this);
                    topWidth = this.imgUnselTopRight2.getWidth(this);
                    g.drawImage(this.imgUnselTopRight2, x + tabWidth - topWidth, 0, this);
                    fillRect.width -= topWidth;
                    bottomHeight = this.imgUnselBottomRight2.getHeight(this);
                    g.drawImage(this.imgUnselBottomRight2, x + tabWidth - topWidth, height - bottomHeight, this);
                    g.drawImage(this.imgUnselRight2, x + tabWidth - topWidth, topHeight, this.imgUnselRight2.getWidth(this), height - topHeight - bottomHeight, this);
                } else {
                    topHeight = this.imgUnselTopRight3.getHeight(this);
                    topWidth = this.imgUnselTopRight3.getWidth(this);
                    g.drawImage(this.imgUnselTopRight3, x + tabWidth - topWidth, 0, this);
                    fillRect.width -= topWidth;
                    bottomHeight = this.imgUnselBottomRight3.getHeight(this);
                    g.drawImage(this.imgUnselBottomRight3, x + tabWidth - topWidth, height - bottomHeight, this);
                    g.drawImage(this.imgUnselRight3, x + tabWidth - topWidth, topHeight, this.imgUnselRight3.getWidth(this), height - topHeight - bottomHeight, this);
                }
                fillRect.height -= this.imgUnselBottom.getHeight(this);
                g.drawImage(this.imgUnselFiller, fillRect.x, fillRect.y - this.imgUnselFiller.getHeight(this), fillRect.width, this.imgUnselFiller.getHeight(this), this);
                g.drawImage(this.imgUnselTop, fillRect.x, 0, fillRect.width, this.imgUnselTop.getHeight(this), this);
                g.drawImage(this.imgUnselBottom, fillRect.x, height - this.imgUnselBottom.getHeight(this), fillRect.width, this.imgUnselBottom.getHeight(this), this);
                g.setColor(COLOR_UNSEL);
                g.fill(fillRect);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            for (int i = 0; i < this.buttons.length; ++i) {
                this.paintTab(g2d, i);
            }
        }

        @Override
        protected void paintBorder(Graphics g) {
        }
    }

    private static class TabButton
    extends JLabel {
        private boolean isSelected = false;
        private ActionListener actionListener;
        private final int tabIndex;

        public TabButton(String title, int tabIndex) {
            super(title);
            this.tabIndex = tabIndex;
            this.setOpaque(false);
            this.setFont(Constants.TAB_FONT);
            this.setForeground(Utils.getColor(this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
            this.setHorizontalAlignment(0);
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && null != TabButton.this.actionListener) {
                        TabButton.this.actionListener.actionPerformed(new ActionEvent(TabButton.this, 0, "clicked"));
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (null != TabButton.this.actionListener) {
                        TabButton.this.actionListener.actionPerformed(new ActionEvent(TabButton.this, 0, "clicked"));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!TabButton.this.isSelected) {
                        TabButton.this.setCursor(Cursor.getPredefinedCursor(12));
                        TabButton.this.setForeground(Utils.getColor("MouseOverTabColor"));
                    } else {
                        TabButton.this.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TabButton.this.setCursor(Cursor.getDefaultCursor());
                    TabButton.this.setForeground(Utils.getColor(TabButton.this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    TabButton.this.setForeground(Utils.getColor("MouseOverLinkColor"));
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TabButton.this.setForeground(Utils.getColor(TabButton.this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
                }
            });
        }

        public void addActionListener(ActionListener l) {
            assert (null == this.actionListener);
            this.actionListener = l;
        }

        public void setSelected(boolean sel) {
            this.isSelected = sel;
            this.setForeground(Utils.getColor(this.isFocusOwner() ? "MouseOverLinkColor" : (this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor")));
            this.setFocusable(!sel);
            if (null != this.getParent()) {
                this.getParent().repaint();
            }
        }

        public int getTabIndex() {
            return this.tabIndex;
        }
    }
}

