/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyContainer;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.grammar.DialogFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class DependencyGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private DependencyGenerator(POMModel pOMModel, JTextComponent jTextComponent) {
        this.model = pOMModel;
        this.component = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DependencyGenerator.class, (String)"NAME_Dependency");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        String[] stringArray;
        try {
            this.model.sync();
        }
        catch (IOException iOException) {
            Logger.getLogger(DependencyGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", iOException);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        FileObject fileObject = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (project != null);
        int n = this.component.getCaretPosition();
        DocumentComponent documentComponent = this.model.findComponent(n);
        boolean bl = false;
        if (documentComponent != null) {
            stringArray = this.model.getXPathExpression(documentComponent);
            bl = stringArray.contains("dependencyManagement");
        }
        if ((stringArray = DialogFactory.showDependencyDialog((Project)project, (!bl ? 1 : 0) != 0)) != null) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            String string6 = stringArray[5];
            int n2 = -1;
            try {
                this.model.startTransaction();
                n = this.component.getCaretPosition();
                DependencyContainer dependencyContainer = this.findContainer(n, this.model);
                Dependency dependency = dependencyContainer.findDependencyById(string, string2, string6);
                if (dependency == null) {
                    dependency = this.model.getFactory().createDependency();
                    dependency.setGroupId(string);
                    dependency.setArtifactId(string2);
                    dependency.setVersion(string3);
                    dependency.setScope(string4);
                    dependency.setType(string5);
                    dependency.setClassifier(string6);
                    dependencyContainer.addDependency(dependency);
                }
                n2 = dependency.getModel().getAccess().findPosition((Node)dependency.getPeer());
            }
            finally {
                this.model.endTransaction();
            }
            if (n2 != -1) {
                this.component.setCaretPosition(n2);
            }
        }
    }

    private DependencyContainer findContainer(int n, POMModel pOMModel) {
        for (DocumentComponent documentComponent = pOMModel.findComponent(n); documentComponent != null; documentComponent = documentComponent.getParent()) {
            if (!(documentComponent instanceof DependencyContainer)) continue;
            return (DependencyContainer)documentComponent;
        }
        return pOMModel.getProject();
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<DependencyGenerator> arrayList = new ArrayList<DependencyGenerator>();
            POMModel pOMModel = (POMModel)lookup.lookup(POMModel.class);
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            if (pOMModel != null) {
                arrayList.add(new DependencyGenerator(pOMModel, jTextComponent));
            }
            return arrayList;
        }
    }
}

