/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.spi.AbstractCard;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.AntTargetInterceptor;
import org.netbeans.modules.javacard.spi.capabilities.CapabilitiesProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardContentsProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardCustomizerProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.capabilities.ClearEpromCapability;
import org.netbeans.modules.javacard.spi.capabilities.DebugCapability;
import org.netbeans.modules.javacard.spi.capabilities.DeleteCapability;
import org.netbeans.modules.javacard.spi.capabilities.EpromFileCapability;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.ProfileCapability;
import org.netbeans.modules.javacard.spi.capabilities.ResumeCapability;
import org.netbeans.modules.javacard.spi.capabilities.StartCapability;
import org.netbeans.modules.javacard.spi.capabilities.StopCapability;
import org.netbeans.modules.javacard.spi.capabilities.UrlCapability;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public abstract class BaseCard<T extends CapabilitiesProvider>
extends AbstractCard {
    protected final RequestProcessor rp;
    private final Class<T> type;

    protected BaseCard(JavacardPlatform platform, String systemId, Class<T> type) {
        super(platform, systemId);
        this.type = type;
        this.rp = new RequestProcessor("Java Card Instance " + systemId);
    }

    protected final Class<T> type() {
        return this.type;
    }

    protected abstract CardInfo createCardInfo(T var1);

    protected AntTargetInterceptor createAntTargetInterceptor(T t) {
        return null;
    }

    protected UrlCapability createApduSupport(T t) {
        return null;
    }

    protected CardContentsProvider createCardContentProvider(T t) {
        return null;
    }

    protected ClearEpromCapability createClearEpromCapability(T t) {
        return null;
    }

    protected DebugCapability createDebugCapability(T t) {
        return null;
    }

    protected EpromFileCapability createEpromCapability(T t) {
        return null;
    }

    protected PortProvider createPortProvider(T t) {
        return null;
    }

    protected ProfileCapability createProfileCapability(T t) {
        return null;
    }

    protected ResumeCapability createResumeCapability(T t) {
        return null;
    }

    protected StartCapability createStartCapability(T t) {
        return null;
    }

    protected StopCapability createStopCapability(T t) {
        return null;
    }

    protected CardCustomizerProvider createCardCustomizerProvider(T t) {
        return null;
    }

    public DeleteCapability createDeleteCapability(T t) {
        return null;
    }

    protected void log(String toLog) {
        this.log(Level.FINE, toLog);
    }

    protected void log(Level l, String toLog) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (logger.isLoggable(l)) {
            logger.log(l, toLog);
        }
    }

    private void maybeAddCapability(ICardCapability cap) {
        if (cap != null) {
            this.addCapability(cap);
        }
    }

    private void allowNullInitCapabilities(ICardCapability ... capabilities) {
        LinkedList<ICardCapability> l = new LinkedList<ICardCapability>();
        for (ICardCapability c : capabilities) {
            if (c == null) continue;
            l.add(c);
        }
        this.initCapabilities(l.toArray(new ICardCapability[0]));
    }

    @Override
    void logAddition(ICardCapability c) {
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts) {
            HashSet<Class<? extends ICardCapability>> s = new HashSet<Class<? extends ICardCapability>>(((CapabilitiesProvider)this.getCapability(this.type())).getSupportedCapabilityTypes());
            int sz = s.size();
            s.removeAll(Arrays.asList(c.getClass().getInterfaces()));
            if (s.size() == sz) {
                Logger.getLogger(BaseCard.class.getName()).log(Level.WARNING, "Adding a capability not in the list of supported capabilities: " + c.getClass().getName() + "; supported types: " + ((CapabilitiesProvider)this.getCapability(this.type())).getSupportedCapabilityTypes());
            }
        }
    }

    protected abstract T loadData();

    @Override
    protected final synchronized void onBeforeFirstLookup() {
        this.log("onBeforeFirstLookup on " + this);
        T props = this.loadData();
        this.allowNullInitCapabilities(new ICardCapability[]{props, this.createCardInfo(props), this.createPortProvider(props), this.createAntTargetInterceptor(props), this.createCardContentProvider(props), this.createApduSupport(props)});
        Set<Class<? extends ICardCapability>> declaredCapabilities = props.getSupportedCapabilityTypes();
        CardState state = this.getState();
        if (declaredCapabilities.contains(StartCapability.class) && (state.isNotRunning() || state.isTransitionToStop())) {
            this.maybeAddCapability(this.createStartCapability(props));
        }
        if (declaredCapabilities.contains(StopCapability.class) && (state.isRunning() || state.isTransitionToStart())) {
            this.maybeAddCapability(this.createStopCapability(props));
        }
        if (declaredCapabilities.contains(DebugCapability.class)) {
            this.maybeAddCapability(this.createDebugCapability(props));
        }
        if (declaredCapabilities.contains(ProfileCapability.class)) {
            this.maybeAddCapability(this.createProfileCapability(props));
        }
        if (state.isNotRunning() && declaredCapabilities.contains(CardCustomizerProvider.class)) {
            this.maybeAddCapability(this.createCardCustomizerProvider(props));
        }
        if (declaredCapabilities.contains(DeleteCapability.class)) {
            this.maybeAddCapability(this.createDeleteCapability(props));
        }
        this.maybeAddEpromCapabilities();
        this.log("calling subclass initLookup()");
        this.initLookup();
        this.log("exit onBeforeFirstLookup");
    }

    @Override
    final Lookup createPreloadLookup() {
        return Lookups.fixed((Object[])new Object[]{this.loadData()});
    }

    protected void initLookup() {
    }

    private void maybeAddEpromCapabilities() {
        boolean resumeSupported;
        EpromFileCapability eprom;
        CapabilitiesProvider props = (CapabilitiesProvider)this.getCapability(this.type());
        Set<Class<? extends ICardCapability>> capabilityTypes = props.getSupportedCapabilityTypes();
        boolean epromSupported = capabilityTypes.contains(EpromFileCapability.class);
        boolean clearEpromSupported = capabilityTypes.contains(ClearEpromCapability.class);
        FileObject epromFile = null;
        if (epromSupported && (eprom = this.createEpromCapability(props)) != null) {
            this.addCapability(eprom);
            epromFile = eprom.getEpromFile();
        }
        if (epromFile != null && clearEpromSupported) {
            this.maybeAddCapability(this.createClearEpromCapability(props));
        }
        if ((resumeSupported = capabilityTypes.contains(ResumeCapability.class)) && epromFile != null && epromSupported || resumeSupported && !epromSupported) {
            ResumeCapability resume = this.createResumeCapability(props);
            this.maybeAddCapability(resume);
        }
    }

    protected void clearProcessReferences() {
    }

    @Override
    protected void onStateChanged(CardState old, CardState nue) {
        if (old == nue) {
            return;
        }
        this.log(this + " stateChange " + (Object)((Object)old) + "->" + (Object)((Object)nue));
        CardInfo info = this.getCapability(CardInfo.class);
        String name = info == null || info.getDisplayName() == null ? this.getSystemId() : info.getDisplayName();
        StatusDisplayer.getDefault().setStatusText(nue.statusMessage(name));
        CapabilitiesProvider t = (CapabilitiesProvider)this.getCapability(this.type());
        switch (nue) {
            case BEFORE_RESUMING: 
            case BEFORE_STARTING: 
            case STARTING: 
            case RESUMING: {
                this.removeCapability(ClearEpromCapability.class);
                this.removeCapability(StartCapability.class);
                this.removeCapability(ResumeCapability.class);
                this.removeCapability(CardCustomizerProvider.class);
                break;
            }
            case RUNNING: 
            case RUNNING_IN_DEBUG_MODE: {
                CapabilitiesProvider props = this.getCapability(CapabilitiesProvider.class);
                Set<Class<? extends ICardCapability>> declaredCapabilities = props.getSupportedCapabilityTypes();
                if (declaredCapabilities.contains(StopCapability.class)) {
                    this.maybeAddCapability(this.createStopCapability(t));
                }
                this.removeCapability(CardCustomizerProvider.class);
                break;
            }
            case NOT_RUNNING: {
                CapabilitiesProvider props = this.getCapability(CapabilitiesProvider.class);
                Set<Class<? extends ICardCapability>> declaredCapabilities = props.getSupportedCapabilityTypes();
                this.clearProcessReferences();
                this.maybeAddEpromCapabilities();
                if (declaredCapabilities.contains(StartCapability.class)) {
                    this.maybeAddCapability(this.createStartCapability(t));
                }
                if (declaredCapabilities.contains(CardCustomizerProvider.class)) {
                    this.maybeAddCapability(this.createCardCustomizerProvider(t));
                }
            }
            case STOPPING: {
                this.removeCapability(StopCapability.class);
                break;
            }
            case BEFORE_STOPPING: {
                this.removeCapability(StopCapability.class);
                break;
            }
            default: {
                throw new AssertionError((Object)("Cannot set state to " + (Object)((Object)nue)));
            }
        }
    }
}

