/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jdesktop.layout.GroupLayout;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiNotification;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.CompoundUndoManager;
import org.netbeans.modules.kenai.collab.chat.InsertLinkAction;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.LinkOtherFileAction;
import org.netbeans.modules.kenai.collab.chat.LinkOtherIssue;
import org.netbeans.modules.kenai.collab.chat.MessageHistoryManager;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.netbeans.modules.kenai.collab.chat.NotificationExtension;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.DropDownButtonFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ChatPanel
extends JPanel {
    private MultiUserChat muc;
    private Chat suc;
    private Kenai kenai;
    private KenaiConnection kc;
    private boolean disableAutoScroll = false;
    private HTMLEditorKit editorKit = null;
    private static final String[][] smileysMap = new String[][]{{"B)", "cool"}, {"B-)", "cool"}, {"8-)", "cool"}, {":]", "grin"}, {":-]", "grin"}, {":D", "laughing"}, {":-D", "laughing"}, {":(", "sad"}, {":-(", "sad"}, {":)", "smiley"}, {":-)", "smiley"}, {";)", "wink"}, {";-)", "wink"}};
    private CompoundUndoManager undo;
    private MessageHistoryManager history = new MessageHistoryManager();
    private static final String ISSUE_REPORT_STRING = "(issue |bug |ISSUE:|ISSUE: )#?([A-Z_]+-)*([0-9]+)";
    private static final Pattern ISSUE_REPORT = Pattern.compile("(issue |bug |ISSUE:|ISSUE: )#?([A-Z_]+-)*([0-9]+)", 2);
    private static final String STACK_TRACE_STRING = "(|catch.)at.((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)";
    private static final Pattern STACK_TRACE = Pattern.compile("(|catch.)at.((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");
    private static final String EXCEPTION_MESSAGE_STRING = "(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+)([a-zA-Z_$][a-zA-Z0-9_$]*(?:: .+)?)";
    private static final Pattern EXCEPTION_MESSAGE = Pattern.compile("(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+)([a-zA-Z_$][a-zA-Z0-9_$]*(?:: .+)?)");
    private static final String CLASSPATH_RESOURCE_STRING = "FILE:(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))";
    private static final Pattern CLASSPATH_RESOURCE = Pattern.compile("FILE:(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))");
    private static final String ABSOLUTE_RESOURCE_STRING = "FILE:/(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))";
    private static final Pattern ABSOLUTE_RESOURCE = Pattern.compile("FILE:/(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))");
    private static final String PROJECT_RESOURCE_STRING = "FILE:\\{\\$([a-zA-Z_$][\\.a-zA-Z0-9_$]*)\\}/(([a-zA-Z_$][a-zA-Z0-9_$]*/)*)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))";
    private static final Pattern PROJECT_RESOURCE = Pattern.compile("FILE:\\{\\$([a-zA-Z_$][\\.a-zA-Z0-9_$]*)\\}/(([a-zA-Z_$][a-zA-Z0-9_$]*/)*)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+))");
    private static final Pattern RESOURCES = Pattern.compile("((|catch.)at.((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\))|(FILE:(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+)))|(FILE:\\{\\$([a-zA-Z_$][\\.a-zA-Z0-9_$]*)\\}/(([a-zA-Z_$][a-zA-Z0-9_$]*/)*)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+)))|(FILE:/(([a-zA-Z_$][a-zA-Z0-9_$]*/)+)(([a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z0-9_$]*):([0-9]+)))");
    List undoCharsList = Arrays.asList(Character.valueOf(' '), Character.valueOf('.'), Character.valueOf(','), Character.valueOf('!'), Character.valueOf('\t'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf(';'));
    private JPanel buttons;
    private JPopupMenu dropDownMenu;
    private JTextPane inbox;
    private JPanel inboxPanel;
    private JScrollPane inboxScrollPane;
    private JLabel online;
    private JTextPane outbox;
    private JPanel outboxPanel;
    private JScrollPane outboxScrollPane;
    private JButton sendButton;
    private JButton sendLinkButton;
    private JSplitPane splitter;
    private JLabel statusLine;
    private JMenuItem temp;
    private JPanel topPanel;
    private Date lastDatePrinted;
    private Date lastMessageDate;
    private String lastNickPrinted = null;
    private String rgb = null;

    private void addNotificationsMenuItem(JPopupMenu menu) throws MissingResourceException {
        NotificationsEnabledAction bubbleEnabled = new NotificationsEnabledAction();
        String name = this.isPrivate() ? this.getShortName() : this.getKenaiProject().getDisplayName();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(ChatPanel.class, (String)"CTL_NotificationsFor", (Object[])new Object[]{name}), ChatNotifications.getDefault().isEnabled(this.getName()));
        jCheckBoxMenuItem.addActionListener(bubbleEnabled);
        menu.add(jCheckBoxMenuItem);
    }

    private void insertLink() {
        Mode editor = WindowManager.getDefault().findMode("editor");
        TopComponent tc = editor.getSelectedTopComponent();
        if (this.getTopComponent(EditorRegistry.lastFocusedComponent()) == tc) {
            this.insertLinkToEditor();
        } else if (tc != null && this.isIssueRelated(tc)) {
            this.insertLinkToIssue();
        } else {
            this.insertLinkToEditor();
        }
    }

    private void insertLinkToEditor() {
        if (EditorRegistry.lastFocusedComponent() != null) {
            new InsertLinkAction(EditorRegistry.lastFocusedComponent(), this.outbox, true, false).actionPerformed(null);
        }
    }

    private KenaiProject getKenaiProject() {
        assert (!this.isPrivate());
        return KenaiConnection.getKenaiProject(this.muc);
    }

    private TopComponent selectedEditorComponent() {
        Mode editor = WindowManager.getDefault().findMode("editor");
        TopComponent tc = editor.getSelectedTopComponent();
        TopComponent topComponent = this.getTopComponent(EditorRegistry.lastFocusedComponent());
        if (topComponent == tc) {
            return tc;
        }
        return null;
    }

    private void insertLinkToIssue() {
        KenaiIssueAccessor.IssueHandle[] issues = this.muc == null ? KenaiIssueAccessor.getDefault().getRecentIssues() : KenaiIssueAccessor.getDefault().getRecentIssues(this.getKenaiProject());
        if (issues.length > 0) {
            new InsertLinkAction(issues[0], this.outbox, false).actionPerformed(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void selectIssueReport(Matcher m) {
        issueNumber = m.group(3);
        _proj = null;
        if (this.isPrivate()) {
            try {
                it = this.kenai.getMyProjects().iterator();
                _proj = (KenaiProject)it.next();
                if (m.group(2) == null || m.group(2).equals("")) {
                    while (it.hasNext()) {
                        bt = _proj.getFeatures(KenaiService.Type.ISSUES);
                        if (bt.length == 0) continue;
                        btinst = bt[0];
                        if (btinst.getService().equals("bugzilla")) ** GOTO lbl28
                        _proj = (KenaiProject)it.next();
                    }
                }
                while (it.hasNext()) {
                    System.out.println(_proj.getName());
                    s = m.group(2).replaceAll("-", "_").toLowerCase();
                    s = s.substring(0, s.length() - 1);
                    if (_proj.getName().replaceAll("-", "_").toLowerCase().equals(s)) break;
                    _proj = (KenaiProject)it.next();
                }
            }
            catch (KenaiException ex1) {
                Exceptions.printStackTrace((Throwable)ex1);
            }
        } else {
            _proj = this.getKenaiProject();
        }
lbl28:
        // 6 sources

        proj = _proj;
        if (proj == null) {
            return;
        }
        trackers = null;
        try {
            trackers = proj.getFeatures(KenaiService.Type.ISSUES);
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (trackers.length == 0) {
            return;
        }
        if (trackers[0].getService().equals("jira")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KenaiIssueAccessor.getDefault().open(proj, proj.getName().toUpperCase().replaceAll("-", "_") + "-" + issueNumber);
                }
            });
        } else if (trackers[0].getService().equals("bugzilla")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KenaiIssueAccessor.getDefault().open(proj, issueNumber);
                }
            });
        }
    }

    private void selectStackTrace(Matcher m) {
        String pkg = m.group(2);
        String filename = m.group(3);
        String resource = pkg.replace('.', '/') + filename;
        int lineNumber = Integer.parseInt(m.group(4));
        ClassPath cp = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
        FileObject source = cp.findResource(resource);
        if (source != null) {
            ChatPanel.doOpen(source, lineNumber);
        }
    }

    private void selectClasspathResource(Matcher m) {
        String resource = m.group(1) + m.group(4);
        int lineNumber = Integer.parseInt(m.group(5));
        ClassPath cp = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
        FileObject source = cp.findResource(resource);
        if (source != null) {
            ChatPanel.doOpen(source, lineNumber);
        }
    }

    private void selectProjectResource(Matcher m) {
        String resource = m.group(2) + m.group(5);
        int lineNumber = Integer.parseInt(m.group(6));
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            if (!ProjectUtils.getInformation((Project)p).getName().equals(m.group(1))) continue;
            FileObject source = p.getProjectDirectory().getFileObject(resource);
            ChatPanel.doOpen(source, lineNumber);
            return;
        }
    }

    private void selectAbsoluteResource(Matcher m) {
        String resource = "/" + m.group(1) + m.group(4);
        int lineNumber = Integer.parseInt(m.group(5));
        File file = new File(resource);
        if (file.exists()) {
            FileObject source = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            ChatPanel.doOpen(source, lineNumber);
        }
    }

    private static boolean doOpen(FileObject fo, int line) {
        try {
            OpenCookie oc;
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && line != -1 && (doc = ec.openDocument()) != null && line != -1) {
                Line l = null;
                try {
                    l = lc.getLineSet().getCurrent(line - 1);
                }
                catch (IndexOutOfBoundsException e) {
                    l = lc.getLineSet().getCurrent(0);
                }
                if (l != null) {
                    l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    return true;
                }
            }
            if ((oc = (OpenCookie)od.getCookie(OpenCookie.class)) != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return false;
    }

    public ChatPanel(MultiUserChat muc) {
        this.muc = muc;
        KenaiProject kenaiProject = this.getKenaiProject();
        this.kenai = kenaiProject.getKenai();
        this.setName(muc.getRoom());
        this.kc = KenaiConnection.getDefault(this.kenai);
        this.init();
        if (!this.kenai.getXMPPConnection().isConnected()) {
            try {
                this.kc.reconnect(muc);
            }
            catch (XMPPException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.muc.addParticipantListener(new PacketListener(){

            public void processPacket(Packet presence) {
                ChatPanel.this.insertPresence((Presence)presence);
            }
        });
        this.kc.join(muc, new ChatListener());
    }

    public ChatPanel(String jid) {
        this.setName(jid);
        this.init();
        this.kenai = KenaiConnection.getKenai(jid);
        this.kc = KenaiConnection.getDefault(this.kenai);
        this.suc = this.kc.joinPrivate(jid, new ChatListener());
    }

    public boolean isPrivate() {
        return this.muc == null;
    }

    public String getShortName() {
        return StringUtils.parseName((String)this.getName());
    }

    private void init() {
        this.initComponents();
        this.online.setHorizontalTextPosition(2);
        if (this.isPrivate()) {
            this.topPanel.remove(this.online);
            this.online = new KenaiUserUI(this.getName()).createUserWidget();
            this.online.setText(null);
            this.online.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 1));
            this.topPanel.add((Component)this.online, "East");
            this.topPanel.validate();
        }
        this.editorKit = (HTMLEditorKit)this.inbox.getEditorKit();
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        StyleSheet styleSheet = ((HTMLDocument)this.inbox.getDocument()).getStyleSheet();
        styleSheet.addRule(bodyRule);
        styleSheet.addRule(".buddy {color: black; font-weight: bold; padding: 4px;}");
        styleSheet.addRule(".time {color: lightgrey; padding: 4px;");
        styleSheet.addRule(".message {color: lightgrey; padding: 2px 4px;");
        styleSheet.addRule(".date {color: #cc9922; padding: 7px 0;");
        if (!this.isPrivate()) {
            MessagingHandleImpl handle = ChatNotifications.getDefault().getMessagingHandle(this.getKenaiProject());
            handle.addPropertyChangeListener(new PresenceListener());
        }
        this.inbox.setBackground(Color.WHITE);
        this.inbox.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url != null && !url.getProtocol().equals("file") && !url.getProtocol().equals("issue")) {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                    } else {
                        String link = e.getDescription();
                        Matcher m = STACK_TRACE.matcher(link);
                        if (m.matches()) {
                            ChatPanel.this.selectStackTrace(m);
                        } else {
                            m = CLASSPATH_RESOURCE.matcher(link);
                            if (m.matches()) {
                                ChatPanel.this.selectClasspathResource(m);
                            } else {
                                m = PROJECT_RESOURCE.matcher(link);
                                if (m.matches()) {
                                    ChatPanel.this.selectProjectResource(m);
                                } else {
                                    m = ABSOLUTE_RESOURCE.matcher(link);
                                    if (m.matches()) {
                                        ChatPanel.this.selectAbsoluteResource(m);
                                    } else {
                                        m = ISSUE_REPORT.matcher(link);
                                        if (m.matches()) {
                                            ChatPanel.this.selectIssueReport(m);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        });
        this.outbox.setBackground(Color.WHITE);
        this.splitter.setResizeWeight(0.9);
        this.refreshOnlineStatus();
        this.undo = new CompoundUndoManager(this.outbox);
        this.inboxScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JScrollBar vbar = ChatPanel.this.inboxScrollPane.getVerticalScrollBar();
                if (vbar == null) {
                    return;
                }
                ChatPanel.this.disableAutoScroll = vbar.getValue() + vbar.getVisibleAmount() != vbar.getMaximum();
            }
        });
        this.inboxScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                JScrollBar vbar = (JScrollBar)event.getSource();
                if (!event.getValueIsAdjusting()) {
                    return;
                }
                ChatPanel.this.disableAutoScroll = vbar.getValue() + vbar.getVisibleAmount() != vbar.getMaximum();
            }
        });
        this.inbox.setComponentPopupMenu(this.dropDownMenu);
        this.outbox.setComponentPopupMenu(this.dropDownMenu);
        UIUtils.logKenaiUsage("CHAT", this.isPrivate() ? "PRIVATE_CHAT" : "CHATROOM");
    }

    void insertToInputArea(String message) {
        if (message == null) {
            return;
        }
        try {
            this.outbox.getDocument().insertString(this.outbox.getCaretPosition(), message, null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void leave() {
        if (this.isPrivate()) {
            this.kc.leavePrivate(this.getName());
        } else {
            this.kc.leaveGroup(this.getShortName());
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.outbox.requestFocus();
    }

    private String removeTags(String body) {
        String tmp = body;
        tmp = tmp.replaceAll("\r\n", "\n");
        tmp = tmp.replaceAll("\r", "\n");
        return tmp.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>");
    }

    private String replaceLinks(String body) {
        String result = body.replaceAll("(http|https|ftp)://([a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,4}(/[^ ]*)*", "<a href=\"$0\">$0</a>");
        result = RESOURCES.matcher(result).replaceAll("<a href=\"$0\">$0</a>");
        result = ISSUE_REPORT.matcher(result).replaceAll("<a href=\"$0\">$0</a>");
        return result.replaceAll("  ", " &nbsp;");
    }

    private String replaceSmileys(String body) {
        if (body.matches(".*[B8:;]-?[]D()].*")) {
            for (int i = 0; i < smileysMap.length; ++i) {
                body = body.replace(smileysMap[i][0], "<img align=\"center\" src=\"" + this.getClass().getResource("/org/netbeans/modules/kenai/collab/resources/emo_" + smileysMap[i][1] + "16.png") + "\"></img>");
            }
        }
        return body;
    }

    private void refreshOnlineStatus() throws MissingResourceException {
        if (this.muc != null) {
            this.online.setText(this.muc.getOccupantsCount() + "");
            Iterator string = this.muc.getOccupants();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html><body>");
            while (string.hasNext()) {
                buffer.append(StringUtils.parseResource((String)((String)string.next())) + "<br>");
            }
            buffer.append("</body></html>");
            this.online.setToolTipText(buffer.toString());
        }
    }

    private void initComponents() {
        this.dropDownMenu = new JPopupMenu();
        this.temp = new JMenuItem();
        this.splitter = new JSplitPane();
        this.outboxPanel = new JPanel();
        this.buttons = new JPanel();
        this.sendLinkButton = DropDownButtonFactory.createDropDownButton((Icon)ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/kenai/ui/resources/insertlink.png", (boolean)true), (JPopupMenu)this.dropDownMenu);
        this.sendButton = new JButton();
        this.outboxScrollPane = new JScrollPane();
        this.outbox = new JTextPane();
        this.inboxPanel = new JPanel();
        this.inboxScrollPane = new JScrollPane();
        this.inbox = new JTextPane(){

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
                if (!ChatPanel.this.disableAutoScroll) {
                    super.scrollRectToVisible(aRect);
                }
            }
        };
        this.topPanel = new JPanel();
        this.online = new JLabel();
        this.statusLine = new JLabel();
        this.dropDownMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ChatPanel.this.dropDownMenuPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ChatPanel.this.dropDownMenuPopupMenuWillBecomeVisible(evt);
            }
        });
        this.dropDownMenu.add(this.temp);
        this.splitter.setOrientation(0);
        this.outboxPanel.setLayout(new BorderLayout());
        this.buttons.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.sendLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/insertlink.png")));
        this.sendLinkButton.setToolTipText(NbBundle.getBundle(ChatPanel.class).getString("ChatPanel.sendLinkButton.toolTipText"));
        this.sendLinkButton.setFocusable(false);
        this.sendLinkButton.setHorizontalTextPosition(0);
        this.sendLinkButton.setVerticalTextPosition(3);
        this.sendLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChatPanel.this.sendLinkButtonActionPerformed(evt);
            }
        });
        this.sendButton.setText(NbBundle.getMessage(ChatPanel.class, (String)"ChatPanel.sendButton.text", (Object[])new Object[0]));
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChatPanel.this.sendButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonsLayout = new GroupLayout((Container)this.buttons);
        this.buttons.setLayout((LayoutManager)buttonsLayout);
        buttonsLayout.setHorizontalGroup((GroupLayout.Group)buttonsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)buttonsLayout.createSequentialGroup().add((Component)this.sendLinkButton).addPreferredGap(0, 197, Short.MAX_VALUE).add((Component)this.sendButton)));
        buttonsLayout.setVerticalGroup((GroupLayout.Group)buttonsLayout.createParallelGroup(1).add((Component)this.sendButton).add((Component)this.sendLinkButton));
        this.outboxPanel.add((Component)this.buttons, "South");
        this.outbox.setMaximumSize(new Dimension(0, 16));
        this.outbox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChatPanel.this.outboxKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ChatPanel.this.keyTyped(evt);
            }
        });
        this.outboxScrollPane.setViewportView(this.outbox);
        this.outboxPanel.add((Component)this.outboxScrollPane, "Center");
        this.splitter.setRightComponent(this.outboxPanel);
        this.inboxPanel.setBackground(Color.white);
        this.inboxPanel.setLayout(new BorderLayout());
        this.inboxScrollPane.setBorder(null);
        this.inboxScrollPane.setViewportBorder(null);
        this.inbox.setBorder(null);
        this.inbox.setContentType("text/html");
        this.inbox.setEditable(false);
        this.inbox.setText(NbBundle.getMessage(ChatPanel.class, (String)"ChatPanel.inbox.text", (Object[])new Object[0]));
        this.inbox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ChatPanel.this.inboxFocusGained(evt);
            }
        });
        this.inboxScrollPane.setViewportView(this.inbox);
        this.inboxPanel.add((Component)this.inboxScrollPane, "Center");
        this.topPanel.setBackground(Color.white);
        this.topPanel.setLayout(new BorderLayout());
        this.online.setBackground(Color.white);
        this.online.setForeground(Color.blue);
        this.online.setHorizontalAlignment(4);
        this.online.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/collab/resources/user_online.png")));
        this.online.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 1));
        this.topPanel.add((Component)this.online, "East");
        this.topPanel.add((Component)this.statusLine, "Center");
        this.inboxPanel.add((Component)this.topPanel, "North");
        this.splitter.setTopComponent(this.inboxPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.splitter, -1, 268, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.splitter, -1, 403, Short.MAX_VALUE));
    }

    private void keyTyped(KeyEvent evt) {
        if (this.undoCharsList.contains(Character.valueOf(evt.getKeyChar()))) {
            this.undo.startNewCompoundEdit();
            return;
        }
        if (evt.getKeyChar() == '\n' || evt.getKeyChar() == '\r') {
            block16: {
                if (evt.isAltDown() || evt.isShiftDown() || evt.isControlDown()) {
                    try {
                        this.outbox.getStyledDocument().insertString(this.outbox.getCaretPosition(), "\r\n", null);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return;
                }
                try {
                    if (!(this.muc == null || this.kc.isConnected() && this.muc.isJoined())) {
                        try {
                            this.kc.reconnect(this.muc);
                        }
                        catch (XMPPException xMPPException) {
                            JOptionPane.showMessageDialog(this, xMPPException.getMessage());
                            return;
                        }
                    }
                    if (this.outbox.getText().trim().equals("")) break block16;
                    int pos = this.outbox.getCaretPosition();
                    if (pos > 1 && (this.outbox.getText().charAt(pos - 1) == '\n' || this.outbox.getText().charAt(pos - 1) == '\r')) {
                        try {
                            boolean tryRemoveR = this.outbox.getText().charAt(pos - 1) == '\n';
                            this.outbox.getDocument().remove(pos - 1, 1);
                            pos = this.outbox.getCaretPosition();
                            if (tryRemoveR && pos > 1 && this.outbox.getText().charAt(pos - 1) == '\r') {
                                this.outbox.getDocument().remove(pos - 1, 1);
                            }
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                    }
                    if (this.muc != null) {
                        this.muc.sendMessage(this.outbox.getText().trim());
                    } else {
                        Message m = new Message(this.suc.getParticipant());
                        m.setBody(this.outbox.getText().trim());
                        this.suc.sendMessage(m);
                        this.insertMessage(m);
                    }
                    UIUtils.logKenaiUsage("CHAT", "MESSAGE_SENT");
                }
                catch (XMPPException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.outbox.setText("");
            this.undo.discardAllEdits();
            this.history.resetHistory();
        }
    }

    private void outboxKeyPressed(KeyEvent evt) {
        if (evt.isControlDown() && evt.getKeyCode() == 90) {
            try {
                this.undo.undo();
                this.history.resetHistory();
            }
            catch (CannotUndoException e) {
                // empty catch block
            }
            return;
        }
        if (evt.isControlDown() && evt.getKeyCode() == 89) {
            try {
                this.undo.redo();
                this.history.resetHistory();
            }
            catch (CannotRedoException e) {
                // empty catch block
            }
            return;
        }
        if (evt.isControlDown() || evt.isAltDown()) {
            if (evt.getKeyCode() == 38) {
                String mess;
                if (this.history.isOnStart()) {
                    this.history.setEditedMessage(this.outbox.getText());
                }
                if ((mess = this.history.getPreviousMessage()) != null) {
                    this.outbox.setText(mess);
                }
                return;
            }
            if (evt.getKeyCode() == 40) {
                String message = this.history.getNextMessage();
                if (message != null) {
                    this.outbox.setText(message);
                }
                return;
            }
        }
        if (evt.isControlDown() && evt.getKeyCode() == 76) {
            Mode editor = WindowManager.getDefault().findMode("editor");
            TopComponent tc = editor.getSelectedTopComponent();
            if (this.getTopComponent(EditorRegistry.lastFocusedComponent()) == tc) {
                this.insertLinkToEditor();
            } else if (tc != null && this.isIssueRelated(tc)) {
                this.insertLinkToIssue();
            } else {
                Point magicCaretPosition = this.outbox.getCaret().getMagicCaretPosition();
                if (magicCaretPosition == null) {
                    magicCaretPosition = new Point(0, 0);
                }
                this.outbox.getComponentPopupMenu().show(this.outbox, magicCaretPosition.x, magicCaretPosition.y);
            }
        }
    }

    private boolean isIssueRelated(TopComponent tc) {
        if (this.muc == null) {
            KenaiIssueAccessor.IssueHandle[] issues = KenaiIssueAccessor.getDefault().getRecentIssues();
            if (issues.length < 1) {
                return false;
            }
            return issues[0].isShowing();
        }
        KenaiIssueAccessor.IssueHandle[] issues = KenaiIssueAccessor.getDefault().getRecentIssues(this.getKenaiProject());
        KenaiIssueAccessor.IssueHandle[] allIssues = KenaiIssueAccessor.getDefault().getRecentIssues();
        if (issues.length < 1) {
            return false;
        }
        if (issues[0].getID().equals(allIssues[0].getID())) {
            return issues[0].isShowing();
        }
        return false;
    }

    private TopComponent getTopComponent(Component comp) {
        while (comp != null && !(comp instanceof TopComponent)) {
            comp = comp.getParent();
        }
        return (TopComponent)comp;
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        KeyEvent e = new KeyEvent((Component)evt.getSource(), evt.getID(), evt.getWhen(), evt.getModifiers(), 10, '\n');
        this.keyTyped(e);
        this.outbox.requestFocus();
    }

    private void inboxFocusGained(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatPanel.this.inbox.getCaret().setVisible(false);
            }
        });
    }

    private void dropDownMenuPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.dropDownMenu.removeAll();
        JPopupMenu menu = (JPopupMenu)evt.getSource();
        if (menu.getInvoker() == this.inbox) {
            this.addNotificationsMenuItem(this.dropDownMenu);
            return;
        }
        JTextComponent lastFocused = EditorRegistry.lastFocusedComponent();
        if (lastFocused != null) {
            this.dropDownMenu.add(new InsertLinkAction(lastFocused, this.outbox, true, this.selectedEditorComponent() != null));
            this.dropDownMenu.addSeparator();
        }
        HashSet fos = new HashSet();
        for (JTextComponent comp : EditorRegistry.componentList()) {
            TopComponent tc = this.getTopComponent(comp);
            if (tc != null && tc.getClass().getName().endsWith("DiffTopComponent")) continue;
            this.dropDownMenu.add(new InsertLinkAction(comp, this.outbox, false, false));
        }
        if (lastFocused != null) {
            this.dropDownMenu.addSeparator();
        }
        KenaiIssueAccessor.IssueHandle[] issues = this.muc == null ? KenaiIssueAccessor.getDefault().getRecentIssues() : KenaiIssueAccessor.getDefault().getRecentIssues(this.getKenaiProject());
        for (int i = 0; issues != null && i < 3 && i < issues.length; ++i) {
            Mode editor = WindowManager.getDefault().findMode("editor");
            TopComponent tc = editor.getSelectedTopComponent();
            this.dropDownMenu.add(new InsertLinkAction(issues[i], this.outbox, this.isIssueRelated(tc)));
        }
        if (issues.length > 0) {
            this.dropDownMenu.addSeparator();
        }
        this.dropDownMenu.add(new LinkOtherFileAction(this.outbox));
        this.dropDownMenu.add(new LinkOtherIssue(this.outbox));
        if (menu.getInvoker() == this.outbox) {
            this.dropDownMenu.addSeparator();
            this.addNotificationsMenuItem(this.dropDownMenu);
        }
    }

    private void dropDownMenuPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.dropDownMenu.removeAll();
        this.dropDownMenu.add(this.temp);
    }

    private void sendLinkButtonActionPerformed(ActionEvent evt) {
        this.insertLink();
        this.outbox.requestFocus();
    }

    private String getMessageBody(Message m) {
        NotificationExtension ne = (NotificationExtension)m.getExtension("notification", "http://kenai.com/schema/XMPPNotification");
        String b = m.getBody();
        if (b == null) {
            b = "";
        }
        if (ne == null) {
            return b;
        }
        KenaiNotification n = ne.getNotification();
        if (n.getType() != KenaiService.Type.SOURCE && n.getType() != KenaiService.Type.ISSUES) {
            return b;
        }
        int i = b.indexOf(93);
        String body = i >= 0 ? b.substring(i + 2) : b;
        if (n.getType() == KenaiService.Type.ISSUES) {
            return body;
        }
        String id = ((KenaiNotification.Modification)n.getModifications().get(0)).getId();
        String projectName = StringUtils.parseName((String)m.getFrom());
        if (projectName.contains("@")) {
            projectName = StringUtils.parseName((String)projectName);
        }
        String url = this.kenai.getUrl().toString() + "/projects/" + projectName + "/sources/" + (n.getFeatureName() != null ? n.getFeatureName() : n.getServiceName()) + "/revision/" + id;
        return body + "\n" + url;
    }

    protected void insertMessage(Message message) {
        try {
            boolean printheader;
            HTMLDocument doc = (HTMLDocument)this.inbox.getStyledDocument();
            Date timestamp = ChatPanel.getTimestamp((Packet)message);
            String fromRes = this.suc == null ? StringUtils.parseResource((String)message.getFrom()) : StringUtils.parseName((String)message.getFrom());
            String messageBody = this.getMessageBody(message);
            this.history.addMessage(messageBody);
            Random random = new Random(fromRes.hashCode());
            float randNum = random.nextFloat();
            Color headerColor = Color.getHSBColor(randNum, 0.1f, 0.95f);
            Color messageColor = Color.getHSBColor(randNum, 0.1f, 1.0f);
            boolean bl = this.lastNickPrinted != null ? !this.lastNickPrinted.equals(fromRes) : (printheader = true);
            printheader |= this.lastMessageDate != null && timestamp != null ? timestamp.getTime() > this.lastMessageDate.getTime() + 120000L : true;
            this.lastNickPrinted = fromRes;
            this.lastMessageDate = timestamp;
            if (!this.isSameDate(this.lastDatePrinted, timestamp)) {
                this.lastDatePrinted = timestamp;
                printheader = true;
                this.rgb = null;
                String d = "<table border=\"0\" borderwith=\"0\" width=\"100%\"><tbody><tr><td class=\"date\" align=\"left\">" + (this.isToday(timestamp) ? NbBundle.getMessage(ChatPanel.class, (String)"LBL_Today") : DateFormat.getDateInstance().format(timestamp)) + "</td><td class=\"date\" align=\"right\">" + DateFormat.getTimeInstance(3).format(timestamp) + "</td></tr></tbody></table>";
                this.editorKit.insertHTML(doc, doc.getLength(), d, 0, 0, null);
            }
            String text = "";
            if (printheader) {
                if (this.rgb != null) {
                    text = text + "<div style=\"height: 3px; background-color: rgb(" + this.rgb + ")\"></div>";
                }
                text = text + "<table border=\"0\" borderwith=\"0\" width=\"100%\"><tbody><tr style=\"background-color: rgb(" + headerColor.getRed() + "," + headerColor.getGreen() + "," + headerColor.getBlue() + ")\">" + "<td class=\"buddy\" align=\"left\">" + fromRes + "</td><td class=\"time\" align=\"right\">" + DateFormat.getTimeInstance(3).format(ChatPanel.getTimestamp((Packet)message)) + "</td></tr></tbody></table>";
            }
            this.rgb = messageColor.getRed() + "," + messageColor.getGreen() + "," + messageColor.getBlue();
            text = text + "<div class=\"message\" style=\"background-color: rgb(" + this.rgb + ")\">" + this.replaceSmileys(this.replaceLinks(this.removeTags(messageBody))) + "</div>";
            this.editorKit.insertHTML(doc, doc.getLength(), text, 0, 0, null);
            this.inbox.revalidate();
            this.inbox.repaint();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static Date getTimestamp(Packet packet) {
        DelayInformation delay = (DelayInformation)packet.getExtension("x", "jabber:x:delay");
        if (delay != null) {
            return delay.getStamp();
        }
        return new Date();
    }

    boolean isToday(Date date) {
        return this.isSameDate(date, new Date());
    }

    boolean isSameDate(Date date, Date date2) {
        if (date == null) {
            return false;
        }
        return date.getDate() == date2.getDate() && date.getMonth() == date2.getMonth() && date.getYear() == date2.getYear();
    }

    protected void insertPresence(final Presence presence) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatPanel.this.statusLine.setForeground(Color.black);
                ChatPanel.this.statusLine.setText("<html><b>" + StringUtils.parseResource((String)presence.getFrom()) + "</b> is now " + presence.getType() + "</html>");
                new Fader(ChatPanel.this.statusLine).start();
            }
        });
    }

    protected void setEndSelection() {
        this.inbox.setSelectionStart(this.inbox.getDocument().getLength());
        this.inbox.setSelectionEnd(this.inbox.getDocument().getLength());
    }

    private static class Fader {
        private JComponent target;
        private Timer timer = new Timer(50, new ActionListener(){
            int c = 0;

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.c += 10;
                if (this.c > 255) {
                    this.c = 0;
                    Fader.this.timer.stop();
                    return;
                }
                Color newc = new Color(this.c, this.c, this.c);
                Fader.this.target.setForeground(newc);
            }
        });

        public Fader(JComponent target) {
            this.target = target;
            this.timer.setInitialDelay(2000);
        }

        public void start() {
            this.timer.start();
        }
    }

    private class PresenceListener
    implements PropertyChangeListener {
        private PresenceListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.refreshOnlineStatus();
                }
            });
        }
    }

    private class ChatListener
    implements PacketListener,
    MessageListener {
        private ChatListener() {
        }

        public void processPacket(Packet packet) {
            this.processMessage(ChatPanel.this.suc, (Message)packet);
        }

        public void processMessage(Chat arg0, final Message message) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.setEndSelection();
                    ChatPanel.this.insertMessage(message);
                    if (!ChatPanel.this.isVisible()) {
                        ChatTopComponent.findInstance().setModified(ChatPanel.this);
                    }
                }
            });
        }
    }

    private class NotificationsEnabledAction
    implements ActionListener {
        private NotificationsEnabledAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem m = (JCheckBoxMenuItem)e.getSource();
            ChatNotifications.getDefault().setEnabled(ChatPanel.this.getName(), m.getState());
        }
    }
}

