/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.dashboard.MemberNode;
import org.netbeans.modules.kenai.ui.dashboard.ProjectNode;
import org.netbeans.modules.kenai.ui.dashboard.SectionNode;
import org.netbeans.modules.kenai.ui.spi.MemberAccessor;
import org.netbeans.modules.kenai.ui.spi.MemberHandle;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.NbBundle;

public class MemberListNode
extends SectionNode {
    private MessagingHandle msg;
    private PropertyChangeListener l;
    private static final String PROP_MEMBERS = "members";

    public MemberListNode(ProjectNode parent) {
        super(MemberListNode.getText(MessagingAccessor.getDefault().getMessaging(parent.getProject())), parent, PROP_MEMBERS);
        this.msg = MessagingAccessor.getDefault().getMessaging(this.project);
        this.l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("onlineCount".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (MemberListNode.this.lblName != null) {
                                MemberListNode.this.lblName.setText(MemberListNode.getText(MemberListNode.this.msg));
                            }
                        }
                    });
                }
            }
        };
        this.msg.addPropertyChangeListener(this.l);
    }

    private static String getText(MessagingHandle msg) {
        int count = msg.getOnlineCount();
        if (count >= 0) {
            return NbBundle.getMessage(MemberListNode.class, (String)"LBL_MembersOnline", (Object)msg.getOnlineCount());
        }
        return NbBundle.getMessage(MemberListNode.class, (String)"LBL_Members");
    }

    @Override
    protected List<TreeListNode> createChildren() {
        ArrayList<TreeListNode> res = new ArrayList<TreeListNode>(20);
        MemberAccessor accessor = MemberAccessor.getDefault();
        List<MemberHandle> sources = accessor.getMembers(this.project);
        for (MemberHandle s : sources) {
            res.add(new MemberNode(s, (TreeListNode)this));
        }
        return res;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.msg != null) {
            this.msg.removePropertyChangeListener(this.l);
        }
    }
}

