/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

class NativeToolsUtil {
    public static final String _64 = "_64";

    private NativeToolsUtil() {
    }

    public static boolean isMacOSX(ExecutionEnvironment execEnv) {
        try {
            HostInfo info = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            return info.getOSFamily() == HostInfo.OSFamily.MACOSX;
        }
        catch (IOException ex) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return false;
    }

    public static Map<String, File> getCompatibleBinaries(ExecutionEnvironment execEnv, String name) {
        MacroExpanderFactory.MacroExpander mef = MacroExpanderFactory.getExpander((ExecutionEnvironment)execEnv);
        try {
            File secondary;
            LinkedHashMap<String, File> binaries = new LinkedHashMap<String, File>();
            String dirname = mef.expandPredefinedMacros("${osname}-${platform}${_isa}");
            String filename = mef.expandPredefinedMacros(name);
            File primary = NativeToolsUtil.locateFile(dirname, filename);
            if (primary != null) {
                binaries.put(dirname, primary);
            }
            if (dirname.endsWith(_64) && (secondary = NativeToolsUtil.locateFile(dirname = dirname.substring(0, dirname.length() - _64.length()), filename)) != null) {
                binaries.put(dirname, secondary);
            }
            return binaries;
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyMap();
        }
    }

    private static File locateFile(String dirname, String filename) {
        return InstalledFileLocator.getDefault().locate("tools" + File.separator + dirname + File.separator + "bin" + File.separator + filename, null, false);
    }
}

