/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

public final class TypeID {
    private static final char PRIMITIVE_ID = 'P';
    private static final char ENUM_ID = 'E';
    private static final char COMPONENT_ID = 'C';
    private String encoded;
    private Kind kind;
    private String string;
    private int dimension;

    private TypeID(String string) {
        this.decode(string);
        this.encoded = string;
    }

    public TypeID(Kind kind, String string) {
        this(kind, string, 0);
    }

    public TypeID(Kind kind, String string, int dimension) {
        this.kind = kind;
        this.string = string;
        this.dimension = dimension;
        this.encoded = this.encode();
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getString() {
        return this.string;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getEncoded() {
        return this.encoded;
    }

    private void decode(String string) {
        assert (string != null && string.length() >= 1);
        int pos = 0;
        this.dimension = 0;
        while (true) {
            assert (pos < string.length());
            char c = string.charAt(pos);
            if (c < '0' || c > '9') break;
            this.dimension = this.dimension * 10 + (c - 48);
            ++pos;
        }
        assert (pos < string.length());
        switch (string.charAt(pos)) {
            case 'P': {
                this.kind = Kind.PRIMITIVE;
                break;
            }
            case 'E': {
                this.kind = Kind.ENUM;
                break;
            }
            case 'C': {
                this.kind = Kind.COMPONENT;
            }
        }
        this.string = string.substring(++pos);
    }

    private String encode() {
        StringBuilder buffer = new StringBuilder();
        if (this.dimension > 0) {
            buffer.append(this.dimension);
        }
        switch (this.kind) {
            case PRIMITIVE: {
                buffer.append('P');
                break;
            }
            case ENUM: {
                buffer.append('E');
                break;
            }
            case COMPONENT: {
                buffer.append('C');
            }
        }
        return buffer.append(this.string).toString();
    }

    public TypeID getComponentType() {
        assert (this.dimension > 0);
        return new TypeID(this.kind, this.string, this.dimension - 1);
    }

    public TypeID getArrayType() {
        return new TypeID(this.kind, this.string, this.dimension + 1);
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.encoded.equals(((TypeID)o).encoded);
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public String toString() {
        return this.encoded;
    }

    public static TypeID createFrom(String string) {
        return string != null ? new TypeID(string) : null;
    }

    public static enum Kind {
        PRIMITIVE,
        ENUM,
        COMPONENT;

    }
}

