'''OpenGL extension EXT.cull_vertex

Overview (from the spec)
	
	This extension introduces a method for culling vertexes in object
	space based on the value of the dot product between the normal at
	the vertex and a culling eye direction.
	
	Culling a polygon by examining its vertexes in object space can be
	more efficient than screen space polygon culling since the transformation
	to screen space (which may include a division by w) can be avoided for
	culled vertexes.  Also, vertex culling can be computed before vertexes
	are assembled into primitives.  This is a useful property when drawing
	meshes with shared vertexes, since a vertex can be culled once, and the
	resulting state can be used for all primitives which share the vertex.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/cull_vertex.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_cull_vertex'
GL_CULL_VERTEX_EXT = constant.Constant( 'GL_CULL_VERTEX_EXT', 0x81AA )
GL_CULL_VERTEX_EYE_POSITION_EXT = constant.Constant( 'GL_CULL_VERTEX_EYE_POSITION_EXT', 0x81AB )
GL_CULL_VERTEX_OBJECT_POSITION_EXT = constant.Constant( 'GL_CULL_VERTEX_OBJECT_POSITION_EXT', 0x81AC )
glCullParameterdvEXT = platform.createExtensionFunction( 
	'glCullParameterdvEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLdoubleArray,),
	doc = 'glCullParameterdvEXT( GLenum(pname), GLdoubleArray(params) ) -> None',
	argNames = ('pname', 'params',),
)

glCullParameterfvEXT = platform.createExtensionFunction( 
	'glCullParameterfvEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glCullParameterfvEXT( GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('pname', 'params',),
)


def glInitCullVertexEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
