/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.animator;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Widget;

public final class PreferredBoundsAnimator
extends Animator {
    private HashMap<Widget, Rectangle> sourceBounds = new HashMap();
    private HashMap<Widget, Rectangle> targetBounds = new HashMap();
    private HashMap<Widget, Boolean> nullBounds = new HashMap();

    public PreferredBoundsAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setPreferredBounds(Widget widget, Rectangle rectangle) {
        assert (widget != null);
        this.sourceBounds.clear();
        boolean bl = rectangle == null;
        this.nullBounds.put(widget, bl);
        Rectangle rectangle2 = null;
        if (bl && widget.isPreferredBoundsSet()) {
            rectangle2 = widget.getPreferredBounds();
            widget.setPreferredBounds(null);
        }
        this.targetBounds.put(widget, bl ? widget.getPreferredBounds() : rectangle);
        if (rectangle2 != null) {
            widget.setPreferredBounds(rectangle2);
        }
        this.start();
    }

    protected void tick(double d) {
        for (Map.Entry<Widget, Rectangle> entry : this.targetBounds.entrySet()) {
            Widget widget = entry.getKey();
            Rectangle rectangle = this.sourceBounds.get(widget);
            if (rectangle == null) {
                rectangle = widget.getBounds();
                if (rectangle == null) {
                    rectangle = new Rectangle();
                }
                this.sourceBounds.put(widget, rectangle);
            }
            Rectangle rectangle2 = entry.getValue();
            Rectangle rectangle3 = d >= 1.0 ? (this.nullBounds.get(widget) != false ? null : rectangle2) : new Rectangle((int)((double)rectangle.x + d * (double)(rectangle2.x - rectangle.x)), (int)((double)rectangle.y + d * (double)(rectangle2.y - rectangle.y)), (int)((double)rectangle.width + d * (double)(rectangle2.width - rectangle.width)), (int)((double)rectangle.height + d * (double)(rectangle2.height - rectangle.height)));
            widget.setPreferredBounds(rectangle3);
        }
        if (d >= 1.0) {
            this.sourceBounds.clear();
            this.targetBounds.clear();
            this.nullBounds.clear();
        }
    }
}

