Didacticiel d'Emacs.  Voir la fin de ce document pour les conditions.
Copyright (c) 1985, 2001, 2002 Free Software Foundation, Inc.

Les commandes Emacs utilisent gnralement la touche CONTROLE (souvent
dsigne par CTRL ou CTL) ou la touche META (souvent dsigne par EDIT
ou ALT). Pour ces touches, nous utiliserons les abrviations suivantes :

 C-<car> signifie qu'il faut maintenir la touche CONTROLE appuye tout
         en tapant le caractre <car>. Ainsi, C-f signifie : presser
         sur la touche CONTROLE tout en pressant la touche f.
 M-<car> signifie qu'il faut maintenir la touche META ou EDIT ou ALT
	 appuye tout en tapant le caractre <car>. Si aucune de ces
	 touches n'existe, pressez puis relchez la touche ESC et
	 tapez <car>. Nous crirons <ESC> pour dsigner la touche ESC.

Tapez C-x C-c (deux caractres) pour terminer une session Emacs.
Dans ce didacticiel, les caractres ">>" en marge gauche indiquent les
directions  suivre pour essayer une commande. Ainsi :
<<Lignes blanches insres aprs cette ligne par help-with-tutorial>>
[Centre de page deliberement vide. Le texte continue ci-dessous.]
>>  Tapez C-v (Voir l'cran suivant) pour passer  l'cran suivant
    (faites-le, pressez la touche CTRL tout en pressant la touche v).
     partir de maintenant, vous devrez le faire  chaque fois que
    vous avez fini de lire l'cran.

Vous remarquerez qu'il y a un recouvrement de deux lignes lorsque l'on
passe d'un cran  un autre : cela permet une certaine continuit dans
la lecture du texte.

La premire chose que vous devez savoir est comment vous dplacer 
travers le texte. Vous savez dj comment avancer d'un cran avec
C-v. Pour revenir un cran en arrire, tapez M-v (pressez la touche
META tout en appuyant sur v ou faites <ESC>v si vous n'avez pas de
touche META, EDIT ou ALT).

>>  Faites M-v, puis C-v plusieurs fois.

Si votre terminal en dispose, vous pouvez galement utiliser les
touches PgUp et PgDn pour monter ou descendre d'un cran, bien les
combinaisons C-v et M-v soient plus efficaces.

* RSUM
--------

Les commandes suivantes servent  manipuler des crans :

	C-v	Avance d'un cran
	M-v	Recule d'un cran
	C-l     Efface l'cran et raffiche tout le texte autour du
                curseur, qui est plac au milieu de l'cran 
                (il s'agit de CTRL-L, pas de CTRL-1).
		

>> Notez le texte situ  ct du curseur, puis faites C-l.
   Recherchez l'emplacement du curseur et vous remarquerez que
   c'est le mme texte qui est  ct de lui.


* GESTION DU CURSEUR
--------------------

Passer d'un cran  l'autre est pratique, mais comment se dplacer 
un endroit prcis du texte dans un cran ?

Il existe plusieurs faons de faire. Vous pouvez utiliser les touches
du curseur, mais il est plus efficace de garder vos mains dans la mme
position et d'utiliser les commandes C-p, C-b, C-f, et C-n.  Ces
combinaisons sont quivalentes aux quatre touches du curseur :
 
			  Ligne prcdente, C-p
				  :
				  :
   En arrire, C-b ....   Position courante  .... Vers l'avant, C-f
				  :
				  :
			  Ligne suivante, C-n

>> Dplacez le curseur sur la ligne situe au milieu de ce schma en
   utilisant C-n ou C-p. Puis, faites C-l pour placer le schma au 
   centre de l'cran.

Si vous connaissez un peu l'anglais, vous aurez srement constat
qu'il tait facile de se rappeler que P signifiait Previous
(prcdent), N Next (suivant), B Backward (en arrire) et F Forward
(vers l'avant). 

>> Faites quelques C-n pour amener le curseur sur cette ligne.

>> Dplacez-vous le long de la ligne avec des C-f, puis au-dessus avec
   des C-p. Notez ce que fait C-p lorsque le curseur est au milieu de
   la ligne.
  

Chaque ligne de texte se termine par un caractre Newline, qui sert 
la sparer de la ligne suivante. La dernire ligne de votre fichier
devrait se terminer par un Newline (mais Emacs n'exige pas qu'il y en
ait un).

>> Essayez de faire C-b au dbut d'une ligne. Cela devrait dplacer le
   curseur  la fin de la ligne prcdente car il passe au-dessus du
   caractre Newline.

C-f peut passer au-dessus d'un Newline, tout comme C-b.

>> Faites encore quelques C-b afin de bien sentir o est le curseur. 
   Puis, faites des C-f pour revenir  la fin de la ligne.
   Enfin, faites quelques C-f supplmentaires pour passer  la ligne
   suivante.

Lorsque vous dpassez le haut ou le bas de l'cran, le texte au-del
de ces limites est dcal pour passer dans l'cran : c'est ce qu'on
appelle le  scrolling . Cela permet  Emacs de placer le curseur 
l'emplacement spcifi dans le texte sans devoir le placer en dehors
de l'cran.

>> Essayez de placer le curseur au-del du bas de l'cran avec C-n et
   constatez ce qui se passe.

Si le dplacement caractre par caractre est trop lent, vous pouvez
vous dplacer mot par mot. M-f (Meta-f) avance d'un mot et M-b recule
d'un mot.

>> Faites quelques M-f et M-b.

Lorsque vous tes au milieu d'un mot, M-f place le curseur  la fin du
mot. Lorsque vous tes entre deux mots, M-f place le curseur  la fin
du mot suivant. M-b fonctionne de la mme faon dans la direction
oppose.

>> Faites plusieurs fois M-f et M-b, espacs de C-f et C-b afin
   d'observer l'action de M-f et M-b aux diffrents emplacements 
   l'intrieur et  l'extrieur des mots.

Notez le parallle entre C-f et C-b d'un ct et M-f et M-b de
l'autre. Trs souvent, les caractres Meta servent  des oprations
sur des units dfinies par le langage (mots, phrases, paragraphe)
alors que les caractres de contrle oprent sur les units de base
indpendantes de ce que l'on dite (caractres, lignes, etc.).

Ce parallle s'applique entre les lignes et les phrases : C-a et C-e
dplacent le curseur au dbut ou  la fin d'une ligne, tandis que M-a
et M-e le placent au dbut ou  la fin d'une phrase.

>> Faites quelques C-a, puis quelques C-e.
   Faites quelques M-a, puis quelques M-e.

Vous constaterez que la rptition d'un C-a ne fait rien, mais que
celle d'un M-a vous dplace d'une phrase de plus. Bien que ces deux
commandes ne soient pas tout  fait analogues, chacune d'elle semble
naturelle.

L'emplacement du curseur dans le texte est galement appel  point .
Pour paraphraser, le curseur apparat  l'cran  l'endroit o le
point est situ dans le texte.

Voici un rsum des oprations de dplacements simples du curseur, 
ainsi que les commandes de dplacement par mots et par phrases.

	C-f	Avance d'un caractre
	C-b	Recule d'un caractre

	M-f	Avance d'un mot
	M-b	Recule d'un mot

	C-n	Avance d'une ligne
	C-p	Recule d'une ligne

	C-a	Va au dbut de la ligne
	C-e	Va  la fin de la ligne

	M-a	Va au dbut de la phrase
	M-e	Va  la fin de la phrase

>> Essayez toutes ces commandes plusieurs fois afin de vous entraner. 
   Ce sont celles qui sont utilises le plus souvent.

M-< (Meta infrieur ) et M-> (Meta suprieur ) sont deux autres
commandes importantes de dplacement du curseur. La premire renvoie
au tout dbut du texte, la seconde  la fin de celui-ci.

Sur certains claviers, le "<" se trouve sous la virgule, vous devez
donc utiliser la touche <Maj> pour y avoir accs. Sur ces terminaux,
vous devez utiliser galement la touche <Maj> pour faire M-<, sinon
vous taperiez M-virgule.

>> Faites M-< afin de vous dplacer au dbut du didacticiel.
   Puis, faites plusieurs fois C-v pour revenir ici.

>> Faites M-> afin de vous dplacer  la fin du didacticiel.
   Puis, faites plusieurs fois M-v pour revenir ici.
 
Vous pouvez galement dplacer le curseur  l'aide des touches de
curseur, si votre terminal en dispose. Nous vous conseillons
d'apprendre  utiliser C-b, C-f, C-n et C-p pour trois raisons. Tout
d'abord, ces commandes fonctionnent sur tous les types de
terminaux. Ensuite, lorsque vous aurez un peu pratiqu Emacs, vous
vous rendrez compte qu'il est plus rapide de taper ces caractres de
contrle que d'utiliser les touches de curseur (car vous n'avez pas
besoin de dplacer vos mains pour atteindre ces touches). Enfin,
lorsque vous aurez l'habitude d'utiliser ces commandes, vous
apprendrez plus facilement les autres commandes de dplacement plus
puissantes.

La plupart des commandes Emacs acceptent un paramtre numrique qui,
la plupart du temps, indique un nombre de rptitions. Pour indiquer 
une commande le nombre de fois que l'on souhaite la rpter, on
utilise C-u suivi du nombre avant de taper la commande. Si vous avez
une touche META (ou EDIT ou ALT), il existe une autre faon d'entrer
un paramtre numrique : tapez le nombre tout en pressant la touche
META. Nous vous conseillons d'apprendre  utiliser la mthode C-u car
elle fonctionne sur tous les types de terminaux. Le paramtre
numrique est galement appel  paramtre prfixe  car on le prcise
avant la commande sur laquelle il s'applique.

C-u 8 C-f, par exemple, avance le curseur de huit caractres.
	
>> Utilisez C-n ou C-p avec un paramtre numrique afin de dplacer,
   en une seule commande, le curseur sur une ligne proche de celle-ci.

La plupart des commandes utilisent le paramtre numrique pour
indiquer un nombre de rptitions, mais d'autres s'en servent
autrement. Plusieurs commandes (mais aucune de celles que nous avons
vues jusqu' maintenant) l'utilisent comme indicateur -- la prsence
d'un paramtre prfixe, quelle que soit sa valeur, force la commande 
agir diffremment.

C-v et M-v constituent un autre type d'exception.  Lorsqu'on leur
donne un paramtre, elles font dfiler l'cran vers le haut ou vers le
bas du nombre de lignes indiqu au lieu de passer d'un cran complet 
l'autre. C-u 8 C-v, par exemple, fait dfiler l'cran de 8 lignes.

>> Faites C-u 8 C-v.

Cela a d dplacer l'cran de 8 lignes vers le haut. Si vous voulez
redescendre de 8 lignes, il suffit de passer ce nombre comme paramtre
de M-v.

Si vous utilisez un environnement graphique, comme X11 ou MS-Windows,
il devrait y avoir une zone rectangulaire appele barre de dfilement,
ou  scrollbar  sur le bord gauche de la fentre d'Emacs. Vous pouvez
faire dfiler le texte en cliquant avec la souris dans cette barre de
dfilement.

>> Cliquez avec le bouton du milieu en haut de la zone mise en
   vidence dans la barre de dfilement. Cela devrait dplacer le
   texte jusqu' une position dpendant de la hauteur o vous avez
   cliqu. 

>> Dplacez la souris de bas en haut tout en maintenant son bouton du
   milieu press. Vous constaterez que le texte dfile vers le haut et
   vers le bas en fonction du dplacement de la souris.


* QUAND EMACS EST MUET
----------------------

Si Emacs cesse de rpondre  vos commandes, vous pouvez le dbloquer
en toute scurit avec C-g. Cette commande fait stopper une commande
qui met trop de temps  s'excuter.

C-g peut galement servir  annuler un paramtre numrique, ou le
dbut d'une commande que vous ne souhaitez pas terminer.

>> Faites C-u 100 pour former un paramtre numrique de 100, puis
   tapez C-g. 
   Faites maintenant C-f. Le dplacement ne sera que d'un caractre
   car vous avez annul le paramtre avec C-g.

Si vous avez tap <ESC> par erreur, vous pouvez vous en dbarrasser
avec un C-g.


*  COMMANDES DSACTIVES
------------------------

Certaines commandes d'Emacs sont  dsactives  afin que les
utilisateurs dbutants ne puissent les utiliser par accident.

Si vous tapez l'une de ces commandes, Emacs affiche un message
indiquant quelle tait la commande et vous demande si vous souhaitez
continuer et l'excuter.

Si vous souhaitez vraiment essayer la commande, tapez <Espace> en
rponse  la question. Si vous ne voulez pas excuter la commande
dsactive, il suffit normalement de rpondre  n .

>> Faites C-x C-l (qui est une commande dsactive), 
   puis rpondez n  la question.

* FENTRES
----------

Emacs peut avoir plusieurs fentres, chacune affichant son propre
texte. Nous expliquerons plus tard comment utiliser plusieurs fentres ; 
pour l'instant, nous expliquerons comment se dbarrasser des
fentres supplmentaires pour revenir  une dition mono-fentre. 
C'est trs simple :

	C-x 1	Une seule fentre (i.e., supprime toutes les autres)

Il s'agit de CTRL-x suivi du chiffre 1. C-x 1 tend la fentre
contenant le curseur pour qu'elle occupe tout l'cran. Cette commande
supprime toutes les autres fentres.

>> Dplacez le curseur sur cette ligne et faites C-u 0 C-l.
>> Faites CONTROLE-h k CONTROLE-f.
   Vous constatez que cette fentre est rduite alors qu'une nouvelle
   apparat pour afficher la documentation sur la commande CONTROLE-f.

>> Faites C-x 1 et la fentre de documentation disparat.

Cette commande est diffrente de celles que nous avons dj vues car
elle est forme de deux caractres. Elle commence par le caractre
CONTROLE-x, comme le font de nombreuses commandes de manipulation de
fentres, fichiers, tampons et autres entits associes. Ces commandes
font deux, trois ou quatre caractres.


* INSERTION ET SUPPRESSION
--------------------------

Si vous voulez insrer du texte, il vous suffit de le taper. Les
caractres que vous pouvez lire, comme A, 7, *, etc. sont considrs
comme du texte par Emacs et insrs immdiatement. Tapez <Entre> (la
touche de retour chariot) pour insrer un caractre Newline.

Vous pouvez effacer le dernier caractre que vous avez tap en faisant
<Delback>. <Delback> est une touche du clavier -- la mme que vous
utilisez habituellement en dehors d'Emacs, pour supprimer le dernier
caractre saisi. Il s'agit gnralement de la grande touche situe
quelques lignes au-dessus de la touche  Entre . Elle est
habituellement nomme  Delete ,  Del ,  Suppr  ou  Backspace .

Si cette grande touche s'appelle  Backspace , c'est celle-l qui
reprsente <Delback>. Votre clavier peut galement comporter une autre
touche, nomme  Delete ,  Del  ou  Suppr , mais ce n'est pas
<Delback>.

Plus gnralement, <Delback> efface le caractre situ immdiatement
avant la position courante du curseur.

>> Tapez quelques caractres puis effacez-les en faisant plusieurs 
   fois <Delback>. Ne vous inquitez pas de modifier ce fichier ; vous
   ne modifierez pas le didacticiel principal mais uniquement votre
   copie personnelle de celui-ci.

Lorsqu'une ligne de texte devient trop longue pour tenir sur une seule
ligne de l'cran, elle se  continue  sur une deuxime ligne
d'cran. Une barre de fraction inverse ( \ ) ou, si vous utilisez un
environnement grapgique, une petite flche recourbe, sur la marge
droite indique une ligne qui se poursuit sur la ligne suivante.

>> Insrez du texte jusqu' atteindre la marge droite et continuez
   d'en insrer. Vous verrez apparatre une ligne de continuation.

>> Faites des <Delback> pour effacer le texte jusqu' ce que la ligne
   tienne  nouveau sur une seule ligne d'cran. La ligne de
   continuation disparat.

Vous pouvez effacer un caractre Newline comme n'importe quel autre
caractre. La suppression d'un Newline entre deux lignes les fusionne
en une seule ligne. Si la ligne rsultante est trop longue pour tenir
dans la largeur de l'cran, elle s'affichera avec une ligne de
continuation.

>> Placez le curseur au dbut d'une ligne et faites <Delback>. 
   Cela fusionne cette ligne avec la ligne prcdente.

>> Faites <Entre> pour remettre le Newline que vous avez supprim.

Rappelez-vous que la plupart des commandes Emacs peuvent utiliser un
nombre de rptitions ; les caractres de texte font de mme. La
rptition d'un caractre de texte l'insre plusieurs fois.

>>  Faites C-u 8 * pour insrer ********.

Vous connaissez maintenant la mthode la plus simple pour taper du
texte dans Emacs et pour corriger les erreurs. Vous pouvez galement
effacer des mots ou des lignes entires. Voici un rsum des
oprations de suppression :

	<Delback>    Efface le caractre situ avant le curseur
	C-d   	     Efface le caractre situ aprs le curseur

	M-<Delback>  Supprime le mot situ avant le curseur
	M-d	     Supprime le mot situ aprs le curseur

	C-k	     Supprime du curseur  la fin de la ligne
	M-k	     Supprime jusqu' la fin de la phrase courante

Vous noterez que <Delback> et C-d, par rapport  M-<Delback> et M-d,
ont la mme relation que C-f et M-f (en fait, <Delback> n'est pas
vraiment un caractre de contrle, mais ne nous soucions pas de cela)
C-k et M-k sont un peu comme C-e et M-e.

Vous pouvez aussi supprimer n'importe quelle zone du tampon en
utilisant une mthode unique et gnrale. Placez-vous  une extrmit
de cette zone et tapez soit C-@, soit C-SPC (SPC dsigne la barre
espace). Puis, allez  l'autre extrmit et faites C-w. Cela supprime
tout le texte compris entre ces deux positions.

>> Placez le curseur sur le V au dbut du paragraphe prcdent.
>> Faites C-SPC. Emacs devrait afficher un message "Mark set"
   en bas de l'cran.
>> Dplacez le curseur sur le x d' extrmit , sur la seconde ligne
   du paragraphe.
>> Faites C-w.  Cela supprimera le texte allant du V jusqu'au
   caractre situ juste avant le x.

La diffrence entre  effacer  et  supprimer  est que vous pouvez
rinsrer le texte  supprim , alors que c'est impossible avec ce
qui a t  effac . La rinsertion d'un texte supprim s'appelle le
 yanking . Gnralement, les commandes qui tent beaucoup de texte
le suppriment (afin que vous puissiez le rcuprer), tandis que celles
qui ne font qu'ter un seul caractre, des lignes blanches ou des
espaces, les effacent (vous ne pouvez donc pas rcuprer ce texte).

>> Placez le curseur au dbut d'une ligne non vide puis faites
   C-k pour supprimer le texte de celle-ci.
>> Refaites C-k : vous verrez que cela supprime le Newline qui suit
   cette ligne.

Notez qu'un simple C-k supprime le contenu de la ligne et qu'un second
dtruit la ligne elle-mme, ce qui fait remonter toutes les lignes
suivantes. C-k traite son paramtre numrique d'une faon spciale :
il dtruit ce nombre de lignes ET leurs contenus. Ce n'est pas une
simple rptition : C-u 2 C-k dtruit deux lignes et leurs Newlines
alors que taper deux fois C-k n'aurait pas le mme effet.

Vous pouvez ramener le texte supprim  la place qu'il occupait ou 
n'importe quel autre emplacement du texte. Vous pouvez rcuprer
plusieurs fois ce texte afin d'en crer plusieurs copies. 

La commande de rcupration est C-y.  Elle rinsre le dernier texte
supprim  la position courante du curseur.

>> Essayez : faites C-y pour rcuprer le texte.

Si vous faites plusieurs C-k  la suite, tout le texte supprim est
sauvegard en mme temps, de sorte qu'un seul C-y ramnera toutes les
lignes d'un seul coup.

>> Faites plusieurs fois C-k.

Maintenant, pour rcuprer le texte dtruit :

>> Faites C-y, puis descendez le curseur de quelques lignes et refaites
   C-y. Vous savez maintenant comment copier du texte.

Que faire si vous avez du texte que vous voulez rcuprer et,
qu'ensuite, vous supprimez autre chose ? C-y rcuprerait la
suppression la plus rcente mais le texte prcdent n'est pas pour
autant perdu : vous pouvez le rappeler en utilisant la commande
M-y. Aprs avoir fait C-y pour rcuprer la suppression la plus
rcente, M-y remplacera ce texte rcupr par le texte supprim
prcdemment. En rptant les M-y, vous ramenez les suppressions de
plus en plus anciennes. Lorsque vous avez atteint le texte que vous
recherchez, vous n'avez rien besoin de faire pour le
conserver. Continuez simplement  diter votre texte et laissez le
texte rcupr o il est.

Si vous faites M-y suffisamment de fois, vous reviendrez  votre point
de dpart (la suppression la plus rcente).

>> Supprimez une ligne, dplacez vous et supprimez une autre ligne.
   Puis, faites C-y pour rcuprer cette dernire.
   Faites alors M-y et elle sera remplace par la premire ligne dtruite.  
   Faites d'autres M-y et notez ce que vous obtenez, continuez jusqu'
   ce que la seconde ligne supprime rapparaisse, et faites-en encore
   quelques-uns de plus. 
   Si vous le souhaitez, vous pouvez essayer de passer des paramtres
   positifs et ngatifs  M-y.


* ANNULATION
------------

Si vous modifiez le texte, puis que vous dcidez que c'tait une
erreur, vous pouvez annuler cette modification avec la commande C-x u
(comme Undo, dfaire).

Normalement C-x u annule les modifications d'une seule commande ; si
vous rptez plusieurs fois C-x u dans une ligne, chaque rptition
annulera une commande supplmentaire.

Il y a quand mme deux exceptions : les commandes qui ne modifient pas
le texte ne comptent pas (cela inclut les commandes de dplacement du
curseur et les commandes de dfilement du texte) et les caractres
auto-insrs sont habituellement grs par groupes allant jusqu' 20
(ceci afin de rduire le nombre de C-x u que vous devriez taper pour
annuler l'insertion de texte).

>> Supprimez cette ligne avec C-k, puis faites C-x u pour la voir
   rapparatre.

C-_ est une autre commande d'annulation ; elle fonctionne exactement
comme C-x u mais est plus facile  taper plusieurs fois dans une
ligne. Son inconvnient est qu'elle n'est pas facile  taper sur
certains claviers, c'est pourquoi C-x u existe aussi. Sur certains
terminaux, vous pouvez taper C-_ en tapant / tout en pressant la
touche CTRL.

Un paramtre numrique pass  C-_ ou C-x u agit comme un nombre de
rptitions.


* FICHIERS
----------

Afin de rendre permanent le texte que vous ditez, vous devez le
placer dans un fichier. Sinon, il disparatra en mme temps que votre
session Emacs. Pour placer un texte dans un fichier, vous devez
 trouver  le fichier avant d'entrer le texte (c'est ce que l'on
dsigne galement par  visiter  le fichier).

Trouver un fichier signifie que vous voyez le contenu de ce fichier
dans Emacs. Par de nombreux aspects, c'est comme si vous ditiez le
fichier lui-mme. Cependant, les modifications que vous faites avec
Emacs ne deviendront permanentes qu'aprs avoir  sauvegard  le
fichier : cela vite d'avoir un fichier  moiti modifi sur le
systme alors que vous ne le vouliez pas. Mme lorsque vous
sauvegardez, Emacs garde le fichier original sous un nom modifi au
cas o vous dcideriez ensuite d'annuler vos modifications.

Si vous examinez le bas de l'cran, vous verrez une ligne qui commence
et finit par des tirets et dbute par  --:-- TUTORIAL.fr  ou quelque
chose comme a. Cette partie de l'cran montre normalement le nom du
fichier que vous tes en train de visiter. Pour l'instant, vous
visitez un fichier appel  TUTORIAL.fr , qui est votre copie
personnelle du didacticiel Emacs. Lorsque vous trouvez un fichier avec
Emacs, son nom apparat  cet endroit prcis.

Une particularit de la commande permettant de trouver un fichier est
que vous devez donner le nom du fichier voulu. On dit que la commande
 lit un paramtre  partir du terminal  (ici, le paramtre est le
nom du fichier). Aprs avoir fait la commande 

	C-x C-f   Trouve un fichier

Emacs vous demande d'entrer le nom du fichier. Ce que vous tapez
s'inscrit dans la ligne situe en bas de l'cran : cette ligne
s'appelle le mini-tampon lorsqu'elle sert  ce type de saisie. Vous
pouvez utiliser les commandes d'dition habituelles d'Emacs pour
diter le nom du fichier.

Pendant que vous entrez le nom du fichier (ou pendant n'importe quelle
saisie dans le mini-tampon), vous pouvez annuler la commande par C-g.

>> Faites C-x C-f, puis C-g. Cela annule le mini-tampon et la commande
   C-x C-f qui utilisait celui-ci : vous ne trouvez donc aucun fichier.

Lorsque vous avez fini d'entrer le nom du fichier, tapez <Entre> pour
terminer la saisie. La commande C-x C-f effectue son travail et trouve
le fichier choisi. Le mini-tampon disparat lorsque C-x C-f a termin.

Au bout d'un court instant, le contenu du fichier apparat  l'cran
et vous pouvez l'diter. Lorsque vous voulez que vos modifications
deviennent permanentes, faites :

	C-x C-s   Sauvegarde le fichier

Cette commande copie dans le fichier le texte qui est dans Emacs. La
premire fois, Emacs renomme le fichier original afin qu'il ne soit
pas perdu. Le nom de cette sauvegarde est construit en ajoutant  ~ 
 la fin du nom initial.

Lorsque la sauvegarde est finie, Emacs affiche le nom du fichier
crit. Sauvegardez  intervalles rguliers afin de perdre le moins
possible de travail au cas o votre systme se planterait.

>> Faites C-x C-s pour sauvegarder votre copie du didacticiel.
   Cela devrait crire "Wrote ...TUTORIAL.fr" en bas de l'cran.

REMARQUE : Sur certains systmes, C-x C-s glera l'cran et vous ne
verrez plus rien se produire dans Emacs.  Cela indique qu'une 
 fonctionnalit  du systme d'exploitation, appele  contrle de flux ,
a intercept le C-s et ne lui permet pas de parvenir  Emacs. Pour
dcoincer l'cran, faites C-q puis consultez la section  Spontaneous
Entry to Incremental Search  dans le manuel d'Emacs pour avoir des
avis sur la gestion de cette  fonctionnalit .

Vous pouvez trouver un fichier existant pour le visualiser ou
l'diter. Vous pouvez galement trouver un fichier qui n'existe pas
encore. C'est ainsi que l'on cre un fichier avec Emacs : on trouve le
fichier, qui dmarre vide, puis on insre du texte. Lorsque l'on
demande   sauvegarder  le fichier, Emacs cre alors vraiment le
fichier avec le texte que l'on a insr.  partir de ce moment l,
vous pouvez considrer que vous ditez un fichier dj existant.


* TAMPONS
---------

Si vous trouvez un second fichier avec C-x C-f, le premier reste dans
Emacs. Vous pouvez y revenir en le retrouvant avec C-x C-f.  Il est
ainsi possible d'avoir un nombre assez important de fichiers dans
Emacs.

>> Crez un fichier nomm  truc  en faisant C-x C-f truc <Entre>.
   Puis, insrez du texte, ditez-le et sauvegardez  truc  en
   faisant C-x C-s.
   Enfin, faites C-x C-f TUTORIAL.fr <Entre> pour revenir au didacticiel.

Emacs stocke le texte de chaque fichier dans un objet appel  tampon .
Trouver un fichier cre un nouveau tampon dans Emacs. Pour voir la
liste des tampons existants dans votre session Emacs, faites 

	C-x C-b   Liste des tampons

>> Faites C-x C-b

Vous noterez que chaque tampon a un nom et qu'il peut galement avoir
un nom de fichier pour le fichier qu'il contient. TOUT texte que vous
pouvez voir dans une fentre Emacs fait toujours partie d'un tampon.

>> Faites C-x 1 pour faire disparatre la liste des tampons.

Lorsque vous avez plusieurs tampons, seul l'un d'entre eux est le
tampon "courant"  un instant donn : c'est celui que vous ditez. Si
vous souhaitez diter un autre tampon, vous devez "basculer" vers
lui. Pour basculer vers un tampon correspondant  un fichier, vous
pouvez le recharger avec C-x C-f mais il y a plus simple : utilisez la
commande C-x b en lui passant le nom du tampon.

>> Faites C-x b truc <Entre> pour revenir au tampon "truc", qui
   contient le texte du fichier "truc". 
   Puis, faites C-x b TUTORIAL <Entre> pour revenir  ce didacticiel.

La plupart du temps, le nom d'un tampon est le mme que celui du
fichier qu'il contient (sans le chemin), mais ce n'est pas toujours
vrai. La liste obtenue lorsque vous faites C-x C-b montre toujours les
noms de tous les tampons.

TOUT texte que vous visualisez dans une fentre Emacs fait toujours
partie d'un tampon, mais certains tampons ne correspondent pas  des
fichiers : le tampon "*Buffer List*", par exemple, ne contient pas de
fichiers mais la liste obtenue par C-x C-b. Le tampon "*Messages*" ne
correspond pas non plus  un fichier ; il contient la liste des
messages apparus dans la ligne d'tat pendant votre session Emacs.

>> Faites C-x C-b *Messages* <Entre> pour visualiser le tampon des
   messages.  
   Puis, faites C-x b TUTORIAL <Entre> pour revenir  ce didacticiel.

Si vous modifiez le texte d'un fichier, puis que vous chargez un autre
fichier, le premier ne sera pas sauvegard. Ses modifications restent
dans Emacs, dans le tampon qui lui est associ. La cration ou
l'dition du tampon du second fichier n'a aucun effet sur le tampon du
premier. C'est trs pratique, mais cela signifie aussi que vous avez
besoin d'une mthode simple pour sauvegarder le tampon du premier
fichier. Ce serait ennuyeux de devoir y revenir avec C-x C-f juste
pour le sauvegarder avec C-x C-s. On a donc :

	C-x s     Sauvegarde certains tampons

C-x s vous demande confirmation pour savoir s'il doit sauvegarder
chaque tampon contenant des modifications non encore sauvegardes. Il
vous demande, pour chacun de ces tampons, s'il doit le sauvegarder ou
non. 

>> Insrez une ligne de texte et faites C-x s.
   Cela devrait vous demander si vous souhaitez sauvegarder le tampon
   nomm TUTORIAL.fr. Rpondez par l'affirmative en tapant  y . 


* EXTENSION DU JEU DE COMMANDES
-------------------------------

Il y bien plus de commandes Emacs qu'il ne serait possible d'en crer
avec tous les caractres de contrle et les caractres Meta. Emacs
contourne ce problme  l'aide de la commande X (eXtension). Celle-ci
se prsente sous deux dclinaisons :

	C-x	eXtension caractre, suivie d'un seul caractre.
	M-x	eXtension d'une commande nomme, suivie d'un nom long.

Ces commandes sont gnralement des commandes utiles, mais elles sont
moins souvent utilises que celles que vous avez dj apprises. Vous
en avez dj rencontr deux : les commandes de fichiers C-x C-f pour
trouver un fichier et C-x C-s pour sauvegarder. Un autre exemple est
la commande qui met fin  la session Emacs : C-x C-c (ne vous
inquitez pour les modifications que vous avez faites, C-x C-c vous
proposera de sauvegarder tous les fichiers modifis avant de quitter
Emacs).

C-z est la commande permettant de quitter *temporairement* Emacs --
afin de pouvoir revenir  la mme session plus tard.

Sur les systmes qui le permettent, C-z  suspend  Emacs ;
c'est--dire qu'il revient au shell mais ne dtruit pas Emacs. Avec
les shells les plus courants, vous pouvez revenir  Emacs en faisant
la commande 'fg' ou '%emacs'.

Sur les systmes qui n'implmentent pas ce mcanisme, C-z cre un
sous-shell qui s'excute sous Emacs afin que vous puissiez lancer
d'autres programmes et revenir  Emacs ensuite : vous ne  sortez 
pas vraiment d'Emacs. Dans ce cas, la commande shell 'exit' est le
moyen habituel pour revenir  Emacs  partir de ce sous-shell.

Le moment idal pour utiliser C-x C-c est lorsque l'on se
dconnecte. C'est aussi la commande adapte pour sortir d'un Emacs
invoqu par un programme de courrier ou tout autre utilitaire car
ceux-ci peuvent ne pas savoir comment grer la suspension d'Emacs. Dans
des situations normales, si vous ne devez pas vous dconnecter, il est
prfrable de suspendre Emacs avec C-z au lieu de le quitter.

Il existe de nombreuses commandes C-x. Voici une liste de celles que
vous avez apprises :

	C-x C-f		Trouve un fichier.
	C-x C-s		Sauvegarde un fichier.
	C-x C-b		Liste des tampons.
	C-x C-c		Quitte Emacs.
	C-x 1		Dtruit toutes les fentres, sauf une.
	C-x u		Annulation.

Les eXtensions de commandes nommes sont des commandes utilises
encore moins souvent, ou des commandes qui ne servent que dans
certains modes. Un exemple est la commande replace-string, qui
remplace globalement une chane par une autre. Lorsque vous faites
M-x, Emacs affiche M-x en bas de l'cran et vous demande de taper le
nom de la commande,  replace-string  ici. Contentez-vous de faire
repl s<TAB>  et Emacs compltera le nom (<TAB> reprsente la touche
de tabulation, qui se trouve habituellement au-dessus de la touche de
verrouillage des majuscules,  gauche du clavier). Terminez la
commande en pressant <Entre>.

La commande replace-string ncessite deux paramtres -- la chane 
remplacer et la chane de remplacement. Vous devez terminer chaque
paramtre par <Entre>.

>> Dplacez le curseur sur la ligne blanche deux lignes plus bas.
   Puis, faites M-x repl s<Entre>change<Entre>modifie<Entre>.

   Notez comment cette ligne a t change : vous avez remplac le mot
   c-h-a-n-g--e par  modifie   chaque fois qu'il apparaissait aprs
   la position initiale du curseur.


* SAUVEGARDE AUTOMATIQUE
------------------------

Lorsque vous avez modifi un fichier, mais que vous ne l'avez pas
encore sauvegard, ces modifications pourraient tre perdues si votre
systme se plantait. Pour vous protger ce de problme, Emacs crit
priodiquement un fichier de  sauvegarde automatique  pour chaque
fichier en cours d'dition. Le nom de ce fichier commence et se
termine par un # : si, par exemple, votre fichier s'appelle
hello.c, son fichier de sauvegarde automatique s'appellera
#hello.c#. Lorsque vous sauvegardez le fichier de la faon
habituelle, Emacs dtruit son fichier de sauvegarde automatique.

Si l'ordinateur se plante, vous pouvez rcuprer ce qui a t
sauvegard automatiquement en ouvrant normalement le fichier (celui
que vous ditiez, pas la sauvegarde automatique), puis en faisant
M-xrecover file<Entre>. Lorsqu'Emacs vous demande de confirmer,
tapez yes<Entre> pour continuer et rcuprer ainsi les donnes
sauves par la sauvegarde automatique.


* ZONE D'ECHO
-------------

Si Emacs constate que vous tapez les commandes multi-caractres
lentement, il les affiche en bas de l'cran dans une zone nomme 
zone d'cho . La zone d'cho contient la dernire ligne de l'cran.


* LIGNE DE MODE
---------------

La ligne place immdiatement au dessus de la zone d'cho s'appelle la
 ligne de mode . Elle affiche quelque chose comme a :

--:**  TUTORIAL.fr          (Fundamental)--L752--67%----------------

Cette ligne donne des informations sur l'tat d'Emacs et sur le texte
que vous tes en train d'diter.

Vous savez dj ce que signifie le nom de fichier -- c'est celui que
vous avez charg.  -NN%-- indique votre position actuelle dans le
texte ; cela signifie que NN pourcent du texte se trouve au dessus du
sommet de l'cran. Si le dbut du fichier est sur l'cran, il
s'affichera --Top-- et non --00%--.  Si le bas du texte est sur
l'cran, il s'affichera --Bot--. Si tout le texte tient dans l'cran,
il s'affichera --All--.

Le L et les chiffres qui le suivent indiquent une position d'une faon
diffrente : ils indiquent le numro de la ligne courante du point.

Les astrisques au dbut signifient que vous avez modifi le
texte. Lorsque vous venez de visiter ou sauvegarder un fichier, cette
partie de la ligne de mode n'affichera pas d'astrisques mais
simplement des tirets.

La partie de la ligne de mode situe entre parenthses indique les
modes d'dition dans lesquels vous vous trouvez. Le mode par dfaut
est  Fundamental  et c'est celui que vous tes en train
d'utiliser. C'est un exemple de  mode majeur .

Emacs possde de nombreux modes majeurs diffrents. Certains sont
prvus pour diter diffrents langages et/ou types de texte (mode
Lisp, mode Text, etc).  tout instant, il n'y a qu'un seul mode majeur
actif et son nom se trouve toujours dans la ligne de mode,  l'endroit
ou  Fundamental  se trouve actuellement.

Chaque mode majeur modifie le comportement de quelques commandes. Il
existe, par exemple, des commandes pour crer des commentaires dans un
programme et, comme chaque langage de programmation a sa propre
syntaxe pour les commentaires, chaque mode majeur doit insrer ceux-ci
de faon diffrente. Un mode majeur est le nom d'une commande tendue,
qui vous permet de basculer dans ce mode. M-x fundamental-mode, par
exemple, est une commande pour basculer dans le mode Fundamental.

Si vous devez diter du texte en langage naturel, comme ce fichier,
vous utiliserez probablement le mode Text.

>> Faites M-x text mode<Entre>.

Ne vous inquitez pas, aucune des commandes Emacs que vous avez
apprises ne change beaucoup mais vous pouvez constater que M-f et M-b
traitent maintenant les apostrophes comme des parties de mots. Avant,
dans le mode Fundamental, M-f et M-b les considraient comme des
sparateurs de mots.

Les modes majeurs font gnralement des modifications subtiles comme
celle-ci : la plupart des commandes font  la mme chose  dans tous
les modes majeurs, mais fonctionnent un peu diffremment.

Pour lire la documentation sur votre mode majeur actuel, faites C-h m.

>> Faites une fois C-u C-v pour amener cette ligne prs du haut de l'cran.
>> Faites C-h m pour voir comment le mode Text diffre du mode Fundamental.
>> Faites C-x 1 pour supprimer la documentation de l'cran.

Les modes majeurs sont appels ainsi parce qu'il existe aussi des modes
mineurs. Ces derniers ne sont pas des alternatives aux modes majeurs,
mais simplement des modifications de ceux-ci. Tout mode mineur peut
tre activ ou dsactiv indpendamment de tous les autres modes
mineurs et de votre mode majeur. Vous pouvez donc n'utiliser aucun
mode mineur, un seul, ou toute combinaison de plusieurs modes mineurs.

Un mode mineur trs utile, surtout lorsque l'on dite du langage
naturel, est le mode Auto Fill. Lorsqu'il est activ, Emacs coupe
automatiquement la ligne entre les mots lorsque vous insrez du texte
et que la ligne est trop longue.

Vous pouvez activer le mode Auto Fill en faisant M-x auto fill
mode<Entre>.  Lorsqu'il est activ, vous pouvez le dsactiver en
faisant  nouveau M-xauto fill mode<Entre>.  Si le mode est
dsactiv, cette commande l'active et, s'il est activ, elle le
dsactive : on dit que la commande  fait basculer le mode .

>> Faites M-x auto fill mode<Entre> puis insrez une ligne de
   plusieurs  azer   jusqu' ce qu'elle se divise en deux lignes. 
   Vous devez mettre des espaces entre eux car le mode Auto Fill ne
   coupe les lignes que sur les espaces.

La marge est habituellement fixe  70 caractres, mais pouvez
modifier cette valeur avec la commande C-x f. Vous devez fournir la
nouvelle valeur de la marge sous la forme d'un paramtre numrique.

>> Faites C-x f avec un paramtre de 20 (C-u 2 0 C-x f).
   Puis, tapez du texte et vous verrez qu'Emacs fait des lignes de 20
   caractres. Remettez la marge  70 en refaisant C-x f.

Si vous faites des modifications au milieu d'un paragraphe, le mode
Auto Fill ne reformatera pas ce paragraphe.  
Pour cela, faites M-q (META-q) lorsque le curseur est plac dans ce
paragraphe. 

>> Placez le curseur dans le paragraphe prcdent et faites M-q.


* RECHERCHE
-----------

Emacs peut rechercher des chanes de caractres (ce sont des groupes
de caractres contigus ou mots) soit vers l'avant, soit vers
l'arrire. La recherche d'une chane est une commande de dplacement
du curseur : elle dplace le curseur  l'emplacement o la chane
apparat.

La commande de recherche d'Emacs est diffrente de celle que l'on
trouve sur la plupart des diteurs car elle est  incrmentale . Cela
signifie que la recherche a lieu pendant que l'on tape la chane que
l'on recherche.

La commande pour dbuter une recherche est C-s pour rechercher vers
l'avant et C-r pour rechercher vers l'arrire. MAIS ATTENDEZ !
N'essayez pas encore.

Lorsque vous faites C-s la chane  I-search  apparat comme invite
dans la zone d'cho. Cela vous indique qu'Emacs est dans ce que l'on
appelle une recherche incrmentale et qu'il attend que vous tapiez ce
que vous recherchez. <Entre> termine une recherche.

>> Faites C-s pour lancer une recherche. LENTEMENT, une lettre  la
   fois, tapez le mot  curseur , en attendant entre chaque caractre
   pour constater ce que fait le curseur. Vous avez maintenant atteint
    curseur  une premire fois.
>> Tapez C-s  nouveau pour trouver l'occurrence suivante de  curseur .
>> Faites maintenant <Delback> quatre fois et tudiez les mouvements du
   curseur.
>> Faites <Entre> pour mettre fin  la recherche.

Avez-vous vu ce qui se passait ?  Emacs, dans une recherche
incrmentale, essaie d'aller sur l'occurrence de la chane que vous
avec tape jusqu' cet instant. Pour aller sur l'occurrence suivante de
 curseur , il suffit de refaire C-s : s'il ne trouve rien, Emacs
bippe et vous indique que la recherche a chou. C-g permet galement
de mettre fin  la recherche.

REMARQUE : Sur certains systmes, C-s glera l'cran et vous ne verrez
plus rien se produire dans Emacs.  Cela indique qu'une
fonctionnalit  du systme d'exploitation, appele  contrle de
flux , a intercept le C-s et ne lui permet pas de parvenir 
Emacs. Pour dcoincer l'cran, faites C-q puis consultez la section
Spontaneous Entry to Incremental Search  dans le manuel d'Emacs
pour avoir des avis sur la gestion de cette  fonctionnalit .

Si vous vous trouvez au milieu d'une recherche incrmentale et que
vous tapez <Delback>, vous remarquerez que cela supprime le dernier
caractre de la chane recherche et que la recherche reprend 
l'endroit o elle se trouvait prcdemment. Supposons, par exemple,
que vous ayiez tap  c  pour trouver la premire occurrence de
c. Si vous tapez maintenant  u , le curseur ira sur la premire
occurrence de  cu . Faites <Delback> : cela supprime le  u  de la
chane de recherche et le curseur revient  la premire occurrence de
 c .

Si vous tes au milieu d'une recherche et que vous tapez un caractre
de contrle ou un meta-caractre (sauf quelques exceptions -- les
caractres considrs comme spciaux pour les recherches, tels que C-s
et C-r), cela met fin  la recherche.

C-s lance une recherche de toutes les occurrences de la chane APRS la
position courante du curseur. Si vous voulez faire une recherche plus
haut dans le texte, faites plutt C-r. Tout ce que nous avons dit sur
C-s s'applique galement  C-r, sauf que la direction de la recherche
est inverse.

* FENETRES MULTIPLES
--------------------

L'une des caractristiques les plus agrables d'Emacs est que vous
pouvez afficher plusieurs fentres en mme temps  l'cran.

>> Placez le curseur sur cette ligne et faites C-u 0 C-l (CTRL-L, pas
   CTRL-1).
   
>> Faites maintenant C-x 2 pour diviser l'cran en deux
   fentres. Toutes les deux affichent ce didacticiel et le curseur
   reste dans celle du haut.

>> Faites C-M-v pour faire dfiler la fentre du bas
   (Si vous n'avez pas de touche Meta, faites <ESC>C-V).

>> Tapez C-x o ( o  pour  other ) afin de placer le curseur dans
   la fentre du bas.
>> Utilisez C-v et M-v pour la faire dfiler.
   Conservez ces instructions dans la fentre du haut.

>> Faites  nouveau C-x o pour replacer le curseur dans la fentre du
   haut. Le curseur est exactement o il tait avant.

Vous pouvez continuer  utiliser C-x o pour passer d'une fentre 
l'autre. Chaque fentre a sa propre position du curseur, mais une
seule le montre vraiment. Toutes les commandes d'dition habituelles
s'appliquent  la fentre dans laquelle se trouve le curseur : on
l'appelle la  fentre slectionne .

La commande C-M-v est trs utile lorsque l'on dite du texte dans une
fentre et que l'on utilise l'autre uniquement comme rfrence. Vous
pouvez conserver le curseur dans la fentre o vous ditez et
parcourir l'autre fentre avec C-M-v.

C-M-v est un exemple de caractre CONTROLE-META.  Si vous disposez
d'une touche META, vous pouvez faire C-M-v en pressant  la fois
CONTROLE et META tout en tapant v. Peu importe qui, de CONTROLE ou
META est presse en premier car ces deux touches agissent en modifiant
les caractres que vous tapez.

Si vous n'avez pas de touche META et que vous utilisez <ESC>  la
place, l'ordre a son importance : vous devez taper <ESC> puis C-v car
C-ESC v ne fonctionnera pas. En effet, <ESC> est un caractre en
lui-mme, ce n'est pas un modificateur de touches.

>> Faites C-x 1 (dans la fentre du haut) pour supprimer la fentre du
   bas.

(Si vous aviez fait C-x 1 dans la fentre du bas, vous auriez supprim
celle du haut. Pensez  cette commande comme signifiant  ne garde
qu'une fentre, celle dans laquelle je suis ).

Vous n'tes pas oblig d'afficher le mme tampon dans les deux
fentres. Si vous faites C-x C-f pour trouver un fichier dans une
fentre, l'autre n'est pas modifie. Chaque fentre peut contenir un
fichier indpendamment de l'autre.

Voici une autre faon d'utiliser deux fentres pour afficher deux
choses diffrentes :

>> Faites C-x 4 C-f suivi du nom d'un de vos fichiers puis faites
   <Entre>. Le fichier indiqu apparat dans la fentre du bas et le
   curseur s'y rend galement.

>> Faites C-x o pour revenir  la fentre du haut, puis C-x 1 pour
   supprimer celle du bas.


* NIVEAUX D'DITION RCURSIVE
-----------------------------

Parfois, vous vous trouverez dans ce qui s'appelle un  niveau
d'dition rcursive . Cela est indiqu par des crochets dans la ligne
de mode, entourant les parenthses situes autour du nom du mode
majeur. Vous verrez, par exemple [(Fundamental)] au lieu de (Fundamental).

Pour sortir du niveau d'dition rcursive, faites ESC ESC ESC. C'est
une commande de sortie  tout faire. Vous pouvez galement l'utiliser
pour supprimer les fentres supplmentaires et pour sortir du
mini-tampon.

>> Faites M-x pour aller dans le mini-tampon, puis faites ESC ESC ESC
   pour en sortir.

Vous ne pouvez pas utiliser C-g pour sortir d'un niveau d'dition
rcursive car cette commande sert  annuler des commandes et des
paramtres DANS le niveau d'dition rcursive.

* OBTENIR DE L'AIDE SUPPLMENTAIRE
----------------------------------

Nous avons essay, dans ce didacticiel, de ne fournir que les
informations suffisantes pour commencer  utiliser Emacs. Il y a tant
de possibilits avec Emacs qu'il serait impossible de tout expliquer
ici. Cependant, vous pouvez vouloir en apprendre plus, car il a bien
d'autres fonctionnalits utiles. Emacs dispose de commandes pour lire
la documentation sur ses commandes. Ces commandes d' aide 
commencent toutes par le caractre C-h, le caractre d'aide.

Pour utiliser l'aide, tapez C-h suivi d'un caractre indiquant le type
d'aide que vous souhaitez. Si vous tes VRAIMENT perdu, faites C-h ?
et Emacs vous indiquera les types d'aide qu'il peut fournir. Si vous
avez tap C-h et que vous vous ravisez, il vous suffit de faire C-g
pour annuler.

Certains sites changent la signification du caractre C-h. Ils ne
devraient pas le faire  la lgre pour tous les utilisateurs et vous
tes donc en droit de vous plaindre auprs de l'administrateur
systme. Cependant, si C-h n'affiche pas de message d'aide en bas de
l'cran, essayez  la place la touche F1 ou M-x help <Entre>.

La commande d'aide la plus simple est C-h c.  Faites C-h, le caractre
c, puis un caractre ou une squence de commande : Emacs affichera une
description trs courte de cette commande.

>> Faites C-h c C-p.
  Le message devrait tre quelque chose comme :

	C-p runs the command previous-line

Cela vous donne le  nom de la fonction . Les noms de fonction
servent principalement  la personnalisation et  l'extension d'Emacs,
mais comme ils sont choisis de faon  indiquer ce que fait la
commande, ils servent galement de documentation rapide -- c'est
suffisant pour vous rappeler les commandes que vous avez dj
apprises.

Les commandes multi-caractres, comme C-x C-s et (si vous n'avez ni
touche META, ni touche EDIT, ni touche ALT) <ESC>v sont galement
possibles aprs C-h c.

Pour obtenir plus d'informations sur une commande, faites C-h k au
lieu de C-h c.

>> Faites C-h k C-p.

Cela affiche la documentation de la fonction, ainsi que son nom, dans
une fentre Emacs. Lorsque vous avez fini de lire, faites C-x 1 pour
supprimer le texte de l'aide. Vous n'tes pas oblig de le faire tout
de suite ; vous pouvez continuer  travailler tout en vous rfrant 
l'aide, puis taper C-x 1 lorsque vous n'avez plus besoin de celle-ci.

Voici d'autres options utiles de C-h :

   C-h f	Dcrit une fonction. Vous tapez le nom de la fonction.

>> Faites C-h f previous-line<Entre>.
   Cela affiche toutes les informations dont dispose Emacs sur la
   fonction qui implmente la commande C-p.

   C-h a	Commande Apropos.  Tapez un mot-cl et Emacs affichera
		toutes les commandes dont les noms contiennent ce
		mot-cl. Ces commandes peuvent toutes tre invoques
		avec M-x. Pour certaines, la commande Apropos
		affichera galement une squence d'un ou deux
		caractres excutant la mme commande.

>> Faites C-h a file<Entre>.

Cela affiche dans une autre fentre une liste de toutes les commandes
M-x ayant  file  dans leurs noms. Vous verrez des commandes
caractres, comme C-x C-f, apparatre  ct des noms de commandes qui
leur correspondent, comme find-file.

>> Faites C-M-v pour faire dfiler la fentre d'aide. Faites-le
   plusieurs fois.

>> Faites C-x 1 pour supprimer la fentre d'aide.

   C-h i 	Manuels en ligne (alias Info). Cette commande vous place dans
         	un tampon spciale, appel  *info* , o vous pouvez
		lire les manuels en ligne des paquetages installs sur
		votre systme. Faites memacs<Entre> pour lire le
		manuel d'Emacs. Si vous n'avez jamais utilis Info
		auparavant, tapez ? et Emacs vous fera faire une visite 
		guide des fonctionnalits du mode Info. Lorsque vous
		en aurez fini avec ce didacticiel, le manuel Info
		d'Emacs devrait tre votre source de documentation
		essentielle. 


* FONCTIONNALITS SUPPLMENTAIRES
---------------------------------

Vous pouvez en apprendre plus en lisant le manuel d'Emacs, qu'il soit
imprim ou en ligne avec le systme Info (utilisez le menu Help, ou
faites F10 h r). Les deux fonctionnalits que vous apprcierez
particulirement sont la compltion, qui permet d'conomiser la
frappe, et dired, qui simplifie la manipulation des fichiers.

La compltion permet d'viter les frappes inutiles. Si, par exemple,
vous voulez basculer vers le tampon *Messages*, tapez simplement
C-xb*M<Tab> et Emacs compltera le nom du tampon s'il peut le
dterminer  partir de ce que vous avez saisi avant la tabulation. La
compltion est dcrite dans la version Info du manuel Emacs,  la
rubrique "Completion".

Dired vous permet de consulter la liste des fichiers d'un rpertoire
(et, ventuellement, de ses sous-rpertoires), de vous dplacer dans
cette liste, d'ouvrir, de renommer, de supprimer et, de faon
gnrale, de manipuler ces fichiers.  Dired est dcrit dans la version
Info du manuel Emacs,  la rubrique "Dired".

Le manuel dcrit galement les nombreuses autres fonctionnalits
d'Emacs.

* CONCLUSION
------------

Rappelez-vous, pour quitter dfinitivement Emacs, faites C-x C-c. Pour
lancer temporairement un shell et pouvoir ensuite revenir  Emacs,
faites C-z.

Ce didacticiel est destin  tre comprhensible par tous les nouveaux
utilisateurs. Si vous avez trouv que quelque chose n'tait pas clair,
ne restez pas les bras croiss  vous accuser de tous les maux --
plaignez-vous !


* COPIE
---------

Ce didacticiel descend d'une longue ligne de didacticiels Emacs,
dbute par celui qui fut crit par Stuart Cracraft pour le premier
Emacs.

Cette version du didacticiel, comme GNU Emacs, est place sous
copyright, et vous pouvez en distribuer des copies sous certaines
conditions :
 
Copyright (c) 1985, 1996, 2001, 2002 Free Software Foundation

   Chacun peut crer ou distribuer des copies de ce document tel qu'il
   l'a reu, sur n'importe quel support, pourvu que la note de
   copyright et cette note de permission soient prserves et que le
   distributeur garantisse au destinataire la permission d'une
   redistribution ultrieure telle qu'elle est permise par cette note.

   Vous pouvez distribuer des versions modifies de ce document, ou
   de parties modifies de celui-ci sous les conditions cites plus haut,
   pourvu qu'il soit clairement indiqu qui les a modifi pour la
   dernire fois.

Les conditions de copie d'Emacs lui-mme sont plus complexes, mais
dans le mme esprit. Lisez le fichier COPYING et donnez ensuite des
copies de GNU Emacs  vos amis. Participez  l'radication de
l'obstructionnisme du logiciel (sa  propritarisation ) en
utilisant, crivant et partagent des logiciels libres !

Cette traduction franaise a t effectue par ric Jacoboni
<jaco@teaser.fr>.

--- end of TUTORIAL.fr ---

;;; Local Variables:
;;;   coding: latin-1
;;; End:
