require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SPARC_BUS_H_)) {
    eval 'sub _SPARC_BUS_H_ () {1;}' unless defined(&_SPARC_BUS_H_);
    require 'machine/autoconf.ph';
    require 'uvm/uvm_extern.ph';
    require 'machine/pmap.ph';
    eval 'sub TAG_LITTLE_ENDIAN () {0x80000000;}' unless defined(&TAG_LITTLE_ENDIAN);
    eval 'sub SET_TAG_BIG_ENDIAN {
        my($t) = @_;
	    eval q((($t))-> &rr_iospace &= ~ &TAG_LITTLE_ENDIAN);
    }' unless defined(&SET_TAG_BIG_ENDIAN);
    eval 'sub SET_TAG_LITTLE_ENDIAN {
        my($t) = @_;
	    eval q((($t))-> &rr_iospace |=  &TAG_LITTLE_ENDIAN);
    }' unless defined(&SET_TAG_LITTLE_ENDIAN);
    eval 'sub IS_TAG_LITTLE_ENDIAN {
        my($t) = @_;
	    eval q((($t)-> &rr_iospace &  &TAG_LITTLE_ENDIAN));
    }' unless defined(&IS_TAG_LITTLE_ENDIAN);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x4;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub bus_space_read_1 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int8_t *)(($handle) + ($offset))));
    }' unless defined(&bus_space_read_1);
    eval 'sub __bus_space_read_2 {
        my($tag, $handle, $offset) = @_;
	    eval q(*( &volatile  &u_int16_t *)(($handle) + ($offset)));
    }' unless defined(&__bus_space_read_2);
    eval 'sub __bus_space_read_4 {
        my($tag, $handle, $offset) = @_;
	    eval q(*( &volatile  &u_int32_t *)(($handle) + ($offset)));
    }' unless defined(&__bus_space_read_4);
    eval 'sub bus_space_read_2 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &letoh16( &__bus_space_read_2($tag, $handle, $offset)) :  &__bus_space_read_2($tag, $handle, $offset)));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &letoh32( &__bus_space_read_4($tag, $handle, $offset)) :  &__bus_space_read_4($tag, $handle, $offset)));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_write_1 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int8_t *)(($handle) + ($offset)) = ($value)));
    }' unless defined(&bus_space_write_1);
    eval 'sub __bus_space_write_2 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q(*( &volatile  &u_int16_t *)(($handle) + ($offset)) = ($value));
    }' unless defined(&__bus_space_write_2);
    eval 'sub __bus_space_write_4 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q(*( &volatile  &u_int32_t *)(($handle) + ($offset)) = ($value));
    }' unless defined(&__bus_space_write_4);
    eval 'sub bus_space_write_2 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q( &__bus_space_write_2($tag, $handle, $offset, ( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &htole16($value) : ($value)));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q( &__bus_space_write_4($tag, $handle, $offset, ( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &htole32($value) : ($value)));
    }' unless defined(&bus_space_write_4);
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_STREAMING () {0x8;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_READ () {0x100;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x200;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMA_NOCACHE () {0x400;}' unless defined(&BUS_DMA_NOCACHE);
    eval 'sub BUS_DMA_ZERO () {0x800;}' unless defined(&BUS_DMA_ZERO);
    eval 'sub BUS_DMA_24BIT () { &BUS_DMA_BUS1;}' unless defined(&BUS_DMA_24BIT);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub bus_dmamap_create {
        my($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        my($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        my($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        my($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        my($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        my($t, $p, $o, $l, $ops) = @_;
	    eval q(( &void)(($t)-> &_dmamap_sync ? (*($t)-> &_dmamap_sync)(($t), ($p), ($o), ($l), ($ops)) : ( &void)0));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        my($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        my($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        my($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        my($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        my($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    eval 'sub bus_dmatag_subregion {
        my($t, $mna, $mxa, $nt, $f) = @_;
	    eval q( &EOPNOTSUPP);
    }' unless defined(&bus_dmatag_subregion);
    eval 'sub bus_dmatag_destroy {
        my($t) = @_;
	    eval q();
    }' unless defined(&bus_dmatag_destroy);
}
1;
