require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M68K_PARAM_H_)) {
    eval 'sub _M68K_PARAM_H_ () {1;}' unless defined(&_M68K_PARAM_H_);
    eval 'sub _MACHINE_ARCH () { &m68k;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"m68k";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_M68K;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {($sizeof{\'int\'} - 1);}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t} - 1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub NPTEPG () {( &PAGE_SIZE / ($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    eval 'sub BTOPKERNBASE () {( &KERNBASE >>  &PAGE_SHIFT);}' unless defined(&BTOPKERNBASE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub SEGSHIFT020 () {(34-  &PAGE_SHIFT);}' unless defined(&SEGSHIFT020);
    eval 'sub SEGSHIFT040 () {(18);}' unless defined(&SEGSHIFT040);
    unless(defined(&SEGSHIFT)) {
	if(defined(&M68040) || defined(&M68060)) {
	    if(defined(&M68020) || defined(&M68030)) {
		eval 'sub SEGSHIFT () {(( &mmutype <=  &MMU_68040) ?  &SEGSHIFT040 :  &SEGSHIFT020);}' unless defined(&SEGSHIFT);
	    } else {
		eval 'sub SEGSHIFT () { &SEGSHIFT040;}' unless defined(&SEGSHIFT);
	    }
	} else {
	    eval 'sub SEGSHIFT () { &SEGSHIFT020;}' unless defined(&SEGSHIFT);
	}
	eval 'sub NBSEG () {(1<<  &SEGSHIFT);}' unless defined(&NBSEG);
	eval 'sub SEGOFSET () {( &NBSEG - 1);}' unless defined(&SEGOFSET);
    }
    unless(defined(&UPAGES)) {
	eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    }
    eval 'sub USPACE () {( &UPAGES *  &PAGE_SIZE);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PAGE_SHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PAGE_SHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub m68k_round_seg {
        my($x) = @_;
	    eval q((((($x)) +  &SEGOFSET) & ~ &SEGOFSET));
    }' unless defined(&m68k_round_seg);
    eval 'sub m68k_trunc_seg {
        my($x) = @_;
	    eval q((($x) & ~ &SEGOFSET));
    }' unless defined(&m68k_trunc_seg);
    eval 'sub m68k_page_offset {
        my($x) = @_;
	    eval q((($x) &  &PGOFSET));
    }' unless defined(&m68k_page_offset);
    require 'machine/cpu.ph';
}
1;
