/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.installers;

import com.darwinsys.io.FileIO;
import com.darwinsys.swingui.UtilGUI;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class InstallerUnpacker
implements Runnable {
    static final int BLOCK_SIZE = 8092;
    public static final String REQUIRED_NAME = "installer.jar";
    JFrame jf;
    JLabel status;
    JProgressBar progress;
    protected SortedSet<String> dirsMade = new TreeSet<String>();
    private boolean warnedMkDir;
    private String fileName;

    public static void main(String[] args) {
        System.out.println("InstallerUnpacker.main()");
        InstallerUnpacker installerUnpacker = new InstallerUnpacker(REQUIRED_NAME);
        installerUnpacker.run();
    }

    InstallerUnpacker(String fileName) {
        this.fileName = fileName;
        this.jf = new JFrame("Setup");
        this.jf.setDefaultCloseOperation(3);
        JLabel infoLabel = new JLabel("Setup is unpacking the installer. Please wait...", 0);
        infoLabel.setPreferredSize(new Dimension(400, 100));
        this.jf.add((Component)infoLabel, "North");
        this.status = new JLabel("", 0);
        this.jf.add((Component)this.status, "Center");
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(true);
        this.jf.add((Component)this.progress, "South");
        this.jf.setSize(500, 250);
        UtilGUI.center(this.jf);
        this.jf.setVisible(true);
    }

    public void run() {
        File tmpDir = null;
        try {
            try {
                tmpDir = File.createTempFile("darwinstaller", ".tmp");
                tmpDir.delete();
                tmpDir.mkdir();
                File f = new File(this.fileName);
                if (!f.exists() || !f.canRead()) {
                    throw new IOException("Can't read installer file " + this.fileName);
                }
                System.out.println("Starting on " + this.fileName + " created " + new Date(f.lastModified()));
                JarFile jarFile = new JarFile(f);
                Manifest m = jarFile.getManifest();
                if (m == null) {
                    throw new IOException(String.valueOf(this.fileName) + " file has no Manifest!");
                }
                Attributes installerClassAttributes = m.getMainAttributes();
                String installerClassName = null;
                if (installerClassAttributes == null) {
                    System.err.println("warning: no attributes");
                } else {
                    installerClassName = installerClassAttributes.getValue("Installer-class");
                    System.out.println("Installer class name is " + installerClassName);
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    File d;
                    String dirName;
                    int ix;
                    JarEntry entry = entries.nextElement();
                    String thisEntryName = entry.getName();
                    if (thisEntryName.startsWith("META-INF") || thisEntryName.startsWith("MANIFEST")) {
                        System.out.println("Ignoring " + thisEntryName);
                        continue;
                    }
                    if (thisEntryName.startsWith(this.getClass().getName())) {
                        System.out.println("Ignoring " + thisEntryName);
                        continue;
                    }
                    if (thisEntryName.endsWith("/")) continue;
                    String message = "Processing " + thisEntryName;
                    Thread.sleep(50L);
                    this.status.setText(message);
                    if (thisEntryName.startsWith("/")) {
                        if (!this.warnedMkDir) {
                            System.out.println("Ignoring absolute path in " + thisEntryName);
                        }
                        this.warnedMkDir = true;
                        thisEntryName = thisEntryName.substring(1);
                    }
                    if (!((ix = thisEntryName.lastIndexOf(47)) <= 0 || this.dirsMade.contains(dirName = thisEntryName.substring(0, ix)) || (d = new File(tmpDir, dirName)).exists() && d.isDirectory())) {
                        System.out.println("Creating Directory: " + dirName);
                        if (!d.mkdirs()) {
                            System.err.println("Warning: unable to mkdir " + dirName);
                        }
                        this.dirsMade.add(dirName);
                    }
                    System.out.println("Creating " + thisEntryName);
                    InputStream is = jarFile.getInputStream(entry);
                    FileOutputStream os = new FileOutputStream(new File(tmpDir, thisEntryName));
                    byte[] b = new byte[8092];
                    int n = 0;
                    while ((n = is.read(b)) > 0) {
                        os.write(b, 0, n);
                    }
                    is.close();
                    os.close();
                }
                this.progress.setIndeterminate(false);
                this.progress.setValue(100);
                this.status.setText("Unpacking completed.");
                String[] argv = new String[]{String.valueOf(System.getProperty("java.home")) + "/bin/java", installerClassName, "-l", tmpDir + "/" + "darwinstall.log"};
                Process p = Runtime.getRuntime().exec(argv, null, tmpDir);
                this.status.setText("Starting the installer...");
                Thread.sleep(8000L);
                this.jf.setVisible(false);
                this.jf.dispose();
                this.jf = null;
                p.waitFor();
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this.jf, "Error unpacking/starting installer:\n" + e, "Error", 0);
                e.printStackTrace();
                System.exit(1);
            }
        }
        finally {
            try {
                FileIO.deleteRecursively(tmpDir);
            }
            catch (IOException e) {
                System.err.println("Part of tmp dir cleanup failed:\n" + e);
            }
            System.exit(0);
        }
    }
}

