/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectConnectionFactory;
import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDatabase
extends SQLObject
implements Serializable,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger(SQLDatabase.class);
    private ArchitectDataSource dataSource;
    private transient BaseObjectPool connectionPool;
    private boolean playPenDatabase = false;
    private PopulateProgressMonitor progressMonitor;

    public SQLDatabase(ArchitectDataSource dataSource) {
        this.setDataSource(dataSource);
        this.children = new ArrayList();
    }

    public SQLDatabase() {
        this.children = new ArrayList();
        this.populated = true;
    }

    public synchronized boolean isConnected() {
        return this.connectionPool != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void populate() throws ArchitectException {
        ResultSet rs;
        Connection con;
        block21: {
            int newSize2;
            if (this.populated) {
                return;
            }
            int oldSize = this.children.size();
            logger.debug((Object)"SQLDatabase: populate starting");
            con = null;
            rs = null;
            try {
                try {
                    con = this.getConnection();
                    DatabaseMetaData dbmd = con.getMetaData();
                    rs = dbmd.getCatalogs();
                    while (rs.next()) {
                        String catName = rs.getString(1);
                        SQLCatalog cat = null;
                        if (catName == null) continue;
                        cat = new SQLCatalog(this, catName);
                        cat.setNativeTerm(dbmd.getCatalogTerm());
                        logger.debug((Object)("Set catalog term to " + cat.getNativeTerm()));
                        this.children.add(cat);
                    }
                    rs.close();
                    rs = null;
                    if (this.children.size() == oldSize) {
                        rs = dbmd.getSchemas();
                        while (rs.next()) {
                            this.children.add(new SQLSchema(this, rs.getString(1), false));
                        }
                        rs.close();
                        rs = null;
                    }
                    if (this.children.size() == oldSize) {
                        SQLTable.addTablesToTableContainer(this, dbmd, "", "");
                    }
                }
                catch (SQLException e) {
                    throw new ArchitectException("database.populate.fail", e);
                }
                Object var8_8 = null;
                this.populated = true;
                newSize2 = this.children.size();
                if (newSize2 <= oldSize) break block21;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.populated = true;
                int newSize2 = this.children.size();
                if (newSize2 > oldSize) {
                    int[] changedIndices = new int[newSize2 - oldSize];
                    int n = newSize2 - oldSize;
                    for (int i = 0; i < n; ++i) {
                        changedIndices[i] = oldSize + i;
                    }
                    this.fireDbChildrenInserted(changedIndices, this.children.subList(oldSize, newSize2));
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    throw new ArchitectException("database.rs.close.fail", e2);
                }
                try {
                    if (con == null) throw throwable;
                    con.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new ArchitectException("Couldn't close connection", e2);
                }
            }
            int[] changedIndices = new int[newSize2 - oldSize];
            int n = newSize2 - oldSize;
            for (int i = 0; i < n; ++i) {
                changedIndices[i] = oldSize + i;
            }
            this.fireDbChildrenInserted(changedIndices, this.children.subList(oldSize, newSize2));
        }
        try {}
        catch (SQLException e2) {
            throw new ArchitectException("database.rs.close.fail", e2);
        }
        if (rs != null) {
            rs.close();
        }
        try {}
        catch (SQLException e2) {
            throw new ArchitectException("Couldn't close connection", e2);
        }
        if (con != null) {
            con.close();
        }
        logger.debug((Object)"SQLDatabase: populate finished");
    }

    public SQLCatalog getCatalogByName(String catalogName) throws ArchitectException {
        this.populate();
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        if (!(this.children.get(0) instanceof SQLCatalog)) {
            return null;
        }
        for (SQLCatalog child : this.children) {
            if (!child.getName().equalsIgnoreCase(catalogName)) continue;
            return child;
        }
        return null;
    }

    public SQLSchema getSchemaByName(String schemaName) throws ArchitectException {
        this.populate();
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        if (!(this.children.get(0) instanceof SQLSchema) && !(this.children.get(0) instanceof SQLCatalog)) {
            return null;
        }
        for (SQLObject child : this.children) {
            if (child instanceof SQLCatalog) {
                SQLSchema schema = ((SQLCatalog)child).getSchemaByName(schemaName);
                if (schema == null) continue;
                return schema;
            }
            if (child instanceof SQLSchema) {
                boolean bl = child.getName() == null ? schemaName == null : child.getName().equalsIgnoreCase(schemaName);
                boolean match = bl;
                if (!match) continue;
                return (SQLSchema)child;
            }
            throw new IllegalStateException("Database contains a mix of schemas or catalogs with other objects");
        }
        return null;
    }

    public SQLTable getTableByName(String tableName) throws ArchitectException {
        return this.getTableByName(null, null, tableName);
    }

    public SQLTable getTableByName(String catalogName, String schemaName, String tableName) throws ArchitectException {
        this.populate();
        if (tableName == null || tableName.length() == 0) {
            throw new NullPointerException("Table Name must be specified");
        }
        SQLObject target = this;
        if (catalogName != null && catalogName.length() > 0) {
            target = this.getCatalogByName(catalogName);
        }
        if (target == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getTableByName(" + catalogName + "," + schemaName + "," + tableName + "): no such catalog!"));
            }
            return null;
        }
        if (schemaName != null && schemaName.length() > 0) {
            if (target instanceof SQLDatabase) {
                target = ((SQLDatabase)target).getSchemaByName(schemaName);
            } else if (target instanceof SQLCatalog) {
                target = ((SQLCatalog)target).getSchemaByName(schemaName);
            } else {
                throw new IllegalStateException("Oops, somebody forgot to update this!");
            }
        }
        if (target == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getTableByName(" + catalogName + "," + schemaName + "," + tableName + "): no such schema!"));
            }
            return null;
        }
        target.populate();
        for (SQLObject child : target.children) {
            SQLTable table;
            if (!(child instanceof SQLTable ? (table = (SQLTable)child).getName().equalsIgnoreCase(tableName) : (child instanceof SQLCatalog ? (table = ((SQLCatalog)child).getTableByName(tableName)) != null : child instanceof SQLSchema && (table = ((SQLSchema)child).getTableByName(tableName)) != null))) continue;
            return table;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getTableByName(" + catalogName + "," + schemaName + "," + tableName + "): catalog and schema ok; no such table!"));
        }
        return null;
    }

    @Override
    public SQLObject getParent() {
        return null;
    }

    @Override
    protected void setParent(SQLObject newParent) {
    }

    @Override
    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getDisplayName();
        }
        return "PlayPen Database";
    }

    @Override
    public void setName(String argName) {
        if (this.dataSource != null) {
            this.dataSource.setName(argName);
        }
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    public boolean isCatalogContainer() throws ArchitectException {
        if (this.getParent() != null) {
            this.populate();
        }
        if (this.children.size() == 0) {
            return true;
        }
        return this.children.get(0) instanceof SQLCatalog;
    }

    public boolean isSchemaContainer() throws ArchitectException {
        if (this.getParent() != null) {
            this.populate();
        }
        if (this.children.size() == 0) {
            return true;
        }
        return this.children.get(0) instanceof SQLSchema;
    }

    public List getTables() throws ArchitectException {
        return SQLDatabase.getTableDescendants(this);
    }

    private static List getTableDescendants(SQLObject o) throws ArchitectException {
        if (!o.allowsChildren()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SQLObject> tables = new LinkedList<SQLObject>();
        for (SQLObject c : o.getChildren()) {
            if (c instanceof SQLTable) {
                tables.add(c);
                continue;
            }
            tables.addAll(SQLDatabase.getTableDescendants(c));
        }
        return tables;
    }

    public ArchitectDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ArchitectDataSource argDataSource) {
        ArchitectDataSource oldDataSource = this.dataSource;
        if (this.dataSource != null) {
            this.dataSource.removePropertyChangeListener(this);
            this.reset();
        }
        this.dataSource = argDataSource;
        this.dataSource.addPropertyChangeListener(this);
        this.fireDbObjectChanged("dataSource", oldDataSource, argDataSource);
    }

    public void setPlayPenDatabase(boolean v) {
        boolean oldValue = this.playPenDatabase;
        this.playPenDatabase = v;
        if (oldValue != v) {
            this.fireDbObjectChanged("playPenDatabase", oldValue, v);
        }
    }

    public boolean isPlayPenDatabase() {
        return this.playPenDatabase;
    }

    protected synchronized void reset() {
        if (this.playPenDatabase) {
            logger.debug((Object)("Ignoring Reset request for: " + this.getDataSource()));
            this.populated = true;
        } else {
            logger.debug((Object)("Resetting: " + this.getDataSource()));
            List old = this.children;
            if (old != null && old.size() > 0) {
                int[] oldIndices = new int[old.size()];
                int n = old.size();
                for (int i = 0; i < n; ++i) {
                    oldIndices[i] = i;
                }
                this.fireDbChildrenRemoved(oldIndices, old);
            }
            this.children = new ArrayList();
            this.populated = false;
        }
        if (this.connectionPool != null) {
            try {
                this.connectionPool.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.connectionPool = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pn = e.getPropertyName();
        if (e.getOldValue() == null && e.getNewValue() != null || e.getOldValue() != null && e.getNewValue() == null || e.getOldValue() != null && e.getNewValue() != null && !e.getOldValue().equals(e.getNewValue())) {
            if ("url".equals(pn) || "driverClass".equals(pn) || "user".equals(pn)) {
                this.reset();
            } else if ("name".equals(pn)) {
                this.fireDbObjectChanged("shortDisplayName", e.getOldValue(), e.getNewValue());
            }
        }
    }

    public Connection getConnection() throws ArchitectException {
        if (this.dataSource == null) {
            return null;
        }
        try {
            return (Connection)this.getConnectionPool().borrowObject();
        }
        catch (Exception e) {
            throw new ArchitectException("Couldn't connect to database: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public synchronized PopulateProgressMonitor getProgressMonitor() throws ArchitectException {
        if (this.progressMonitor == null) {
            this.progressMonitor = new PopulateProgressMonitor();
        }
        return this.progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            if (this.connectionPool != null) {
                this.connectionPool.close();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error closing connection pool", (Throwable)ex);
        }
        finally {
            this.connectionPool = null;
        }
    }

    synchronized BaseObjectPool getConnectionPool() {
        if (this.connectionPool == null) {
            GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
            poolConfig.maxActive = 5;
            poolConfig.whenExhaustedAction = 0;
            this.connectionPool = new GenericObjectPool(null, poolConfig);
            ArchitectConnectionFactory cf = new ArchitectConnectionFactory(this.dataSource);
            new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)this.connectionPool, null, null, false, true);
        }
        return this.connectionPool;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        if (this.children.size() == 0) {
            return null;
        }
        return ((SQLObject)this.children.get(0)).getClass();
    }

    public class PopulateProgressMonitor {
        public Integer getJobSize() throws ArchitectException {
            return null;
        }

        public int getProgress() {
            return 0;
        }

        public boolean isFinished() {
            return SQLDatabase.this.isPopulated();
        }
    }
}

