/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.qfa;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.qfa.QFAUserSettings;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class ExceptionReport {
    private static final int MAX_REPORT_TRIES = 10;
    private static final Logger logger = Logger.getLogger(ExceptionReport.class);
    private Throwable exception;
    private String reportUrlSysProp;
    private String reportUrl;
    private String architectVersion;
    private long applicationUptime;
    private long totalMem = Runtime.getRuntime().totalMemory();
    private long freeMem = Runtime.getRuntime().freeMemory();
    private long maxMem = Runtime.getRuntime().maxMemory();
    private String jvmVendor = System.getProperty("java.vendor");
    private String jvmVersion = System.getProperty("java.version");
    private String osArch = System.getProperty("os.arch");
    private String osName = System.getProperty("os.name");
    private String osVersion = System.getProperty("os.version");
    private int numSourceConnections;
    private int numObjectsInPlayPen;
    private String userActivityDescription;
    private String remarks;
    static int numReportsThisRun = 0;

    private ExceptionReport() {
    }

    public ExceptionReport(Throwable exception, String reportUrlSysProp, String reportUrl, String architectVersion, long applicationUptime) {
        this();
        this.exception = exception;
        this.reportUrlSysProp = reportUrlSysProp;
        this.reportUrl = reportUrl;
        this.architectVersion = architectVersion;
        this.applicationUptime = applicationUptime;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        xml.append("\n<architect-exception-report version=\"1.0\">");
        this.appendNestedExceptions(xml, this.exception);
        xml.append("\n <architect-version>").append(ArchitectUtils.escapeXML(this.architectVersion)).append("</architect-version>");
        xml.append("\n <architect-uptime>").append(this.applicationUptime).append("</architect-uptime>");
        xml.append("\n <total-mem>").append(this.totalMem).append("</total-mem>");
        xml.append("\n <free-mem>").append(this.freeMem).append("</free-mem>");
        xml.append("\n <max-mem>").append(this.maxMem).append("</max-mem>");
        xml.append("\n <jvm vendor=\"").append(ArchitectUtils.escapeXML(this.jvmVendor)).append("\" version=\"").append(ArchitectUtils.escapeXML(this.jvmVersion)).append("\" />");
        xml.append("\n <os arch=\"").append(ArchitectUtils.escapeXML(this.osArch)).append("\" name=\"").append(ArchitectUtils.escapeXML(this.osName)).append("\" version=\"").append(ArchitectUtils.escapeXML(this.osVersion)).append("\" />");
        xml.append("\n <num-source-connections>").append(this.numSourceConnections).append("</num-source-connections>");
        xml.append("\n <num-objects-in-playpen>").append(this.numObjectsInPlayPen).append("</num-objects-in-playpen>");
        xml.append("\n <user-activity-description>").append(ArchitectUtils.escapeXML(this.userActivityDescription)).append("</user-activity-description>");
        xml.append("\n <remarks>").append(ArchitectUtils.escapeXML(this.remarks)).append("</remarks>");
        xml.append("\n</architect-exception-report>");
        xml.append("\n");
        return xml.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Exception Report: ");
        sb.append(this.exception);
        sb.append(" ");
        sb.append(this.remarks);
        return sb.toString();
    }

    private void appendNestedExceptions(StringBuffer xml, Throwable exception) {
        if (exception == null) {
            return;
        }
        xml.append("\n <exception class=\"").append(ArchitectUtils.escapeXML(exception.getClass().getName())).append("\" message=\"").append(ArchitectUtils.escapeXML(exception.getMessage())).append("\">");
        for (StackTraceElement ste : exception.getStackTrace()) {
            xml.append("\n  <trace-element class=\"").append(ArchitectUtils.escapeXML(ste.getClassName())).append("\" method=\"").append(ArchitectUtils.escapeXML(ste.getMethodName())).append("\" file=\"").append(ArchitectUtils.escapeXML(ste.getFileName())).append("\" line=\"").append(ste.getLineNumber()).append("\" />");
        }
        this.appendNestedExceptions(xml, exception.getCause());
        xml.append("\n </exception>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postReport() {
        QFAUserSettings settings;
        logger.debug((Object)("posting report: " + this.toString()));
        if (numReportsThisRun++ > 10) {
            logger.info((Object)String.format("Not logging this error, threshold of %d exceeded", 10));
            return;
        }
        this.exception.printStackTrace();
        String url = System.getProperty(this.reportUrlSysProp);
        if (url == null) {
            url = this.reportUrl;
        }
        if (!(settings = ArchitectFrame.getMainInstance().getUserSettings().getQfaUserSettings()).getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true)) {
            return;
        }
        logger.info((Object)("Posting error report to SQL Power at URL <" + url + ">"));
        try {
            String line;
            HttpURLConnection dest = (HttpURLConnection)new URL(url).openConnection();
            dest.setConnectTimeout(3000);
            dest.setReadTimeout(3000);
            dest.setDoOutput(true);
            dest.setDoInput(true);
            dest.setUseCaches(false);
            dest.setRequestMethod("POST");
            dest.setRequestProperty("Content-Type", "text/xml");
            dest.connect();
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(dest.getOutputStream());
                ((OutputStream)out).write(this.toXML().getBytes("ISO-8859-1"));
                ((OutputStream)out).flush();
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            InputStreamReader inputStreamReader = new InputStreamReader(dest.getInputStream());
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer response = new StringBuffer();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            logger.info((Object)("Error report servlet response: " + response));
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't send exception report to <\"" + url + "\">"), (Throwable)e);
        }
        logger.debug((Object)"Finished posting report");
    }

    public long getApplicationUptime() {
        return this.applicationUptime;
    }

    public void setApplicationUptime(long applicationUptime) {
        this.applicationUptime = applicationUptime;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public void setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public int getNumObjectsInPlayPen() {
        return this.numObjectsInPlayPen;
    }

    public void setNumObjectsInPlayPen(int numObjectsInPlayPen) {
        this.numObjectsInPlayPen = numObjectsInPlayPen;
    }

    public int getNumSourceConnections() {
        return this.numSourceConnections;
    }

    public void setNumSourceConnections(int numSourceConnections) {
        this.numSourceConnections = numSourceConnections;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getUserActivityDescription() {
        return this.userActivityDescription;
    }

    public void setUserActivityDescription(String userActivityDescription) {
        this.userActivityDescription = userActivityDescription;
    }

    public String getArchitectVersion() {
        return this.architectVersion;
    }

    public void setArchitectVersion(String architectVersion) {
        this.architectVersion = architectVersion;
    }

    public void setRemarks(String v) {
        this.remarks = v;
    }

    public String getRemarks() {
        return this.remarks;
    }
}

