/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.SQLType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnEditPanel
extends JPanel
implements ActionListener,
ArchitectPanel {
    private static final Logger logger = Logger.getLogger(ColumnEditPanel.class);
    private SQLColumn column;
    private JLabel sourceDB;
    private JLabel sourceTableCol;
    private JTextField colName;
    private JComboBox colType;
    private JSpinner colScale;
    private JSpinner colPrec;
    private JCheckBox colNullable;
    private JTextField colRemarks;
    private JTextField colDefaultValue;
    private JCheckBox colInPK;
    private JCheckBox colAutoInc;

    public ColumnEditPanel(SQLColumn col) throws ArchitectException {
        super(new BorderLayout(12, 12));
        logger.debug((Object)"ColumnEditPanel called");
        this.buildUI();
        this.editColumn(col);
    }

    private void buildUI() {
        JPanel centerBox = new JPanel();
        centerBox.setLayout(new BoxLayout(centerBox, 1));
        centerBox.add(Box.createVerticalGlue());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new FormLayout(5, 5));
        centerPanel.setBorder(BorderFactory.createTitledBorder("Column Properties"));
        centerPanel.add(new JLabel("Source Database"));
        this.sourceDB = new JLabel();
        centerPanel.add(this.sourceDB);
        centerPanel.add(new JLabel("Source Table.Column"));
        this.sourceTableCol = new JLabel();
        centerPanel.add(this.sourceTableCol);
        centerPanel.add(new JLabel("Name"));
        this.colName = new JTextField();
        centerPanel.add(this.colName);
        centerPanel.add(new JLabel("Type"));
        this.colType = this.createColTypeEditor();
        centerPanel.add(this.colType);
        this.colType.addActionListener(this);
        centerPanel.add(new JLabel("Precision"));
        this.colPrec = this.createPrecisionEditor();
        centerPanel.add(this.colPrec);
        centerPanel.add(new JLabel("Scale"));
        this.colScale = this.createScaleEditor();
        centerPanel.add(this.colScale);
        centerPanel.add(new JLabel("In Primary Key"));
        this.colInPK = new JCheckBox();
        centerPanel.add(this.colInPK);
        this.colInPK.addActionListener(this);
        centerPanel.add(new JLabel("Allows Nulls"));
        this.colNullable = new JCheckBox();
        centerPanel.add(this.colNullable);
        this.colNullable.addActionListener(this);
        centerPanel.add(new JLabel("Auto Increment"));
        this.colAutoInc = new JCheckBox();
        centerPanel.add(this.colAutoInc);
        this.colAutoInc.addActionListener(this);
        centerPanel.add(new JLabel("Remarks"));
        this.colRemarks = new JTextField();
        centerPanel.add(this.colRemarks);
        centerPanel.add(new JLabel("Default Value"));
        this.colDefaultValue = new JTextField();
        centerPanel.add(this.colDefaultValue);
        this.colDefaultValue.addActionListener(this);
        Dimension maxSize = centerPanel.getLayout().preferredLayoutSize(centerPanel);
        maxSize.width = Integer.MAX_VALUE;
        centerPanel.setMaximumSize(maxSize);
        centerBox.add(centerPanel);
        centerBox.add(Box.createVerticalGlue());
        this.add((Component)centerBox, "Center");
    }

    private JSpinner createScaleEditor() {
        return new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    }

    private JSpinner createPrecisionEditor() {
        return this.createScaleEditor();
    }

    private JComboBox createColTypeEditor() {
        return new JComboBox<SQLType>(SQLType.getTypes());
    }

    public void editColumn(SQLColumn col) throws ArchitectException {
        logger.debug((Object)("Edit Column '" + col + "' is being called"));
        if (col == null) {
            throw new NullPointerException("Edit null column is not allowed");
        }
        this.column = col;
        if (col.getSourceColumn() == null) {
            this.sourceDB.setText("None Specified");
            this.sourceTableCol.setText("None Specified");
        } else {
            StringBuffer sourceDBSchema = new StringBuffer();
            for (SQLObject so = col.getSourceColumn().getParentTable().getParent(); so != null; so = so.getParent()) {
                sourceDBSchema.insert(0, so.getName());
                sourceDBSchema.insert(0, ".");
            }
            this.sourceDB.setText(sourceDBSchema.toString().substring(1));
            this.sourceTableCol.setText(col.getSourceColumn().getParentTable().getName() + "." + col.getSourceColumn().getName());
        }
        this.colName.setText(col.getName());
        this.colType.setSelectedItem(SQLType.getType(col.getType()));
        this.colScale.setValue(new Integer(col.getScale()));
        this.colPrec.setValue(new Integer(col.getPrecision()));
        this.colNullable.setSelected(col.getNullable() == 1);
        this.colRemarks.setText(col.getRemarks());
        this.colDefaultValue.setText(col.getDefaultValue());
        this.colInPK.setSelected(col.getPrimaryKeySeq() != null);
        this.colAutoInc.setSelected(col.isAutoIncrement());
        this.updateComponents();
        this.colName.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("action event " + e));
        this.updateComponents();
    }

    public void stateChanged(ChangeEvent e) {
        logger.debug((Object)("State change event " + e));
    }

    private void updateComponents() {
        if (this.colInPK.isSelected() || this.colAutoInc.isSelected()) {
            this.colNullable.setEnabled(false);
        } else {
            this.colNullable.setEnabled(true);
        }
        if (this.colNullable.isSelected() && !this.colAutoInc.isSelected()) {
            this.colInPK.setEnabled(false);
        } else {
            this.colInPK.setEnabled(true);
        }
        if (this.colAutoInc.isSelected() || this.colInPK.isSelected() && this.column.getParentTable() != null && this.column.getParentTable().getPkSize() == 1) {
            this.colDefaultValue.setEnabled(false);
            this.colDefaultValue.setText(null);
        } else {
            this.colDefaultValue.setEnabled(true);
        }
        if (this.colDefaultValue.getText() != null && this.colDefaultValue.getText().length() > 0 || !this.colNullable.isSelected() || this.colInPK.isSelected() && this.colNullable.isSelected()) {
            this.colAutoInc.setEnabled(false);
        } else {
            this.colAutoInc.setEnabled(true);
        }
        if (this.colAutoInc.isSelected()) {
            this.colNullable.setSelected(true);
        }
        if (this.colInPK.isSelected() && !this.colNullable.isSelected()) {
            this.colAutoInc.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> updateModel() {
        logger.debug((Object)"Updating model");
        ArrayList<String> errors = new ArrayList<String>();
        try {
            this.column.startCompoundEdit("Column Edit Panel Changes");
            if (this.colName.getText().trim().length() == 0) {
                errors.add("Column name is required");
            } else {
                this.column.setName(this.colName.getText());
            }
            this.column.setType(((SQLType)this.colType.getSelectedItem()).type);
            this.column.setScale((Integer)this.colScale.getValue());
            this.column.setPrecision((Integer)this.colPrec.getValue());
            this.column.setNullable(this.colNullable.isSelected() ? 1 : 0);
            this.column.setRemarks(this.colRemarks.getText());
            if (this.column.getDefaultValue() != null || !this.colDefaultValue.getText().equals("")) {
                this.column.setDefaultValue(this.colDefaultValue.getText());
            }
            this.column.setAutoIncrement(this.colAutoInc.isSelected());
            if (this.column.getPrimaryKeySeq() == null) {
                this.column.setPrimaryKeySeq(this.colInPK.isSelected() ? new Integer(this.column.getParentTable().getPkSize()) : null);
            } else {
                this.column.setPrimaryKeySeq(this.colInPK.isSelected() ? new Integer(this.column.getPrimaryKeySeq()) : null);
            }
        }
        finally {
            this.column.endCompoundEdit("Column Edit Panel Changes");
        }
        return errors;
    }

    @Override
    public boolean applyChanges() {
        List<String> errors = this.updateModel();
        if (!errors.isEmpty()) {
            JOptionPane.showMessageDialog(this, errors.toString());
            return false;
        }
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public JCheckBox getColAutoInc() {
        return this.colAutoInc;
    }

    public JTextField getColDefaultValue() {
        return this.colDefaultValue;
    }

    public JCheckBox getColInPK() {
        return this.colInPK;
    }

    public JTextField getColName() {
        return this.colName;
    }

    public JCheckBox getColNullable() {
        return this.colNullable;
    }

    public JSpinner getColPrec() {
        return this.colPrec;
    }

    public JTextField getColRemarks() {
        return this.colRemarks;
    }

    public JSpinner getColScale() {
        return this.colScale;
    }

    public JComboBox getColType() {
        return this.colType;
    }

    public JLabel getSourceDB() {
        return this.sourceDB;
    }

    public JLabel getSourceTableCol() {
        return this.sourceTableCol;
    }
}

