/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.Monitorable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.event.TaskTerminationEvent;
import ca.sqlpower.architect.swingui.event.TaskTerminationListener;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProgressAction
extends AbstractAction {
    public ProgressAction() {
    }

    public ProgressAction(String name, Icon icon) {
        super(name, icon);
    }

    public ProgressAction(String name) {
        super(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        final JDialog progressDialog = new JDialog(ArchitectFrame.getMainInstance(), "Progress...", false);
        progressDialog.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        progressDialog.setTitle(this.getDialogMessage());
        PanelBuilder pb = new PanelBuilder(new FormLayout("4dlu,fill:min(100dlu;default):grow, pref, fill:min(100dlu;default):grow,4dlu", "4dlu,pref,4dlu, pref, 6dlu, pref,4dlu"));
        JLabel label = new JLabel(this.getDialogMessage());
        JProgressBar progressBar = new JProgressBar();
        final ActionMonitor monitor = new ActionMonitor();
        this.setup(monitor, properties);
        CellConstraints c = new CellConstraints();
        pb.add((Component)label, c.xyw(2, 2, 3));
        pb.add((Component)progressBar, c.xyw(2, 4, 3));
        pb.add((Component)new JButton(new AbstractAction(this.getButtonText()){

            public void actionPerformed(ActionEvent e) {
                progressDialog.dispose();
                monitor.setCancelled(true);
            }
        }), c.xy(3, 6));
        progressDialog.add(pb.getPanel());
        ArchitectSwingWorker worker = new ArchitectSwingWorker(){

            public void cleanup() throws Exception {
                ProgressAction.this.cleanUp(monitor);
                progressDialog.dispose();
            }

            public void doStuff() throws Exception {
                ProgressAction.this.doStuff(monitor, properties);
            }
        };
        ProgressWatcher pw = new ProgressWatcher(progressBar, (Monitorable)monitor);
        pw.addTaskTerminationListener(new TaskTerminationListener(){

            public void taskFinished(TaskTerminationEvent e) {
                progressDialog.dispose();
            }
        });
        progressDialog.pack();
        progressDialog.setVisible(true);
        new Thread(worker).start();
    }

    public abstract String getButtonText();

    public abstract void setup(ActionMonitor var1, Map<String, Object> var2);

    public abstract void doStuff(ActionMonitor var1, Map<String, Object> var2);

    public abstract void cleanUp(ActionMonitor var1);

    public abstract String getDialogMessage();

    public class ActionMonitor
    implements Monitorable {
        Integer jobSize = null;
        String message = "";
        int progress = 0;
        boolean started = false;
        boolean finished = false;
        boolean cancelled = false;

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public boolean hasStarted() throws ArchitectException {
            return this.started;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public Integer getJobSize() {
            return this.jobSize;
        }

        public void setJobSize(Integer jobSize) {
            this.jobSize = jobSize;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public void setStarted(boolean started) {
            this.started = started;
        }
    }
}

