/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.TaskTagPreferencePage;
import org.osgi.service.prefs.Preferences;

class MainTab
implements IPreferenceTab {
    private static final boolean _debugPreferences = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.core/tasks/preferences"));
    private Control fControl;
    private TaskTag[] fOriginalTaskTags;
    private TaskTagPreferencePage fOwner = null;
    private IScopeContext[] fPreferencesLookupOrder = null;
    private IPreferencesService fPreferencesService = null;
    private TaskTag[] fTaskTags;
    private TableViewer valueTable = null;

    public MainTab(TaskTagPreferencePage parent, IPreferencesService preferencesService, IScopeContext[] lookupOrder) {
        this.fOwner = parent;
        this.fPreferencesLookupOrder = lookupOrder;
        this.fPreferencesService = preferencesService;
    }

    private void addTag() {
        TaskTagDialog dlg = new TaskTagDialog(this.fControl.getShell());
        int result = dlg.open();
        if (result == 0) {
            TaskTag newTag = dlg.taskTag;
            ArrayList<TaskTag> newTags = new ArrayList<TaskTag>(Arrays.asList(this.fTaskTags));
            newTags.add(newTag);
            this.fTaskTags = newTags.toArray(new TaskTag[newTags.size()]);
            this.valueTable.setInput((Object)this.fTaskTags);
            this.valueTable.getTable().setSelection(this.fTaskTags.length - 1);
        }
    }

    public Control createContents(Composite tabFolder) {
        this.loadPreferenceValues();
        this.fOriginalTaskTags = this.fTaskTags;
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fControl = composite;
        Text description = new Text(composite, 12);
        description.setText(SSEUIMessages.TaskTagPreferenceTab_33);
        description.setBackground(composite.getBackground());
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        Point sizeHint = description.computeSize(-1, -1);
        gd.widthHint = sizeHint.x;
        description.setLayoutData((Object)gd);
        this.valueTable = new TableViewer(composite, 68356);
        this.valueTable.getControl().setLayoutData((Object)new GridData(1808));
        TableColumn textColumn = new TableColumn(this.valueTable.getTable(), 0, 0);
        textColumn.setText(SSEUIMessages.TaskTagPreferenceTab_12);
        TableColumn priorityColumn = new TableColumn(this.valueTable.getTable(), 0, 1);
        priorityColumn.setText(SSEUIMessages.TaskTagPreferenceTab_13);
        this.valueTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valueTable.setLabelProvider((IBaseLabelProvider)new TaskTagTableLabelProvider());
        this.valueTable.getTable().setLinesVisible(true);
        this.valueTable.getTable().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 140, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 140, true));
        this.valueTable.getTable().setLayout((Layout)layout);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(buttons, 8);
        addButton.setText(SSEUIMessages.TaskTagPreferenceTab_14);
        addButton.setLayoutData((Object)new GridData(256));
        final Button editButton = new Button(buttons, 8);
        editButton.setText(SSEUIMessages.TaskTagPreferenceTab_15);
        editButton.setLayoutData((Object)new GridData(256));
        final Button removeButton = new Button(buttons, 8);
        removeButton.setText(SSEUIMessages.TaskTagPreferenceTab_16);
        removeButton.setLayoutData((Object)new GridData(256));
        editButton.setEnabled(false);
        removeButton.setEnabled(false);
        Label warning = new Label(composite, 0);
        warning.setLayoutData((Object)new GridData());
        warning.setText(SSEUIMessages.TaskTagPreferenceTab_19);
        final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabledForSelection = !MainTab.this.valueTable.getSelection().isEmpty();
                editButton.setEnabled(enabledForSelection);
                removeButton.setEnabled(enabledForSelection);
            }
        };
        this.valueTable.addPostSelectionChangedListener(selectionChangedListener);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.addTag();
                MainTab.this.valueTable.getTable().setSelection(MainTab.this.fTaskTags.length - 1);
                selectionChangedListener.selectionChanged(null);
            }
        });
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = MainTab.this.valueTable.getTable().getSelectionIndex();
                MainTab.this.editTag(i);
                if (i >= 0) {
                    MainTab.this.valueTable.getTable().setSelection(i);
                    selectionChangedListener.selectionChanged(null);
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = MainTab.this.valueTable.getTable().getSelectionIndex();
                MainTab.this.removeTag(MainTab.this.valueTable.getTable().getSelectionIndex());
                if (i >= 0 && i < MainTab.this.fTaskTags.length) {
                    MainTab.this.valueTable.getTable().setSelection(i);
                }
            }
        });
        this.valueTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                int i = MainTab.this.valueTable.getTable().getSelectionIndex();
                MainTab.this.editTag(i);
                if (i >= 0) {
                    MainTab.this.valueTable.getTable().setSelection(i);
                    selectionChangedListener.selectionChanged(null);
                }
            }
        });
        this.valueTable.setInput((Object)this.fTaskTags);
        return composite;
    }

    private void editTag(int i) {
        if (i < 0) {
            return;
        }
        int selection = this.valueTable.getTable().getSelectionIndex();
        TaskTagDialog dlg = new TaskTagDialog(this.fControl.getShell());
        dlg.taskTag = this.fTaskTags[selection];
        int result = dlg.open();
        if (result == 0) {
            this.fTaskTags[selection] = dlg.taskTag;
            this.valueTable.refresh();
        }
    }

    public String getTitle() {
        return SSEUIMessages.TaskTagPreferenceTab_20;
    }

    private void loadPreferenceValues() {
        String tags = this.fPreferencesService.getString("org.eclipse.wst.sse.core/task-tags", "taskTags", "", this.fPreferencesLookupOrder);
        String priorities = this.fPreferencesService.getString("org.eclipse.wst.sse.core/task-tags", "taskPriorities", "", this.fPreferencesLookupOrder);
        this.loadTagsAndPrioritiesFrom(tags, priorities);
    }

    private void loadTagsAndPrioritiesFrom(String tagString, String priorityString) {
        String[] tags = StringUtils.unpack((String)tagString);
        StringTokenizer toker = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        toker = new StringTokenizer(priorityString, ",");
        while (toker.hasMoreTokens()) {
            Integer number = null;
            try {
                number = Integer.valueOf(toker.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                number = new Integer(1);
            }
            list.add(number);
        }
        Integer[] priorities = list.toArray(new Integer[0]);
        this.fTaskTags = new TaskTag[Math.min(tags.length, priorities.length)];
        int i = 0;
        while (i < this.fTaskTags.length) {
            this.fTaskTags[i] = new TaskTag(tags[i], priorities[i].intValue());
            ++i;
        }
    }

    public void performApply() {
        this.save();
        if (!Arrays.equals(this.fOriginalTaskTags, this.fTaskTags)) {
            this.fOwner.requestRedetection();
        }
        this.fOriginalTaskTags = this.fTaskTags;
    }

    public void performDefaults() {
        if (_debugPreferences) {
            System.out.println("Loading defaults in " + this.getClass().getName());
        }
        IEclipsePreferences[] preferences = new IEclipsePreferences[this.fPreferencesLookupOrder.length];
        int i = 0;
        while (i < preferences.length) {
            preferences[i] = this.fPreferencesLookupOrder[i].getNode("org.eclipse.wst.sse.core/task-tags");
            ++i;
        }
        String tags = this.fPreferencesService.get("taskTags", null, (Preferences[])preferences);
        String priorities = this.fPreferencesService.get("taskPriorities", null, (Preferences[])preferences);
        this.loadTagsAndPrioritiesFrom(tags, priorities);
        int selection = this.valueTable.getTable().getSelectionIndex();
        this.valueTable.setInput((Object)this.fTaskTags);
        this.valueTable.getTable().setSelection(selection);
    }

    public void performOk() {
        this.performApply();
    }

    private void removeTag(int i) {
        if (i < 0) {
            return;
        }
        ArrayList<TaskTag> taskTags = new ArrayList<TaskTag>(Arrays.asList(this.fTaskTags));
        taskTags.remove(i);
        this.fTaskTags = taskTags.toArray(new TaskTag[taskTags.size()]);
        this.valueTable.setInput((Object)this.fTaskTags);
    }

    private void save() {
        IEclipsePreferences defaultPreferences = new DefaultScope().getNode("org.eclipse.wst.sse.core/task-tags");
        String defaultTags = defaultPreferences.get("taskTags", null);
        String defaultPriorities = defaultPreferences.get("taskPriorities", null);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fTaskTags.length) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.fTaskTags[i].getTag());
            ++i;
        }
        String currentTags = buf.toString();
        if (currentTags.equals(defaultTags) && !this.fPreferencesLookupOrder[0].getName().equals("default")) {
            if (_debugPreferences) {
                System.out.println(String.valueOf(this.getClass().getName()) + " removing " + "taskTags" + " from scope " + this.fPreferencesLookupOrder[0].getName() + ":" + this.fPreferencesLookupOrder[0].getLocation());
            }
            this.fPreferencesLookupOrder[0].getNode("org.eclipse.wst.sse.core/task-tags").remove("taskTags");
        } else {
            this.fOwner.requestRedetection();
            if (_debugPreferences) {
                System.out.println(String.valueOf(this.getClass().getName()) + " setting " + "taskTags" + " \"" + currentTags + "\" in scope " + this.fPreferencesLookupOrder[0].getName() + ":" + this.fPreferencesLookupOrder[0].getLocation());
            }
            this.fPreferencesLookupOrder[0].getNode("org.eclipse.wst.sse.core/task-tags").put("taskTags", currentTags);
        }
        StringBuffer buf2 = new StringBuffer();
        int i2 = 0;
        while (i2 < this.fTaskTags.length) {
            if (i2 > 0) {
                buf2.append(",");
            }
            buf2.append(String.valueOf(this.fTaskTags[i2].getPriority()));
            ++i2;
        }
        String priorities = buf2.toString();
        if (priorities.equals(defaultPriorities) && !this.fPreferencesLookupOrder[0].getName().equals("default")) {
            if (_debugPreferences) {
                System.out.println(String.valueOf(this.getClass().getName()) + " removing " + "taskPriorities" + " from scope " + this.fPreferencesLookupOrder[0].getName() + ":" + this.fPreferencesLookupOrder[0].getLocation());
            }
            this.fPreferencesLookupOrder[0].getNode("org.eclipse.wst.sse.core/task-tags").remove("taskPriorities");
        } else {
            this.fOwner.requestRedetection();
            if (_debugPreferences) {
                System.out.println(String.valueOf(this.getClass().getName()) + " setting " + "taskPriorities" + " \"" + priorities + "\" in scope " + this.fPreferencesLookupOrder[0].getName() + ":" + this.fPreferencesLookupOrder[0].getLocation());
            }
            this.fPreferencesLookupOrder[0].getNode("org.eclipse.wst.sse.core/task-tags").put("taskPriorities", priorities);
        }
    }

    public class TaskTagDialog
    extends Dialog {
        public TaskTag taskTag = null;
        Combo priorityCombo = null;
        Text tagText = null;

        public TaskTagDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(SSEUIMessages.TaskTagPreferenceTab_5);
        }

        protected Control createButtonBar(Composite parent) {
            Control c = super.createButtonBar(parent);
            this.getButton(0).setEnabled(this.taskTag == null || this.taskTag.getTag().length() > 0);
            return c;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            GridData gridData = new GridData(1808);
            gridData.widthHint = parent.getDisplay().getClientArea().width / 5;
            composite.setLayoutData((Object)gridData);
            Label label = new Label(composite, 0);
            label.setText(SSEUIMessages.TaskTagPreferenceTab_6);
            label.setLayoutData((Object)new GridData());
            this.tagText = new Text(composite, 0);
            this.tagText.setText(this.taskTag != null ? this.taskTag.getTag() : "");
            this.tagText.setLayoutData((Object)new GridData(768));
            this.tagText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ TaskTagDialog this$1;
                {
                    this.this$1 = taskTagDialog;
                }

                public void modifyText(ModifyEvent e) {
                    String testTag = this.this$1.tagText.getText();
                    String[] tags = new String[MainTab.access$0(TaskTagDialog.access$1(this.this$1)).length];
                    int i = 0;
                    while (i < tags.length) {
                        tags[i] = MainTab.access$0(TaskTagDialog.access$1(this.this$1))[i].getTag();
                        ++i;
                    }
                    TaskTagDialog.access$0(this.this$1, 0).setEnabled(this.this$1.tagText.getText().length() > 0 && !Arrays.asList(tags).contains(testTag));
                    this.this$1.taskTag = new TaskTag(this.this$1.tagText.getText(), this.this$1.priorityCombo.getSelectionIndex());
                }
            });
            label = new Label(composite, 0);
            label.setText(SSEUIMessages.TaskTagPreferenceTab_7);
            label.setLayoutData((Object)new GridData());
            this.priorityCombo = new Combo(composite, 12);
            this.priorityCombo.setItems(new String[]{SSEUIMessages.TaskTagPreferenceTab_0, SSEUIMessages.TaskTagPreferenceTab_1, SSEUIMessages.TaskTagPreferenceTab_2});
            this.priorityCombo.select(this.taskTag != null ? this.taskTag.getPriority() : 1);
            this.priorityCombo.setLayoutData((Object)new GridData(768));
            this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ TaskTagDialog this$1;
                {
                    this.this$1 = taskTagDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.taskTag = new TaskTag(this.this$1.taskTag.getTag(), this.this$1.priorityCombo.getSelectionIndex());
                }
            });
            return composite;
        }

        protected void okPressed() {
            this.taskTag = new TaskTag(this.tagText.getText(), this.priorityCombo.getSelectionIndex());
            super.okPressed();
        }

        static /* synthetic */ Button access$0(TaskTagDialog taskTagDialog, int n) {
            return taskTagDialog.getButton(n);
        }

        static /* synthetic */ MainTab access$1(TaskTagDialog taskTagDialog) {
            return taskTagDialog.MainTab.this;
        }
    }

    public class TaskTagTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex < 1) {
                return ((TaskTag)element).getTag();
            }
            int i = 0;
            while (i < MainTab.this.fTaskTags.length) {
                if (MainTab.this.fTaskTags[i].equals(element)) {
                    if (MainTab.this.fTaskTags[i].getPriority() == 0) {
                        return SSEUIMessages.TaskTagPreferenceTab_0;
                    }
                    if (MainTab.this.fTaskTags[i].getPriority() == 2) {
                        return SSEUIMessages.TaskTagPreferenceTab_2;
                    }
                    return SSEUIMessages.TaskTagPreferenceTab_1;
                }
                ++i;
            }
            return SSEUIMessages.TaskTagPreferenceTab_3;
        }
    }
}

