/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.visitor;

import java.util.Iterator;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;

public class WSDLVisitor {
    protected Definition definition;

    public WSDLVisitor(Definition definition) {
        this.definition = definition;
    }

    public void visitDefinition() {
        this.visitBindings();
        this.visitMessages();
        this.visitPortTypes();
        this.visitServices();
    }

    public void visitBindings() {
        Iterator iterator = this.definition.getEBindings().iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            this.visitBinding(binding);
        }
    }

    public void visitMessages() {
        Iterator iterator = this.definition.getEMessages().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            this.visitMessage(message);
        }
    }

    public void visitPortTypes() {
        Iterator iterator = this.definition.getEPortTypes().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            this.visitPortType(portType);
        }
    }

    public void visitServices() {
        Iterator iterator = this.definition.getEServices().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            this.visitService(service);
        }
    }

    public void visitBinding(Binding binding) {
        PortType portType = binding.getEPortType();
        if (portType != null) {
            this.visitPortType(portType);
        }
        Iterator iterator = binding.getEBindingOperations().iterator();
        while (iterator.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            this.visitBindingOperation(bindingOperation);
        }
    }

    public void visitPortType(PortType portType) {
        Iterator iterator = portType.getEOperations().iterator();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            this.visitOperation(operation);
        }
    }

    public void visitBindingOperation(BindingOperation bindingOperation) {
    }

    public void visitOperation(Operation operation) {
        Input input = operation.getEInput();
        Output output = operation.getEOutput();
        if (input != null) {
            this.visitInput(input);
        }
        if (output != null) {
            this.visitOutput(output);
        }
        Iterator iterator = operation.getEFaults().iterator();
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            if (fault == null) continue;
            this.visitFault(fault);
        }
    }

    public void visitPart(Part part) {
    }

    public void visitMessage(Message message) {
        Iterator iterator = message.getEParts().iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            this.visitPart(part);
        }
    }

    public void visitInput(Input input) {
        Message message = input.getEMessage();
        if (message != null) {
            this.visitMessage(message);
        }
    }

    public void visitOutput(Output output) {
        Message message = output.getEMessage();
        if (message != null) {
            this.visitMessage(message);
        }
    }

    public void visitFault(Fault fault) {
        Message message = fault.getEMessage();
        if (message != null) {
            this.visitMessage(message);
        }
    }

    public void visitPort(Port port) {
        Binding binding = port.getEBinding();
        if (binding != null) {
            this.visitBinding(binding);
        }
    }

    public void visitService(Service service) {
        Iterator iterator = service.getEPorts().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            this.visitPort(port);
        }
    }
}

