/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorFilter;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.resource.XMLEncoderDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EMF2SAXWriter {
    public static final String NAMESPACE = "";
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();

    public void serialize(TranslatorResource resource, ContentHandler handler) throws SAXException {
        Translator rootTranslator = resource.getRootTranslator();
        EList contents = resource.getContents();
        if (contents.size() != 1) {
            throw new IllegalStateException("The contents of a resource may only contain one EMF Model Object.");
        }
        handler.startDocument();
        EObject element = (EObject)contents.get(0);
        this.serialize(handler, element, rootTranslator, new WriterHints(resource));
        handler.endDocument();
    }

    private void serialize(ContentHandler handler, EObject target, Translator translator, WriterHints hints) throws SAXException {
        List mofChildren = null;
        Object rawValue = null;
        EObject newTarget = null;
        Translator currentChildTranslator = null;
        Translator nextTranslator = null;
        char[] characterData = null;
        String convertedValue = null;
        Attributes attributes = null;
        String childDomName = null;
        int version = hints.getVersion();
        int[] processingHints = TranslatorFilter.createProcessingHints();
        String targetDomName = translator.getDOMName(target);
        attributes = this.getAttributes(translator, target, hints);
        handler.startElement(NAMESPACE, targetDomName, targetDomName, attributes);
        currentChildTranslator = TranslatorFilter.getNextObjectTranslator(translator, processingHints[0], processingHints, target, version);
        while (currentChildTranslator != null) {
            int j;
            mofChildren = currentChildTranslator.getMOFChildren(target);
            this.openDomPathIfNecessary(handler, hints, currentChildTranslator, target, mofChildren);
            if (currentChildTranslator.isManagedByParent()) {
                childDomName = currentChildTranslator.getDOMName(target);
                if (!currentChildTranslator.isEmptyTag()) {
                    if (mofChildren.size() > 0) {
                        j = 0;
                        while (j < mofChildren.size()) {
                            if (!currentChildTranslator.isDOMTextValue()) {
                                handler.startElement(NAMESPACE, childDomName, childDomName, EMPTY_ATTRIBUTES);
                            }
                            rawValue = mofChildren.get(j);
                            convertedValue = currentChildTranslator.convertValueToString(rawValue, target);
                            characterData = XMLEncoderDecoder.escape(convertedValue).toCharArray();
                            handler.characters(characterData, 0, characterData.length);
                            if (!currentChildTranslator.isDOMTextValue()) {
                                handler.endElement(NAMESPACE, childDomName, childDomName);
                            }
                            ++j;
                        }
                    }
                } else if (currentChildTranslator.isBooleanFeature()) {
                    rawValue = mofChildren.get(0);
                    if (rawValue != null && ((Boolean)rawValue).booleanValue()) {
                        handler.startElement(NAMESPACE, childDomName, childDomName, EMPTY_ATTRIBUTES);
                        handler.endElement(NAMESPACE, childDomName, childDomName);
                    }
                } else {
                    handler.startElement(NAMESPACE, childDomName, childDomName, EMPTY_ATTRIBUTES);
                    handler.endElement(NAMESPACE, childDomName, childDomName);
                }
            } else {
                j = 0;
                while (j < mofChildren.size()) {
                    newTarget = (EObject)mofChildren.get(j);
                    this.serialize(handler, newTarget, currentChildTranslator, hints);
                    ++j;
                }
            }
            nextTranslator = TranslatorFilter.getNextObjectTranslator(translator, processingHints[0], processingHints, target, version);
            this.closeDomPathIfNecessary(handler, hints, currentChildTranslator, nextTranslator, target, mofChildren);
            currentChildTranslator = nextTranslator;
        }
        handler.endElement(NAMESPACE, targetDomName, targetDomName);
    }

    private boolean shouldRenderDomPath(EObject target, Translator currentChildTranslator, List mofChildren) {
        return !currentChildTranslator.isEmptyContentSignificant() || currentChildTranslator.shouldRenderEmptyDOMPath(target) || mofChildren.size() > 0;
    }

    private void openDomPathIfNecessary(ContentHandler handler, WriterHints hints, Translator currentChildTranslator, EObject target, List mofChildren) throws SAXException {
        String childDomPath;
        if (currentChildTranslator.hasDOMPath() && this.shouldRenderDomPath(target, currentChildTranslator, mofChildren) && !hints.isDomPathActive(childDomPath = currentChildTranslator.getDOMPath())) {
            handler.startElement(NAMESPACE, childDomPath, childDomPath, EMPTY_ATTRIBUTES);
            hints.pushDomPath(childDomPath);
        }
    }

    private void closeDomPathIfNecessary(ContentHandler handler, WriterHints hints, Translator currentChildTranslator, Translator nextTranslator, EObject target, List mofChildren) throws SAXException {
        if (currentChildTranslator.hasDOMPath() && this.shouldRenderDomPath(target, currentChildTranslator, mofChildren)) {
            String childDomPath = currentChildTranslator.getDOMPath();
            if (nextTranslator != null) {
                String nextPeerDomPath = nextTranslator.getDOMPath();
                if (nextPeerDomPath == null || !nextPeerDomPath.equals(childDomPath)) {
                    handler.endElement(NAMESPACE, childDomPath, childDomPath);
                    hints.popDomPath();
                }
            } else {
                handler.endElement(NAMESPACE, childDomPath, childDomPath);
                hints.popDomPath();
            }
        }
    }

    private Attributes getAttributes(Translator translator, EObject target, WriterHints hints) {
        AttributesImpl attributes = hints.getAttributeHolder();
        int version = hints.getVersion();
        Object rawValue = null;
        String convertedValue = null;
        String childDomName = null;
        Translator attributeTranslator = null;
        int[] processingHints = TranslatorFilter.createProcessingHints();
        while ((attributeTranslator = TranslatorFilter.getNextAttributeTranslator(translator, processingHints[0], processingHints, target, version)) != null) {
            List mofChildren = attributeTranslator.getMOFChildren(target);
            if (mofChildren.size() > 0) {
                int j = 0;
                while (j < mofChildren.size()) {
                    childDomName = attributeTranslator.getDOMName(target);
                    rawValue = mofChildren.get(j);
                    convertedValue = attributeTranslator.convertValueToString(rawValue, target);
                    convertedValue = XMLEncoderDecoder.escape(convertedValue);
                    attributes.addAttribute(NAMESPACE, childDomName, childDomName, "String", convertedValue);
                    ++j;
                }
                continue;
            }
            childDomName = attributeTranslator.getDOMName(target);
            convertedValue = (String)attributeTranslator.getMOFValue(target);
            if (convertedValue == null) continue;
            attributes.addAttribute(NAMESPACE, childDomName, childDomName, "String", convertedValue);
        }
        return attributes;
    }

    public final class WriterHints {
        private final TranslatorResource resource;
        private final Stack domStack = new Stack();
        private final AttributesImpl attributesImpl = new AttributesImpl();

        public WriterHints(TranslatorResource res) {
            this.resource = res;
        }

        public void pushDomPath(String domPath) {
            if (domPath != null && domPath.length() > 0) {
                this.domStack.push(domPath);
            }
        }

        public void popDomPath() {
            if (!this.domStack.isEmpty()) {
                this.domStack.pop();
            }
        }

        public boolean isDomPathActive(String domPath) {
            boolean result = false;
            if (!this.domStack.isEmpty()) {
                String currentDomPath = (String)this.domStack.peek();
                if (currentDomPath != null && domPath != null) {
                    result = currentDomPath.equals(domPath);
                } else if (!(currentDomPath == null ^ domPath == null)) {
                    result = true;
                }
            }
            return result;
        }

        public int getVersion() {
            return this.resource.getVersionID();
        }

        public AttributesImpl getAttributeHolder() {
            this.attributesImpl.clear();
            return this.attributesImpl;
        }
    }
}

