/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.providers;

public interface IServerConnectionInformation
{
    /**
     * Should be set when the information required by this provider is complete
     * @param value - True if the information is complete
     */
	public void setInformationComplete (boolean value);
	
	/**
	 * Should be set when the database name is getting entered by the user
	 * Will be used to default the database name
	 * @param serverName
	 */
	public void setDatabaseName (String serverName);
	public String getDatabaseName();
	
	/**
	 * Will be set when additional information is entered by the user
	 * @param url
	 */
	public void setURL (String url);
	public String getURL();

	/**
	 * @param Driver Class Name
	 *
	 */
	public void setDriverClassName(String driverClassName);
	public String getDriverClassName();
    
	/**
	 * @param Drivers Location
	 */
	public void setLoadingPath(String loadingPath);
	public String getLoadingPath();
	
	/**
	 * @param property name
	 * @param property value
	 */
	public void setCustomProperty(String name, String value);
	public String getCustomProperty(String name);
}
