/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ArrayRuntimeContext;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.contentassist.CurrentFrameContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class CurrentValueContext
extends CurrentFrameContext {
    public IType getType() throws CoreException {
        IJavaValue value = this.resolveValue();
        if (value == null || value instanceof IJavaPrimitiveValue) {
            return super.getType();
        }
        IType type = null;
        if (value instanceof IJavaArray) {
            IJavaType[] types = ((IJavaDebugTarget)value.getDebugTarget()).getJavaTypes("java.lang.Object");
            if (types.length > 0) {
                type = JavaDebugUtils.resolveType((IJavaType)types[0]);
            }
        } else {
            type = JavaDebugUtils.resolveType((IJavaValue)value);
        }
        if (type == null) {
            this.unableToResolveType();
        }
        return type;
    }

    protected IJavaValue resolveValue() throws CoreException {
        ISelection selection;
        IDebugView view;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IJavaStackFrame stackFrame = this.getStackFrame();
        if (stackFrame == null) {
            this.unableToResolveType();
        }
        if ((window = JDIDebugUIPlugin.getActiveWorkbenchWindow()) == null) {
            this.unableToResolveType();
        }
        if ((page = window.getActivePage()) == null) {
            this.unableToResolveType();
        }
        if ((view = (IDebugView)page.getActivePart()) == null) {
            this.unableToResolveType();
        }
        if (!(selection = view.getViewer().getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection viewerSelection = (IStructuredSelection)selection;
            if (viewerSelection.size() > 1) {
                this.unableToResolveType();
            }
            Object element = viewerSelection.getFirstElement();
            IValue value = null;
            if (element instanceof IVariable) {
                IVariable variable = (IVariable)element;
                if (!variable.getName().equals("this")) {
                    value = variable.getValue();
                }
            } else if (element instanceof IExpression) {
                value = ((IExpression)element).getValue();
            }
            if (value instanceof IJavaValue) {
                return (IJavaValue)value;
            }
        }
        return null;
    }

    public String[][] getLocalVariables() throws CoreException {
        IJavaValue value = this.resolveValue();
        if (value instanceof IJavaArray) {
            return new String[][]{{ArrayRuntimeContext.ARRAY_THIS_VARIABLE}, {value.getJavaType().getName()}};
        }
        if (value instanceof IJavaObject) {
            return new String[0][];
        }
        return super.getLocalVariables();
    }

    public String getSnippet(String snippet) throws CoreException {
        IJavaValue value = this.resolveValue();
        if (value instanceof IJavaArray) {
            return ASTEvaluationEngine.replaceThisReferences((String)snippet);
        }
        return super.getSnippet(snippet);
    }

    public boolean isStatic() throws CoreException {
        IJavaValue value = this.resolveValue();
        if (value instanceof IJavaObject) {
            return false;
        }
        return super.isStatic();
    }
}

