/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.ManifestErrorReporter;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtensionsErrorReporter
extends ManifestErrorReporter {
    private IPluginModelBase fModel;
    private IBuild fBuildModel;

    public ExtensionsErrorReporter(IFile file) {
        super(file);
        this.fModel = PDECore.getDefault().getModelManager().findModel(file.getProject());
        try {
            if (this.fModel != null && this.fModel.getUnderlyingResource() != null) {
                this.fBuildModel = ClasspathUtilCore.getBuild(this.fModel);
            }
        }
        catch (CoreException coreException) {}
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
    }

    public void validateContent(IProgressMonitor monitor) {
        Element element = this.getDocumentRoot();
        if (element == null) {
            return;
        }
        String elementName = element.getNodeName();
        if (!"plugin".equals(elementName) && !"fragment".equals(elementName)) {
            this.reportIllegalElement(element, 0);
        } else {
            int i;
            int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
            if (severity != 2) {
                NamedNodeMap attrs = element.getAttributes();
                i = 0;
                while (i < attrs.getLength()) {
                    this.reportUnusedAttribute(element, attrs.item(i).getNodeName(), severity);
                    ++i;
                }
            }
            NodeList children = element.getChildNodes();
            i = 0;
            while (i < children.getLength()) {
                if (monitor.isCanceled()) break;
                Element child = (Element)children.item(i);
                String name = child.getNodeName();
                if (name.equals("extension")) {
                    this.validateExtension(child);
                } else if (name.equals("extension-point")) {
                    this.validateExtensionPoint(child);
                } else if (!name.equals("runtime") && !name.equals("requires")) {
                    severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-element");
                    if (severity != 2) {
                        this.reportIllegalElement(child, severity);
                    }
                } else {
                    severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
                    if (severity != 2) {
                        this.reportUnusedElement(child, severity);
                    }
                }
                ++i;
            }
        }
    }

    protected void validateExtension(Element element) {
        if (!this.assertAttributeDefined(element, "point", 0)) {
            return;
        }
        String pointID = element.getAttribute("point");
        IPluginExtensionPoint point = PDECore.getDefault().findExtensionPoint(pointID);
        if (point == null) {
            int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-ex-points");
            if (severity != 2) {
                this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_ex_point, (Object)pointID), this.getLine(element, "point"), severity);
            }
        } else {
            SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
            ISchema schema = registry.getSchema(pointID);
            if (schema != null) {
                this.validateElement(element, schema);
            }
        }
    }

    protected void validateElement(Element element, ISchema schema) {
        int severity;
        String elementName = element.getNodeName();
        ISchemaElement schemaElement = schema.findElement(elementName);
        ISchemaElement parentSchema = null;
        if (!"extension".equals(elementName)) {
            Node parent = element.getParentNode();
            parentSchema = schema.findElement(parent.getNodeName());
        }
        if (parentSchema != null && (severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-element")) != 2) {
            HashSet allowedElements = new HashSet();
            this.computeAllowedElements(parentSchema.getType(), allowedElements);
            if (!allowedElements.contains(elementName)) {
                this.reportIllegalElement(element, severity);
                return;
            }
        }
        if (schemaElement == null && parentSchema != null) {
            ISchemaAttribute attr = parentSchema.getAttribute(elementName);
            if (attr != null && attr.getKind() == 1) {
                if (attr.isDeprecated()) {
                    this.reportDeprecatedAttribute(element, element.getAttributeNode("class"));
                }
                this.validateJavaAttribute(element, element.getAttributeNode("class"));
            }
        } else {
            if (schemaElement != null) {
                this.validateRequiredExtensionAttributes(element, schemaElement);
                this.validateExistingExtensionAttributes(element, element.getAttributes(), schemaElement);
                if (schemaElement.isDeprecated()) {
                    if (schemaElement instanceof ISchemaRootElement) {
                        this.reportDeprecatedRootElement(element, ((ISchemaRootElement)schemaElement).getDeprecatedSuggestion());
                    } else {
                        this.reportDeprecatedElement(element);
                    }
                }
                if (schemaElement.hasTranslatableContent()) {
                    this.validateTranslatableElementContent(element);
                }
            }
            NodeList children = element.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.validateElement((Element)children.item(i), schema);
                ++i;
            }
        }
    }

    private void computeAllowedElements(ISchemaType type, HashSet elementSet) {
        if (type instanceof ISchemaComplexType) {
            ISchemaComplexType complexType = (ISchemaComplexType)type;
            ISchemaCompositor compositor = complexType.getCompositor();
            if (compositor != null) {
                this.computeAllowedElements(compositor, elementSet);
            }
            ISchemaAttribute[] attrs = complexType.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].getKind() == 1) {
                    elementSet.add(attrs[i].getName());
                }
                ++i;
            }
        }
    }

    private void computeAllowedElements(ISchemaCompositor compositor, HashSet elementSet) {
        ISchemaObject[] children = compositor.getChildren();
        int i = 0;
        while (i < children.length) {
            ISchemaObject child = children[i];
            if (child instanceof ISchemaObjectReference) {
                ISchemaObjectReference ref = (ISchemaObjectReference)((Object)child);
                ISchemaElement refElement = (ISchemaElement)ref.getReferencedObject();
                if (refElement != null) {
                    elementSet.add(refElement.getName());
                }
            } else if (child instanceof ISchemaCompositor) {
                this.computeAllowedElements((ISchemaCompositor)child, elementSet);
            }
            ++i;
        }
    }

    private void validateRequiredExtensionAttributes(Element element, ISchemaElement schemaElement) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.no-required-att");
        if (severity == 2) {
            return;
        }
        ISchemaAttribute[] attInfos = schemaElement.getAttributes();
        int i = 0;
        while (i < attInfos.length) {
            ISchemaAttribute attInfo = attInfos[i];
            if (attInfo.getUse() == 1) {
                boolean found;
                boolean bl = found = element.getAttributeNode(attInfo.getName()) != null;
                if (!found && attInfo.getKind() == 1) {
                    NodeList children = element.getChildNodes();
                    int j = 0;
                    while (j < children.getLength()) {
                        if (attInfo.getName().equals(children.item(j).getNodeName())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found) {
                    this.reportMissingRequiredAttribute(element, attInfo.getName(), severity);
                }
            }
            ++i;
        }
    }

    private void validateExistingExtensionAttributes(Element element, NamedNodeMap attrs, ISchemaElement schemaElement) {
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            ISchemaAttribute attInfo = schemaElement.getAttribute(attr.getName());
            if (attInfo == null) {
                HashSet allowedElements = new HashSet();
                this.computeAllowedElements(schemaElement.getType(), allowedElements);
                if (allowedElements.contains(attr.getName())) {
                    this.validateJavaAttribute(element, attr);
                } else {
                    int flag = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-attribute");
                    if (flag != 2) {
                        this.reportUnknownAttribute(element, attr.getName(), flag);
                    }
                }
            } else {
                this.validateExtensionAttribute(element, attr, attInfo);
            }
            ++i;
        }
    }

    private void validateExtensionAttribute(Element element, Attr attr, ISchemaAttribute attInfo) {
        int kind;
        ISchemaSimpleType type = attInfo.getType();
        ISchemaRestriction restriction = type.getRestriction();
        if (restriction != null) {
            this.validateRestrictionAttribute(element, attr, restriction);
        }
        if ((kind = attInfo.getKind()) == 1) {
            this.validateJavaAttribute(element, attr);
        } else if (kind == 2) {
            this.validateResourceAttribute(element, attr);
        } else if (type.getName().equals("boolean")) {
            this.validateBoolean(element, attr);
        }
        this.validateTranslatableString(element, attr, attInfo.isTranslatable());
        if (attInfo.isDeprecated()) {
            this.reportDeprecatedAttribute(element, attr);
        }
    }

    protected void validateExtensionPoint(Element element) {
        if (this.assertAttributeDefined(element, "id", 0)) {
            Attr idAttr = element.getAttributeNode("id");
            double schemaVersion = this.getSchemaVersion();
            String message = null;
            if (schemaVersion < 3.2 && !IdUtil.isValidSimpleID(idAttr.getValue())) {
                message = NLS.bind((String)PDECoreMessages.Builders_Manifest_simpleID, (Object)idAttr.getValue());
            } else if (schemaVersion >= 3.2) {
                if (!IdUtil.isValidCompositeID(idAttr.getValue())) {
                    message = NLS.bind((String)PDECoreMessages.Builders_Manifest_compositeID, (Object)idAttr.getValue());
                } else {
                    String id = idAttr.getNodeValue();
                    int index = id.lastIndexOf(46);
                    if (index > 0) {
                        String pluginId = id.substring(0, index);
                        if (PDECore.getDefault().getModelManager().findEntry(pluginId) == null) {
                            message = NLS.bind((String)PDECoreMessages.Builders_Manifest_namespaceNotFound, (Object)id);
                        }
                    }
                }
            }
            if (message != null) {
                this.report(message, this.getLine(element, idAttr.getName()), 1);
            }
        }
        this.assertAttributeDefined(element, "name", 0);
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-attribute");
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            String name = attr.getName();
            if ("name".equals(name)) {
                this.validateTranslatableString(element, attr, true);
            } else if (!"id".equals(name) && !"schema".equals(name) && severity != 2) {
                this.reportUnknownAttribute(element, name, severity);
            }
            ++i;
        }
        severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-element");
        if (severity != 2) {
            NodeList children = element.getChildNodes();
            int i2 = 0;
            while (i2 < children.getLength()) {
                this.reportIllegalElement((Element)children.item(i2), severity);
                ++i2;
            }
        }
    }

    protected void validateTranslatableString(Element element, Attr attr, boolean shouldTranslate) {
        NLResourceHelper helper;
        if (!shouldTranslate) {
            return;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.not-externalized-att");
        if (severity == 2) {
            return;
        }
        String value = attr.getValue();
        if (!value.startsWith("%")) {
            this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_non_ext_attribute, (Object)attr.getName()), this.getLine(element, attr.getName()), severity, 12290, element, attr.getName());
        } else if (this.fModel instanceof AbstractModel && ((helper = ((AbstractModel)((Object)this.fModel)).getNLResourceHelper()) == null || !helper.resourceExists(value))) {
            this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_key_not_found, (Object)value.substring(1)), this.getLine(element, attr.getName()), severity);
        }
    }

    protected void validateTranslatableElementContent(Element element) {
        NLResourceHelper helper;
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.not-externalized-att");
        if (severity == 2) {
            return;
        }
        String value = this.getTextContent(element);
        if (value == null) {
            return;
        }
        if (!value.startsWith("%")) {
            this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_non_ext_element, (Object)element.getNodeName()), this.getLine(element), severity, 12290, element, null);
        } else if (this.fModel instanceof AbstractModel && ((helper = ((AbstractModel)((Object)this.fModel)).getNLResourceHelper()) == null || !helper.resourceExists(value))) {
            this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_key_not_found, (Object)value.substring(1)), this.getLine(element), severity);
        }
    }

    protected void validateResourceAttribute(Element element, Attr attr) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-resource");
        if (severity != 2 && !this.resourceExists(attr.getValue())) {
            this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_resource, (Object[])new String[]{attr.getValue(), attr.getName()}), this.getLine(element, attr.getName()), severity);
        }
    }

    private boolean resourceExists(String location) {
        String bundleLocation;
        IPluginModelBase model;
        String id;
        String bundleJar = null;
        Path path = new Path(location);
        if ("platform:".equals(path.getDevice()) && path.segmentCount() > 2) {
            if ("plugin".equals(path.segment(0))) {
                id = path.segment(1);
                model = PDECore.getDefault().getModelManager().findModel(id);
                if (model != null && model.isEnabled()) {
                    path = path.setDevice(null).removeFirstSegments(2);
                    bundleLocation = model.getInstallLocation();
                    if (bundleLocation.endsWith(".jar")) {
                        bundleJar = bundleLocation;
                    } else {
                        path = new Path(model.getInstallLocation()).append((IPath)path);
                    }
                    location = path.toString();
                }
            }
        } else if (path.getDevice() == null && path.segmentCount() > 3 && "platform:".equals(path.segment(0)) && "plugin".equals(path.segment(1))) {
            id = path.segment(2);
            model = PDECore.getDefault().getModelManager().findModel(id);
            if (model != null && model.isEnabled()) {
                path = path.removeFirstSegments(3);
                bundleLocation = model.getInstallLocation();
                if (bundleLocation.endsWith(".jar")) {
                    bundleJar = bundleLocation;
                } else {
                    path = new Path(model.getInstallLocation()).append((IPath)path);
                }
                location = path.toString();
            }
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (location.indexOf("$nl$") != -1) {
            String country;
            StringTokenizer tokenizer = new StringTokenizer(TargetPlatform.getNL(), "_");
            String language = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            String string = country = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (language != null && country != null) {
                paths.add(location.replaceAll("\\$nl\\$", "nl/" + language + '/' + country));
            }
            if (language != null) {
                paths.add(location.replaceAll("\\$nl\\$", "nl/" + language));
            }
            paths.add(location.replaceAll("\\$nl\\$", ""));
        } else {
            paths.add(location);
        }
        int i = 0;
        while (i < paths.size()) {
            if (bundleJar == null) {
                Path currPath = new Path(paths.get(i).toString());
                if (currPath.isAbsolute() && currPath.toFile().exists()) {
                    return true;
                }
                if (this.fFile.getProject().findMember((IPath)currPath) != null) {
                    return true;
                }
                if (this.fBuildModel != null && this.fBuildModel.getEntry("source." + paths.get(i)) != null) {
                    return true;
                }
            } else if (CoreUtility.jarContainsResource(new File(bundleJar), paths.get(i).toString(), false)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void validateJavaAttribute(Element element, Attr attr) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-class");
        if (severity == 2) {
            return;
        }
        String value = attr.getValue();
        IJavaProject javaProject = JavaCore.create((IProject)this.fFile.getProject());
        try {
            IType javaType;
            int index = value.indexOf(":");
            if (index != -1) {
                value = value.substring(0, index);
            }
            if (value.indexOf(36) != -1) {
                value = value.replace('$', '.');
            }
            if ((javaType = javaProject.findType(value)) == null) {
                this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_class, (Object[])new String[]{value, attr.getName()}), this.getLine(element, attr.getName()), severity, 12291, element, String.valueOf(attr.getName()) + '!' + attr.getValue());
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void validateRestrictionAttribute(Element element, Attr attr, ISchemaRestriction restriction) {
        Object[] children = restriction.getChildren();
        String value = attr.getValue();
        int i = 0;
        while (i < children.length) {
            ISchemaEnumeration enumeration;
            Object child = children[i];
            if (child instanceof ISchemaEnumeration && (enumeration = (ISchemaEnumeration)child).getName().equals(value)) {
                return;
            }
            ++i;
        }
        this.reportIllegalAttributeValue(element, attr);
    }

    protected void reportUnusedAttribute(Element element, String attName, int severity) {
        String message = NLS.bind((String)PDECoreMessages.Builders_Manifest_unused_attribute, (Object)attName);
        this.report(message, this.getLine(element, attName), severity);
    }

    protected void reportUnusedElement(Element element, int severity) {
        Node parent = element.getParentNode();
        this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_unused_element, (Object[])new String[]{element.getNodeName(), parent.getNodeName()}), this.getLine(element), severity);
    }

    protected void reportDeprecatedElement(Element element) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (severity != 2) {
            this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_deprecated_element, (Object)element.getNodeName()), this.getLine(element), severity);
        }
    }

    protected void reportDeprecatedRootElement(Element element, String suggestion) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (severity != 2) {
            String point = element.getAttribute("point");
            if (point == null) {
                return;
            }
            String message = suggestion != null ? NLS.bind((String)PDECoreMessages.Builders_Manifest_deprecated_rootElementSuggestion, (Object)point, (Object)suggestion) : NLS.bind((String)PDECoreMessages.Builders_Manifest_deprecated_rootElement, (Object)point);
            this.report(message, this.getLine(element, "point"), severity);
        }
    }
}

