/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.rmic;

import gnu.java.rmi.rmic.Compiler;
import gnu.java.rmi.rmic.TabbedWriter;
import gnu.java.rmi.server.RMIHashes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class RMIC {
    private String[] args;
    private int next;
    private Exception exception;
    private boolean keep;
    private boolean need11Stubs;
    private boolean need12Stubs;
    private boolean compile;
    private boolean verbose;
    private String destination;
    private PrintWriter out;
    private TabbedWriter ctrl;
    private Class clazz;
    private String classname;
    private String fullclassname;
    private String fullstubname;
    private String fullskelname;
    private MethodRef[] remotemethods;
    private String stubname;
    private String skelname;
    private ClassLoader loader;
    private String classpath;
    private int errorCount;
    private List mRemoteInterfaces;

    private /* synthetic */ void finit$() {
        this.keep = false;
        this.need11Stubs = true;
        this.need12Stubs = true;
        this.compile = true;
        this.errorCount = 0;
    }

    public RMIC(String[] stringArray) {
        this.finit$();
        this.args = stringArray;
    }

    public static void main(String[] stringArray) {
        RMIC rMIC = new RMIC(stringArray);
        if (!rMIC.run()) {
            Exception exception = rMIC.getException();
            if (exception != null) {
                exception.printStackTrace();
            } else {
                System.exit(1);
            }
        }
    }

    public boolean run() {
        this.parseOptions();
        if (this.next >= this.args.length) {
            RMIC.error("no class names found");
        }
        for (int i = this.next; i < this.args.length; ++i) {
            try {
                if (this.verbose) {
                    System.out.println("[Processing class " + this.args[i] + ".class]");
                }
                this.processClass(this.args[i].replace(File.separatorChar, '.'));
                continue;
            }
            catch (Exception exception) {
                this.exception = exception;
                return false;
            }
        }
        return true;
    }

    private boolean processClass(String string) throws Exception {
        this.clazz = null;
        this.classname = null;
        this.fullclassname = null;
        this.remotemethods = null;
        this.stubname = null;
        this.fullstubname = null;
        this.skelname = null;
        this.fullskelname = null;
        this.mRemoteInterfaces = new ArrayList();
        this.errorCount = 0;
        this.analyzeClass(string);
        if (this.errorCount > 0) {
            System.exit(1);
        }
        this.generateStub();
        if (this.need11Stubs) {
            this.generateSkel();
        }
        if (this.compile) {
            this.compile(this.fullstubname);
            if (this.need11Stubs) {
                this.compile(this.fullskelname);
            }
        }
        if (!this.keep) {
            new File(this.fullstubname).delete();
            if (this.need11Stubs) {
                new File(this.fullskelname).delete();
            }
        }
        return true;
    }

    private void analyzeClass(String string) throws Exception {
        int n;
        if (this.verbose) {
            System.out.println("[analyze class " + string + "]");
        }
        this.classname = (n = string.lastIndexOf(46)) != -1 ? string.substring(n + 1) : string;
        this.fullclassname = string;
        this.findClass();
        this.findRemoteMethods();
    }

    public Exception getException() {
        return this.exception;
    }

    private void findClass() throws ClassNotFoundException {
        try {
            ClassLoader classLoader = this.loader == null ? ClassLoader.getSystemClassLoader() : this.loader;
            this.clazz = Class.forName(this.fullclassname, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(this.fullclassname + " not found in " + this.classpath);
            throw new RuntimeException(classNotFoundException);
        }
        if (!RMIC.class$("java.rmi.Remote").isAssignableFrom(this.clazz)) {
            this.logError("Class " + this.clazz.getName() + " is not a remote object. " + "It does not implement an interface that is a " + "java.rmi.Remote-interface.");
            throw new RuntimeException("Class " + this.clazz.getName() + " is not a remote object. " + "It does not implement an interface that is a " + "java.rmi.Remote-interface.");
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void generateStub() throws IOException {
        int n;
        Class[] classArray;
        Method method;
        Object object;
        this.stubname = this.fullclassname + "_Stub";
        String string = this.classname + "_Stub";
        this.fullstubname = (this.destination == null ? "" : this.destination + File.separator) + this.stubname.replace('.', File.separatorChar) + ".java";
        File file = new File(this.fullstubname);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        this.ctrl = new TabbedWriter(new FileWriter(file));
        this.out = new PrintWriter(this.ctrl);
        if (this.verbose) {
            System.out.println("[Generating class " + this.stubname + ".java]");
        }
        this.out.println("// Stub class generated by rmic - DO NOT EDIT!");
        this.out.println();
        if (this.fullclassname != this.classname) {
            object = this.fullclassname.substring(0, this.fullclassname.lastIndexOf(46));
            this.out.println("package " + (String)object + ";");
            this.out.println();
        }
        this.out.print("public final class " + string);
        this.ctrl.indent();
        this.out.println("extends java.rmi.server.RemoteStub");
        this.out.print("implements ");
        object = this.mRemoteInterfaces.iterator();
        while (object.hasNext()) {
            Class clazz = (Class)object.next();
            this.out.print(clazz.getName());
            if (!object.hasNext()) continue;
            this.out.print(", ");
        }
        this.ctrl.unindent();
        this.out.print("{");
        this.ctrl.indent();
        if (this.need12Stubs) {
            this.out.println("private static final long serialVersionUID = 2L;");
            this.out.println();
        }
        if (this.need11Stubs) {
            this.out.println("private static final long interfaceHash = " + RMIHashes.getInterfaceHash(this.clazz) + "L;");
            this.out.println();
            if (this.need12Stubs) {
                this.out.println("private static boolean useNewInvoke;");
                this.out.println();
            }
            this.out.print("private static final java.rmi.server.Operation[] operations = {");
            this.ctrl.indent();
            for (int i = 0; i < this.remotemethods.length; ++i) {
                method = this.remotemethods[i].meth;
                this.out.print("new java.rmi.server.Operation(\"");
                this.out.print(RMIC.getPrettyName(method.getReturnType()) + " ");
                this.out.print(method.getName() + "(");
                classArray = method.getParameterTypes();
                for (n = 0; n < classArray.length; ++n) {
                    this.out.print(RMIC.getPrettyName(classArray[n]));
                    if (n + 1 >= classArray.length) continue;
                    this.out.print(", ");
                }
                this.out.print(")\")");
                if (i + 1 >= this.remotemethods.length) continue;
                this.out.println(",");
            }
            this.ctrl.unindent();
            this.out.println("};");
            this.out.println();
        }
        if (this.need12Stubs) {
            int n2;
            for (n2 = 0; n2 < this.remotemethods.length; ++n2) {
                method = this.remotemethods[n2].meth;
                this.out.println("private static java.lang.reflect.Method $method_" + method.getName() + "_" + n2 + ";");
            }
            this.out.println();
            this.out.print("static {");
            this.ctrl.indent();
            this.out.print("try {");
            this.ctrl.indent();
            if (this.need11Stubs) {
                this.out.println("java.rmi.server.RemoteRef.class.getMethod(\"invoke\", new java.lang.Class[] { java.rmi.Remote.class, java.lang.reflect.Method.class, java.lang.Object[].class, long.class });");
                this.out.println("useNewInvoke = true;");
            }
            for (n2 = 0; n2 < this.remotemethods.length; ++n2) {
                method = this.remotemethods[n2].meth;
                this.out.print("$method_" + method.getName() + "_" + n2 + " = ");
                this.out.print(method.getDeclaringClass().getName() + ".class.getMethod(\"" + method.getName() + "\"");
                this.out.print(", new java.lang.Class[] {");
                classArray = method.getParameterTypes();
                for (n = 0; n < classArray.length; ++n) {
                    this.out.print(RMIC.getPrettyName(classArray[n]) + ".class");
                    if (n + 1 >= classArray.length) continue;
                    this.out.print(", ");
                }
                this.out.println("});");
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.lang.NoSuchMethodException e) {");
            this.ctrl.indent();
            if (this.need11Stubs) {
                this.out.print("useNewInvoke = false;");
            } else {
                this.out.print("throw new java.lang.NoSuchMethodError(\"stub class initialization failed\");");
            }
            this.ctrl.unindent();
            this.out.print("}");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.println();
        }
        if (this.need11Stubs) {
            this.out.print("public " + string + "() {");
            this.ctrl.indent();
            this.out.print("super();");
            this.ctrl.unindent();
            this.out.println("}");
        }
        if (this.need12Stubs) {
            this.out.print("public " + string + "(java.rmi.server.RemoteRef ref) {");
            this.ctrl.indent();
            this.out.print("super(ref);");
            this.ctrl.unindent();
            this.out.println("}");
        }
        for (int i = 0; i < this.remotemethods.length; ++i) {
            int n3;
            method = this.remotemethods[i].meth;
            classArray = method.getParameterTypes();
            Class clazz = method.getReturnType();
            Class[] classArray2 = this.sortExceptions(method.getExceptionTypes());
            this.out.println();
            this.out.print("public " + RMIC.getPrettyName(clazz) + " " + method.getName() + "(");
            for (n3 = 0; n3 < classArray.length; ++n3) {
                this.out.print(RMIC.getPrettyName(classArray[n3]));
                this.out.print(" $param_" + n3);
                if (n3 + 1 >= classArray.length) continue;
                this.out.print(", ");
            }
            this.out.print(") ");
            this.out.print("throws ");
            for (n3 = 0; n3 < classArray2.length; ++n3) {
                this.out.print(RMIC.getPrettyName(classArray2[n3]));
                if (n3 + 1 >= classArray2.length) continue;
                this.out.print(", ");
            }
            this.out.print(" {");
            this.ctrl.indent();
            this.out.print("try {");
            this.ctrl.indent();
            if (this.need12Stubs) {
                if (this.need11Stubs) {
                    this.out.print("if (useNewInvoke) {");
                    this.ctrl.indent();
                }
                if (clazz != Void.TYPE) {
                    this.out.print("java.lang.Object $result = ");
                }
                this.out.print("ref.invoke(this, $method_" + method.getName() + "_" + i + ", ");
                if (classArray.length == 0) {
                    this.out.print("null, ");
                } else {
                    this.out.print("new java.lang.Object[] {");
                    for (n3 = 0; n3 < classArray.length; ++n3) {
                        if (classArray[n3] == Boolean.TYPE) {
                            this.out.print("new java.lang.Boolean($param_" + n3 + ")");
                        } else if (classArray[n3] == Byte.TYPE) {
                            this.out.print("new java.lang.Byte($param_" + n3 + ")");
                        } else if (classArray[n3] == Character.TYPE) {
                            this.out.print("new java.lang.Character($param_" + n3 + ")");
                        } else if (classArray[n3] == Short.TYPE) {
                            this.out.print("new java.lang.Short($param_" + n3 + ")");
                        } else if (classArray[n3] == Integer.TYPE) {
                            this.out.print("new java.lang.Integer($param_" + n3 + ")");
                        } else if (classArray[n3] == Long.TYPE) {
                            this.out.print("new java.lang.Long($param_" + n3 + ")");
                        } else if (classArray[n3] == Float.TYPE) {
                            this.out.print("new java.lang.Float($param_" + n3 + ")");
                        } else if (classArray[n3] == Double.TYPE) {
                            this.out.print("new java.lang.Double($param_" + n3 + ")");
                        } else {
                            this.out.print("$param_" + n3);
                        }
                        if (n3 + 1 >= classArray.length) continue;
                        this.out.print(", ");
                    }
                    this.out.print("}, ");
                }
                this.out.print(Long.toString(this.remotemethods[i].hash) + "L");
                this.out.print(");");
                if (clazz != Void.TYPE) {
                    this.out.println();
                    this.out.print("return (");
                    if (clazz == Boolean.TYPE) {
                        this.out.print("((java.lang.Boolean)$result).booleanValue()");
                    } else if (clazz == Byte.TYPE) {
                        this.out.print("((java.lang.Byte)$result).byteValue()");
                    } else if (clazz == Character.TYPE) {
                        this.out.print("((java.lang.Character)$result).charValue()");
                    } else if (clazz == Short.TYPE) {
                        this.out.print("((java.lang.Short)$result).shortValue()");
                    } else if (clazz == Integer.TYPE) {
                        this.out.print("((java.lang.Integer)$result).intValue()");
                    } else if (clazz == Long.TYPE) {
                        this.out.print("((java.lang.Long)$result).longValue()");
                    } else if (clazz == Float.TYPE) {
                        this.out.print("((java.lang.Float)$result).floatValue()");
                    } else if (clazz == Double.TYPE) {
                        this.out.print("((java.lang.Double)$result).doubleValue()");
                    } else {
                        this.out.print("(" + RMIC.getPrettyName(clazz) + ")$result");
                    }
                    this.out.print(");");
                }
                if (this.need11Stubs) {
                    this.ctrl.unindent();
                    this.out.println("}");
                    this.out.print("else {");
                    this.ctrl.indent();
                }
            }
            if (this.need11Stubs) {
                this.out.println("java.rmi.server.RemoteCall call = ref.newCall((java.rmi.server.RemoteObject)this, operations, " + i + ", interfaceHash);");
                this.out.print("try {");
                this.ctrl.indent();
                this.out.print("java.io.ObjectOutput out = call.getOutputStream();");
                for (n3 = 0; n3 < classArray.length; ++n3) {
                    this.out.println();
                    if (classArray[n3] == Boolean.TYPE) {
                        this.out.print("out.writeBoolean(");
                    } else if (classArray[n3] == Byte.TYPE) {
                        this.out.print("out.writeByte(");
                    } else if (classArray[n3] == Character.TYPE) {
                        this.out.print("out.writeChar(");
                    } else if (classArray[n3] == Short.TYPE) {
                        this.out.print("out.writeShort(");
                    } else if (classArray[n3] == Integer.TYPE) {
                        this.out.print("out.writeInt(");
                    } else if (classArray[n3] == Long.TYPE) {
                        this.out.print("out.writeLong(");
                    } else if (classArray[n3] == Float.TYPE) {
                        this.out.print("out.writeFloat(");
                    } else if (classArray[n3] == Double.TYPE) {
                        this.out.print("out.writeDouble(");
                    } else {
                        this.out.print("out.writeObject(");
                    }
                    this.out.print("$param_" + n3 + ");");
                }
                this.ctrl.unindent();
                this.out.println("}");
                this.out.print("catch (java.io.IOException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.MarshalException(\"error marshalling arguments\", e);");
                this.ctrl.unindent();
                this.out.println("}");
                this.out.println("ref.invoke(call);");
                if (clazz != Void.TYPE) {
                    this.out.println(RMIC.getPrettyName(clazz) + " $result;");
                }
                this.out.print("try {");
                this.ctrl.indent();
                this.out.print("java.io.ObjectInput in = call.getInputStream();");
                n3 = 0;
                if (clazz != Void.TYPE) {
                    this.out.println();
                    this.out.print("$result = ");
                    if (clazz == Boolean.TYPE) {
                        this.out.print("in.readBoolean();");
                    } else if (clazz == Byte.TYPE) {
                        this.out.print("in.readByte();");
                    } else if (clazz == Character.TYPE) {
                        this.out.print("in.readChar();");
                    } else if (clazz == Short.TYPE) {
                        this.out.print("in.readShort();");
                    } else if (clazz == Integer.TYPE) {
                        this.out.print("in.readInt();");
                    } else if (clazz == Long.TYPE) {
                        this.out.print("in.readLong();");
                    } else if (clazz == Float.TYPE) {
                        this.out.print("in.readFloat();");
                    } else if (clazz == Double.TYPE) {
                        this.out.print("in.readDouble();");
                    } else {
                        if (clazz != RMIC.class$("java.lang.Object")) {
                            this.out.print("(" + RMIC.getPrettyName(clazz) + ")");
                        } else {
                            n3 = 1;
                        }
                        this.out.print("in.readObject();");
                    }
                    this.out.println();
                    this.out.print("return ($result);");
                }
                this.ctrl.unindent();
                this.out.println("}");
                this.out.print("catch (java.io.IOException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                this.ctrl.unindent();
                this.out.println("}");
                if (n3 != 0) {
                    this.out.print("catch (java.lang.ClassNotFoundException e) {");
                    this.ctrl.indent();
                    this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                    this.ctrl.unindent();
                    this.out.println("}");
                }
                this.out.print("finally {");
                this.ctrl.indent();
                this.out.print("ref.done(call);");
                this.ctrl.unindent();
                this.out.print("}");
                if (this.need12Stubs && this.need11Stubs) {
                    this.ctrl.unindent();
                    this.out.print("}");
                }
            }
            this.ctrl.unindent();
            this.out.print("}");
            n3 = 1;
            for (int j = 0; j < classArray2.length; ++j) {
                this.out.println();
                this.out.print("catch (" + RMIC.getPrettyName(classArray2[j]) + " e) {");
                this.ctrl.indent();
                this.out.print("throw e;");
                this.ctrl.unindent();
                this.out.print("}");
                if (classArray2[j] != RMIC.class$("java.lang.Exception")) continue;
                n3 = 0;
            }
            if (n3 != 0) {
                this.out.println();
                this.out.print("catch (java.lang.Exception e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnexpectedException(\"undeclared checked exception\", e);");
                this.ctrl.unindent();
                this.out.print("}");
            }
            this.ctrl.unindent();
            this.out.print("}");
            this.out.println();
        }
        this.ctrl.unindent();
        this.out.println("}");
        this.out.close();
    }

    private void generateSkel() throws IOException {
        int n;
        Class[] classArray;
        Method method;
        int n2;
        this.skelname = this.fullclassname + "_Skel";
        String string = this.classname + "_Skel";
        this.fullskelname = (this.destination == null ? "" : this.destination + File.separator) + this.skelname.replace('.', File.separatorChar) + ".java";
        File file = new File(this.fullskelname);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        this.ctrl = new TabbedWriter(new FileWriter(file));
        this.out = new PrintWriter(this.ctrl);
        if (this.verbose) {
            System.out.println("[Generating class " + this.skelname + ".java]");
        }
        this.out.println("// Skel class generated by rmic - DO NOT EDIT!");
        this.out.println();
        if (this.fullclassname != this.classname) {
            String string2 = this.fullclassname.substring(0, this.fullclassname.lastIndexOf(46));
            this.out.println("package " + string2 + ";");
            this.out.println();
        }
        this.out.print("public final class " + string);
        this.ctrl.indent();
        this.out.print("implements java.rmi.server.Skeleton");
        this.ctrl.unindent();
        this.out.print("{");
        this.ctrl.indent();
        this.out.println("private static final long interfaceHash = " + RMIHashes.getInterfaceHash(this.clazz) + "L;");
        this.out.println();
        this.out.print("private static final java.rmi.server.Operation[] operations = {");
        this.ctrl.indent();
        for (n2 = 0; n2 < this.remotemethods.length; ++n2) {
            method = this.remotemethods[n2].meth;
            this.out.print("new java.rmi.server.Operation(\"");
            this.out.print(RMIC.getPrettyName(method.getReturnType()) + " ");
            this.out.print(method.getName() + "(");
            classArray = method.getParameterTypes();
            for (n = 0; n < classArray.length; ++n) {
                this.out.print(RMIC.getPrettyName(classArray[n]));
                if (n + 1 >= classArray.length) continue;
                this.out.print(", ");
            }
            this.out.print("\")");
            if (n2 + 1 >= this.remotemethods.length) continue;
            this.out.println(",");
        }
        this.ctrl.unindent();
        this.out.println("};");
        this.out.println();
        this.out.print("public java.rmi.server.Operation[] getOperations() {");
        this.ctrl.indent();
        this.out.print("return ((java.rmi.server.Operation[]) operations.clone());");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.println();
        this.out.print("public void dispatch(java.rmi.Remote obj, java.rmi.server.RemoteCall call, int opnum, long hash) throws java.lang.Exception {");
        this.ctrl.indent();
        this.out.print("if (opnum < 0) {");
        this.ctrl.indent();
        for (n2 = 0; n2 < this.remotemethods.length; ++n2) {
            this.out.print("if (hash == " + Long.toString(this.remotemethods[n2].hash) + "L) {");
            this.ctrl.indent();
            this.out.print("opnum = " + n2 + ";");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("else ");
        }
        this.out.print("{");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.print("else if (hash != interfaceHash) {");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.println();
        this.out.println(this.fullclassname + " server = (" + this.fullclassname + ")obj;");
        this.out.println("switch (opnum) {");
        for (n2 = 0; n2 < this.remotemethods.length; ++n2) {
            method = this.remotemethods[n2].meth;
            this.out.println("case " + n2 + ":");
            this.out.print("{");
            this.ctrl.indent();
            classArray = method.getParameterTypes();
            for (n = 0; n < classArray.length; ++n) {
                this.out.print(RMIC.getPrettyName(classArray[n]));
                this.out.println(" $param_" + n + ";");
            }
            this.out.print("try {");
            n = 0;
            this.ctrl.indent();
            this.out.println("java.io.ObjectInput in = call.getInputStream();");
            for (int i = 0; i < classArray.length; ++i) {
                this.out.print("$param_" + i + " = ");
                if (classArray[i] == Boolean.TYPE) {
                    this.out.print("in.readBoolean();");
                } else if (classArray[i] == Byte.TYPE) {
                    this.out.print("in.readByte();");
                } else if (classArray[i] == Character.TYPE) {
                    this.out.print("in.readChar();");
                } else if (classArray[i] == Short.TYPE) {
                    this.out.print("in.readShort();");
                } else if (classArray[i] == Integer.TYPE) {
                    this.out.print("in.readInt();");
                } else if (classArray[i] == Long.TYPE) {
                    this.out.print("in.readLong();");
                } else if (classArray[i] == Float.TYPE) {
                    this.out.print("in.readFloat();");
                } else if (classArray[i] == Double.TYPE) {
                    this.out.print("in.readDouble();");
                } else {
                    if (classArray[i] != RMIC.class$("java.lang.Object")) {
                        this.out.print("(" + RMIC.getPrettyName(classArray[i]) + ")");
                        n = 1;
                    }
                    this.out.print("in.readObject();");
                }
                this.out.println();
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.io.IOException e) {");
            this.ctrl.indent();
            this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
            this.ctrl.unindent();
            this.out.println("}");
            if (n != 0) {
                this.out.print("catch (java.lang.ClassCastException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
                this.ctrl.unindent();
                this.out.println("}");
            }
            this.out.print("finally {");
            this.ctrl.indent();
            this.out.print("call.releaseInputStream();");
            this.ctrl.unindent();
            this.out.println("}");
            Class clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                this.out.print(RMIC.getPrettyName(clazz) + " $result = ");
            }
            this.out.print("server." + method.getName() + "(");
            for (int i = 0; i < classArray.length; ++i) {
                this.out.print("$param_" + i);
                if (i + 1 >= classArray.length) continue;
                this.out.print(", ");
            }
            this.out.println(");");
            this.out.print("try {");
            this.ctrl.indent();
            this.out.print("java.io.ObjectOutput out = call.getResultStream(true);");
            if (clazz != Void.TYPE) {
                this.out.println();
                if (clazz == Boolean.TYPE) {
                    this.out.print("out.writeBoolean($result);");
                } else if (clazz == Byte.TYPE) {
                    this.out.print("out.writeByte($result);");
                } else if (clazz == Character.TYPE) {
                    this.out.print("out.writeChar($result);");
                } else if (clazz == Short.TYPE) {
                    this.out.print("out.writeShort($result);");
                } else if (clazz == Integer.TYPE) {
                    this.out.print("out.writeInt($result);");
                } else if (clazz == Long.TYPE) {
                    this.out.print("out.writeLong($result);");
                } else if (clazz == Float.TYPE) {
                    this.out.print("out.writeFloat($result);");
                } else if (clazz == Double.TYPE) {
                    this.out.print("out.writeDouble($result);");
                } else {
                    this.out.print("out.writeObject($result);");
                }
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.io.IOException e) {");
            this.ctrl.indent();
            this.out.print("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("break;");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.println();
        }
        this.out.print("default:");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.UnmarshalException(\"invalid method number\");");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.close();
    }

    private void compile(String string) throws Exception {
        Compiler compiler = Compiler.getInstance();
        if (this.verbose) {
            System.out.println("[Compiling class " + string + "]");
        }
        compiler.setDestination(this.destination);
        if (this.classpath != null) {
            compiler.setClasspath(this.classpath);
        }
        compiler.compile(string);
    }

    private static String getPrettyName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (!clazz.isArray()) {
                stringBuffer.append(clazz.getName());
                while (n > 0) {
                    stringBuffer.append("[]");
                    --n;
                }
                return stringBuffer.toString();
            }
            clazz = clazz.getComponentType();
            ++n;
        }
    }

    private Class[] sortExceptions(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            for (int j = i + 1; j < classArray.length; ++j) {
                if (!classArray[i].isAssignableFrom(classArray[j])) continue;
                Class clazz = classArray[i];
                classArray[i] = classArray[j];
                classArray[j] = clazz;
            }
        }
        return classArray;
    }

    private void parseOptions() {
        while (this.next < this.args.length && this.args[this.next].charAt(0) == '-') {
            String string = this.args[this.next];
            ++this.next;
            if (string.length() > 3 && string.charAt(0) == '-' && string.charAt(1) == '-') {
                string = string.substring(1);
            }
            if (string.equals("-keep")) {
                this.keep = true;
                continue;
            }
            if (string.equals("-keepgenerated")) {
                this.keep = true;
                continue;
            }
            if (string.equals("-v1.1")) {
                this.need11Stubs = true;
                this.need12Stubs = false;
                continue;
            }
            if (string.equals("-vcompat")) {
                this.need11Stubs = true;
                this.need12Stubs = true;
                continue;
            }
            if (string.equals("-v1.2")) {
                this.need11Stubs = false;
                this.need12Stubs = true;
                continue;
            }
            if (string.equals("-g") || string.equals("-depend") || string.equals("-nowarn")) continue;
            if (string.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (string.equals("-nocompile")) {
                this.compile = false;
                continue;
            }
            if (string.equals("-classpath")) {
                this.classpath = this.args[this.next];
                ++this.next;
                StringTokenizer stringTokenizer = new StringTokenizer(this.classpath, File.pathSeparator);
                URL[] uRLArray = new URL[stringTokenizer.countTokens()];
                for (int i = 0; i < uRLArray.length; ++i) {
                    String string2 = stringTokenizer.nextToken();
                    File file = new File(string2);
                    try {
                        uRLArray[i] = file.toURL();
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        RMIC.error("malformed classpath component " + string2);
                    }
                }
                this.loader = new URLClassLoader(uRLArray);
                continue;
            }
            if (string.equals("-help")) {
                RMIC.usage();
                continue;
            }
            if (string.equals("-version")) {
                System.out.println("rmic (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
                System.out.println();
                System.out.println("Copyright 2006 Free Software Foundation, Inc.");
                System.out.println("This is free software; see the source for copying conditions.  There is NO");
                System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
                System.exit(0);
                continue;
            }
            if (string.equals("-d")) {
                this.destination = this.args[this.next];
                ++this.next;
                continue;
            }
            if (string.charAt(1) == 'J') continue;
            RMIC.error("unrecognized option `" + string + "'");
        }
    }

    private void findRemoteMethods() {
        Method method;
        int n;
        Object object;
        GenericDeclaration genericDeclaration;
        int n2;
        Object object2;
        ArrayList arrayList = new ArrayList();
        for (object2 = this.clazz; object2 != null; object2 = ((Class)object2).getSuperclass()) {
            Class[] classArray = ((Class)object2).getInterfaces();
            for (n2 = 0; n2 < classArray.length; ++n2) {
                if (!RMIC.class$("java.rmi.Remote").isAssignableFrom(classArray[n2])) continue;
                genericDeclaration = classArray[n2];
                if (this.verbose) {
                    System.out.println("[implements " + genericDeclaration.getName() + "]");
                }
                object = genericDeclaration.getMethods();
                for (n = 0; n < ((Method[])object).length; ++n) {
                    method = object[n];
                    Class[] classArray2 = method.getExceptionTypes();
                    boolean bl = false;
                    for (int i = 0; i < classArray2.length; ++i) {
                        if (!classArray2[i].isAssignableFrom(RMIC.class$("java.rmi.RemoteException"))) continue;
                        bl = true;
                    }
                    if (!bl) {
                        this.logError("Method " + method + " does not throw a RemoteException");
                        continue;
                    }
                    arrayList.add(method);
                }
                this.mRemoteInterfaces.add(genericDeclaration);
            }
        }
        object2 = new boolean[arrayList.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = false;
        }
        ArrayList arrayList2 = new ArrayList();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (object2[n2] != false) continue;
            genericDeclaration = (Method)arrayList.get(n2);
            object = new MethodRef((Method)genericDeclaration);
            for (n = n2 + 1; n < arrayList.size(); ++n) {
                method = (Method)arrayList.get(n);
                if (!((MethodRef)object).isMatch(method)) continue;
                ((MethodRef)object).intersectExceptions(method);
                object2[n] = true;
            }
            arrayList2.add(object);
        }
        this.remotemethods = (MethodRef[])arrayList2.toArray(new MethodRef[arrayList2.size()]);
        Arrays.sort(this.remotemethods);
    }

    private void logError(String string) {
        ++this.errorCount;
        System.err.println("error:" + string);
    }

    private static void error(String string) {
        System.err.println("rmic: " + string);
        System.err.println("Try `rmic --help' for more information.");
        System.exit(1);
    }

    private static void usage() {
        System.out.println("Usage: rmic [OPTION]... CLASS...\n\n\t-keep \t\t\tDon't delete any intermediate files\n\t-keepgenerated \t\tSame as -keep\n\t-v1.1\t\t\tJava 1.1 style stubs only\n\t-vcompat\t\tJava 1.1 & Java 1.2 stubs\n\t-v1.2\t\t\tJava 1.2 style stubs only\n\t-g *\t\t\tGenerated debugging information\n\t-depend *\t\tRecompile out-of-date files\n\t-nowarn\t*\t\tSuppress warning messages\n\t-nocompile\t\tDon't compile the generated files\n\t-verbose \t\tOutput what's going on\n\t-classpath <path> *\tUse given path as classpath\n\t-d <directory> \t\tSpecify where to place generated classes\n\t-J<flag> *\t\tPass flag to Java\n\t-help\t\t\tPrint this help, then exit\n\t-version\t\tPrint version number, then exit\n\n  * Option currently ignored\nLong options can be used with `--option' form as well.");
        System.exit(0);
    }

    private static class MethodRef
    implements Comparable {
        Method meth;
        long hash;
        List exceptions;
        private String sig;

        MethodRef(Method method) {
            this.meth = method;
            this.sig = method.getName();
            this.hash = RMIHashes.getMethodHash(method);
            this.exceptions = MethodRef.removeSubclasses(method.getExceptionTypes());
        }

        public int compareTo(Object object) {
            MethodRef methodRef = (MethodRef)object;
            int n = this.meth.getName().compareTo(methodRef.meth.getName());
            if (n == 0) {
                return this.sig.compareTo(methodRef.sig);
            }
            return n;
        }

        public boolean isMatch(Method method) {
            Class[] classArray;
            if (!this.meth.getName().equals(method.getName())) {
                return false;
            }
            Class[] classArray2 = this.meth.getParameterTypes();
            if (classArray2.length != (classArray = method.getParameterTypes()).length) {
                return false;
            }
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].equals(classArray[i])) continue;
                return false;
            }
            return true;
        }

        private static List removeSubclasses(Class[] classArray) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                boolean bl = true;
                for (int j = 0; j < classArray.length; ++j) {
                    if (classArray[j].equals(clazz) || !classArray[j].isAssignableFrom(clazz)) continue;
                    bl = false;
                }
                if (!bl) continue;
                arrayList.add(clazz);
            }
            return arrayList;
        }

        public void intersectExceptions(Method method) {
            List list2 = MethodRef.removeSubclasses(method.getExceptionTypes());
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.exceptions.size(); ++i) {
                Class clazz = (Class)this.exceptions.get(i);
                boolean bl = false;
                for (int j = 0; j < list2.size(); ++j) {
                    Class clazz2 = (Class)list2.get(j);
                    if (clazz2.equals(clazz) || clazz2.isAssignableFrom(clazz)) {
                        bl = true;
                        continue;
                    }
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    arrayList.add(clazz2);
                }
                if (!bl) continue;
                arrayList.add(clazz);
            }
            this.exceptions = arrayList;
        }
    }
}

