/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Map;
import java.util.logging.Logger;

public class RSAKeyPairGenerator
implements IKeyPairGenerator {
    private static final Logger log = Logger.getLogger(RSAKeyPairGenerator.class$("gnu.java.security.key.rsa.RSAKeyPairGenerator").getName());
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2);
    public static final String MODULUS_LENGTH = "gnu.crypto.rsa.L";
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.rsa.prng";
    public static final String RSA_PARAMETERS = "gnu.crypto.rsa.params";
    public static final String PREFERRED_ENCODING_FORMAT = "gnu.crypto.rsa.encoding";
    private static final int DEFAULT_MODULUS_LENGTH = 1024;
    private static final int DEFAULT_ENCODING_FORMAT = 1;
    private int L;
    private BigInteger e;
    private SecureRandom rnd;
    private PRNG prng;
    private int preferredFormat;

    private /* synthetic */ void finit$() {
        this.e = BigInteger.valueOf(65537L);
        this.rnd = null;
        this.prng = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String name() {
        return "rsa";
    }

    public void setup(Map map) {
        Integer n;
        this.rnd = (SecureRandom)map.get(SOURCE_OF_RANDOMNESS);
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)map.get(RSA_PARAMETERS);
        if (rSAKeyGenParameterSpec != null) {
            this.L = rSAKeyGenParameterSpec.getKeysize();
            this.e = rSAKeyGenParameterSpec.getPublicExponent();
        } else {
            n = (Integer)map.get(MODULUS_LENGTH);
            int n2 = this.L = n == null ? 1024 : n;
        }
        if (this.L < 1024) {
            throw new IllegalArgumentException(MODULUS_LENGTH);
        }
        n = (Integer)map.get(PREFERRED_ENCODING_FORMAT);
        this.preferredFormat = n == null ? 1 : n;
    }

    public KeyPair generate() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n = (this.L + 1) / 2;
        BigInteger bigInteger4 = TWO.pow(n - 1);
        BigInteger bigInteger5 = TWO.pow(n).subtract(ONE);
        byte[] byArray = new byte[(n + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger3 = new BigInteger(1, byArray).setBit(0)).compareTo(bigInteger4) < 0 || bigInteger3.compareTo(bigInteger5) > 0 || !bigInteger3.isProbablePrime(80) || !bigInteger3.gcd(this.e).equals(ONE));
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger2 = bigInteger3.multiply(bigInteger = new BigInteger(1, byArray).setBit(0))).bitLength() != this.L || !bigInteger.isProbablePrime(80) || !bigInteger.gcd(this.e).equals(ONE));
        BigInteger bigInteger6 = bigInteger3.subtract(ONE).multiply(bigInteger.subtract(ONE));
        BigInteger bigInteger7 = this.e.modInverse(bigInteger6);
        GnuRSAPublicKey gnuRSAPublicKey = new GnuRSAPublicKey(this.preferredFormat, bigInteger2, this.e);
        GnuRSAPrivateKey gnuRSAPrivateKey = new GnuRSAPrivateKey(this.preferredFormat, bigInteger3, bigInteger, this.e, bigInteger7);
        KeyPair keyPair = new KeyPair(gnuRSAPublicKey, gnuRSAPrivateKey);
        return keyPair;
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }

    public RSAKeyPairGenerator() {
        this.finit$();
    }

    static {
        MODULUS_LENGTH = MODULUS_LENGTH;
        SOURCE_OF_RANDOMNESS = SOURCE_OF_RANDOMNESS;
        RSA_PARAMETERS = RSA_PARAMETERS;
        PREFERRED_ENCODING_FORMAT = PREFERRED_ENCODING_FORMAT;
    }
}

