#!/bin/sh
echo 'name: snap-core
version: 0.2.16
id: snap-core-0.2.16-303fb8ad4f4da18d15e2241bd9f2f67d

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
description: This is the first developer prerelease of the Snap framework.  Snap is a
             simple and fast web development framework and server written in Haskell. For
             more information or to download the latest version, you can visit the Snap
             project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", inspired by
             happstack'\''s (<http://happstack.com/index.html>), which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Types",
             some iteratee utilities are in "Snap.Iteratee".
             .
             Higher-level facilities for building web applications (like user/session
             management, component interfaces, data modeling, etc.) are planned but not
             yet implemented, so this release will mostly be of interest for those who:
             .
             * need a fast and minimal HTTP API at roughly the same level of abstraction
             as Java servlets, or
             .
             * are interested in contributing to the Snap Framework project.
category: Web
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Data.CIByteString Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Http.Types
                 Snap.Internal.Iteratee.Debug Snap.Util.FileServe Snap.Util.GZip
hidden-modules: Snap.Internal.Parsing Snap.Internal.Routing
                Snap.Internal.Types
import-dirs: /usr/local/lib/ghc/snap-core-0.2.16
library-dirs: /usr/local/lib/ghc/snap-core-0.2.16
hs-libraries: HSsnap-core-0.2.16
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ListLike-1.0.1-7c265cf1b3009427ee314314cd9eaaf3
         MonadCatchIO-transformers-0.2.2.0-2f29616558987a7d7eed29310fd8bf1a
         attoparsec-0.8.1.0-83d9f56aca0a801c9a37f06cf26b359a
         base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         bytestring-0.9.1.7-352f069cca85cb3f9e4c06bb76ec4cec
         bytestring-nums-0.3.2-21037aaf19770f651dce29a161872fd0
         bytestring-show-0.3.3-c23b4d15e592c82b89130c51a4a44b42
         cereal-0.3.0.0-969871fe078e0d7e344486d6f7f79155
         containers-0.3.0.0-7be04792060ce1514c52e2cb13a5c18a
         deepseq-1.1.0.0-bdee49850bb3a374a352be0c188f0973
         directory-1.0.1.1-7962558b34e6144244ddec948ea3bb41
         directory-tree-0.2.0-3b40e4a8211d155916df04c86dbb2747
         dlist-0.5-a386e34fa917b02efe60bdec59cb50f8
         filepath-1.1.0.4-1425f312faf5b8e9f4babf887e252326
         haskell98-1.0.1.1-4d2891ad99eae334ff8234bcfbddce06
         iteratee-0.3.5-a5e2598819c6042cea8b457a7e847b19
         monads-fd-0.1.0.1-4302101a818b1cd4a450f02794f0a403
         old-locale-1.0.0.2-0c1a4b40f2d3b9f6b725f54c00fe0923
         old-time-1.0.0.5-56dd504e1de073228be3dcc82225ab48
         template-haskell-2.4.0.1-d8399ac6f01f9e8e91671cd4415bb072
         text-0.10.0.2-3cd9f1eb0231de4ddb5f61b812f95036
         time-1.1.4-668ce7f110e803952c4ceda6e172096c
         transformers-0.2.1.0-83bd04c7d756a68d4480a7c48ea90dcc
         unix-compat-0.1.2.1-89f4a7deb6cc1fcf107d9c37366279bc
         zlib-0.5.2.0-8e0dda775cfb8c74f8a32c600a1d6f70
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.2.16/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.2.16/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
