#!/bin/sh
echo 'name: tls
version: 0.3.1
id: tls-0.3.1-8320378d5701461869b6d59061ecb710

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
description: native TLS protocol implementation, focusing on purity and more type-checking.
             .
             Currently implement the SSL3.0, TLS1.0 and TLS1.1 protocol.
             Not yet properly secure and missing some features.
             Do not yet use as replacement to more mature implementation.
             .
             only RSA supported as Key exchange for now.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS.Client Network.TLS.Server
                 Network.TLS.Struct Network.TLS.Cipher Network.TLS.SRandom
                 Network.TLS.MAC
hidden-modules: Network.TLS.Cap Network.TLS.Compression
                Network.TLS.Crypto Network.TLS.Packet Network.TLS.State
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Wire
import-dirs: /usr/local/lib/ghc/tls-0.3.1
library-dirs: /usr/local/lib/ghc/tls-0.3.1
hs-libraries: HStls-0.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: AES-0.2.7-edcd853a12283ad00afc88096e462e4d
         base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         binary-0.5.0.2-89481d508ae9510a91c30d5d669395e9
         bytestring-0.9.1.7-352f069cca85cb3f9e4c06bb76ec4cec
         cereal-0.3.0.0-969871fe078e0d7e344486d6f7f79155
         certificate-0.3.2-a950afc2898015e759bd13f219cca05c
         crypto-api-0.2.1-ed5a439f0220607c69a3575a34b18dae
         cryptocipher-0.2-1457c737e59fc0246241ad60cd9ee613
         cryptohash-0.6.1-22d29e66bcccee86e47a510eb7d58916
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         vector-0.7.0.1-d762521ac6fd5fda2921406fa5b383fc
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.3.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
