/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableImpl;
import com.sun.xml.internal.ws.util.localization.Localizer;
import com.sun.xml.internal.ws.util.localization.NullLocalizable;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private final Localizable msg;

    protected JAXWSExceptionBase(String key, Object ... args) {
        super(JAXWSExceptionBase.findNestedException(args));
        this.msg = new LocalizableImpl(key, JAXWSExceptionBase.fixNull(args), this.getDefaultResourceBundleName());
    }

    protected JAXWSExceptionBase(String message) {
        super(message);
        this.msg = null;
    }

    private static Object[] fixNull(Object[] x) {
        if (x == null) {
            return new Object[0];
        }
        return x;
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        this(new NullLocalizable(throwable.toString()), throwable);
    }

    protected JAXWSExceptionBase(Localizable msg) {
        this.msg = msg;
    }

    protected JAXWSExceptionBase(Localizable msg, Throwable cause) {
        super(cause);
        this.msg = msg;
    }

    private static Throwable findNestedException(Object[] args) {
        if (args == null) {
            return null;
        }
        for (Object o : args) {
            if (!(o instanceof Throwable)) continue;
            return (Throwable)o;
        }
        return null;
    }

    @Override
    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    protected abstract String getDefaultResourceBundleName();

    @Override
    public final String getKey() {
        return this.msg.getKey();
    }

    @Override
    public final Object[] getArguments() {
        return this.msg.getArguments();
    }

    @Override
    public final String getResourceBundleName() {
        return this.msg.getResourceBundleName();
    }
}

