/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MirrorAction
extends JosmAction {
    public MirrorAction() {
        super(I18n.tr("Mirror"), "mirror", I18n.tr("Mirror selected nodes and ways."), Shortcut.registerShortcut("tools:mirror", I18n.tr("Tool: {0}", I18n.tr("Mirror")), 77, 3, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Mirror"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        HashSet<Node> nodes = new HashSet<Node>();
        for (OsmPrimitive osm : sel) {
            if (osm instanceof Node) {
                nodes.add((Node)osm);
                continue;
            }
            if (!(osm instanceof Way)) continue;
            nodes.addAll(((Way)osm).getNodes());
        }
        if (nodes.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one node or way."), I18n.tr("Information"), 1);
            return;
        }
        double minEast = 2.0E10;
        double maxEast = -2.0E10;
        for (Node n : nodes) {
            double east = n.getEastNorth().east();
            minEast = Math.min(minEast, east);
            maxEast = Math.max(maxEast, east);
        }
        double middle = (minEast + maxEast) / 2.0;
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Node n : nodes) {
            cmds.add(new MoveCommand(n, 2.0 * (middle - n.getEastNorth().east()), 0.0));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Mirror"), cmds));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

