/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UploadAction
extends JosmAction {
    private static Logger logger = Logger.getLogger(UploadAction.class.getName());
    private static final LinkedList<UploadHook> uploadHooks = new LinkedList();

    public static void registerUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        if (!uploadHooks.contains(hook)) {
            uploadHooks.add(0, hook);
        }
    }

    public static void unregisterUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        if (uploadHooks.contains(hook)) {
            uploadHooks.remove(hook);
        }
    }

    public UploadAction() {
        super(I18n.tr("Upload data"), "upload", I18n.tr("Upload all changes in the active data layer to the OSM server"), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data")), 85, 8), true);
        this.putValue("help", HelpUtil.ht("/Action/Upload"));
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public boolean checkPreUploadConditions(OsmDataLayer layer) {
        return this.checkPreUploadConditions(layer, new APIDataSet(layer.data));
    }

    protected void alertUnresolvedConflicts(OsmDataLayer layer) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The data to be uploaded participates in unresolved conflicts of layer ''{0}''.<br>You have to resolve them first.</html>", layer.getName()), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/Upload#PrimitivesParticipateInConflicts"));
    }

    public boolean checkPreUploadConditions(OsmDataLayer layer, APIDataSet apiData) {
        ConflictCollection conflicts = layer.getConflicts();
        if (apiData.participatesInConflict(conflicts)) {
            this.alertUnresolvedConflicts(layer);
            return false;
        }
        for (UploadHook hook : uploadHooks) {
            if (hook.checkUpload(apiData)) continue;
            return false;
        }
        return true;
    }

    public void uploadData(OsmDataLayer layer, APIDataSet apiData) {
        if (apiData.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."), I18n.tr("Warning"), 1);
            return;
        }
        if (!this.checkPreUploadConditions(layer, apiData)) {
            return;
        }
        UploadDialog dialog = UploadDialog.getUploadDialog();
        dialog.setUploadedPrimitives(apiData);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        dialog.rememberUserInput();
        Main.worker.execute(new UploadPrimitivesTask(UploadDialog.getUploadDialog().getUploadStrategySpecification(), layer, apiData, UploadDialog.getUploadDialog().getChangeset()));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first."), I18n.tr("Warning"), 2);
            return;
        }
        APIDataSet apiData = new APIDataSet(Main.main.getCurrentDataSet());
        this.uploadData(Main.map.mapView.getEditLayer(), apiData);
    }

    static {
        uploadHooks.add(new ApiPreconditionCheckerHook());
        uploadHooks.add(new RelationUploadOrderHook());
    }
}

