/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public CoordinateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType decision) {
        this.conflict = conflict;
        this.decision = decision;
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.tr("Resolve conflicts in coordinates in {0}", this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
                Node my = (Node)this.conflict.getMy();
                Node their = (Node)this.conflict.getTheir();
                my.setCoor(their.getCoor());
            } else {
                throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict."));
            }
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }
}

