/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conflict<T extends OsmPrimitive> {
    private final T my;
    private final T their;
    private final boolean isMyDeleted;

    public Conflict(T my, T their) {
        this(my, their, false);
    }

    public Conflict(T my, T their, boolean isMyDeleted) {
        this.my = my;
        this.their = their;
        this.isMyDeleted = isMyDeleted;
    }

    public T getMy() {
        return this.my;
    }

    public T getTheir() {
        return this.their;
    }

    public boolean isMatchingMy(OsmPrimitive my) {
        return this.my == my;
    }

    public boolean isMatchingTheir(OsmPrimitive their) {
        return this.their == their;
    }

    public boolean isParticipating(OsmPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        return primitive.getPrimitiveId().equals(((OsmPrimitive)this.my).getPrimitiveId()) || primitive.getPrimitiveId().equals(((OsmPrimitive)this.their).getPrimitiveId());
    }

    public boolean isParticipating(PrimitiveId id) {
        if (id == null) {
            return false;
        }
        return id.equals(((OsmPrimitive)this.my).getPrimitiveId()) || id.equals(((OsmPrimitive)this.their).getPrimitiveId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.my == null ? 0 : ((OsmPrimitive)this.my).hashCode());
        result = 31 * result + (this.their == null ? 0 : ((OsmPrimitive)this.their).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conflict other = (Conflict)obj;
        if (this.my != other.my) {
            return false;
        }
        return this.their == other.their;
    }

    public boolean isMyDeleted() {
        return this.isMyDeleted;
    }
}

