/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationToChildReference {
    private Relation parent;
    private int position;
    private String role;
    private OsmPrimitive child;

    public static Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive child) {
        LinkedHashSet<Relation> parents = OsmPrimitive.getFilteredSet(child.getReferrers(), Relation.class);
        HashSet<RelationToChildReference> references = new HashSet<RelationToChildReference>();
        for (Relation parent : parents) {
            for (int i = 0; i < parent.getMembersCount(); ++i) {
                if (!parent.getMember(i).refersTo(child)) continue;
                references.add(new RelationToChildReference(parent, i, parent.getMember(i)));
            }
        }
        return references;
    }

    public static Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> children) {
        HashSet<RelationToChildReference> references = new HashSet<RelationToChildReference>();
        for (OsmPrimitive osmPrimitive : children) {
            references.addAll(RelationToChildReference.getRelationToChildReferences(osmPrimitive));
        }
        return references;
    }

    public RelationToChildReference(Relation parent, int position, String role, OsmPrimitive child) {
        this.parent = parent;
        this.position = position;
        this.role = role;
        this.child = child;
    }

    public RelationToChildReference(Relation parent, int position, RelationMember member) {
        this.parent = parent;
        this.position = position;
        this.role = member.getRole();
        this.child = member.getMember();
    }

    public Relation getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitive getChild() {
        return this.child;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.position;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationToChildReference other = (RelationToChildReference)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }
}

