/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ConditionalOptionPaneUtil {
    public static final int DIALOG_DISABLED_OPTION = Integer.MIN_VALUE;

    private ConditionalOptionPaneUtil() {
    }

    public static boolean getDialogShowingEnabled(String prefKey) {
        return Main.pref.getBoolean("message." + prefKey, true);
    }

    public static void setDialogShowingEnabled(String prefKey, boolean enabled) {
        Main.pref.put("message." + prefKey, enabled);
    }

    public static Integer getDialogReturnValue(String prefKey) {
        return Main.pref.getInteger("message." + prefKey + ".value", -1);
    }

    public static void setDialogReturnValue(String prefKey, Integer value) {
        Main.pref.putInteger("message." + prefKey + ".value", value);
    }

    public static int showOptionDialog(String preferenceKey, Component parent, Object message, String title, int optionType, int messageType, Object[] options, Object defaultOption) throws HeadlessException {
        int ret = ConditionalOptionPaneUtil.getDialogReturnValue(preferenceKey);
        if (!(ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey) || ret != 0 && ret != 1)) {
            return ret;
        }
        MessagePanel pnl = new MessagePanel(false, message);
        ret = JOptionPane.showOptionDialog(parent, pnl, title, optionType, messageType, null, options, defaultOption);
        if (!(ret != 0 && ret != 1 || pnl.getDialogShowingEnabled())) {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(preferenceKey, false);
            ConditionalOptionPaneUtil.setDialogReturnValue(preferenceKey, ret);
        }
        return ret;
    }

    public static boolean showConfirmationDialog(String preferenceKey, Component parent, Object message, String title, int optionType, int messageType, int trueOption) throws HeadlessException {
        int ret = ConditionalOptionPaneUtil.getDialogReturnValue(preferenceKey);
        if (!(ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey) || ret != 0 && ret != 1)) {
            return ret == trueOption;
        }
        MessagePanel pnl = new MessagePanel(false, message);
        ret = JOptionPane.showConfirmDialog(parent, pnl, title, optionType, messageType);
        if (!(ret != 0 && ret != 1 || pnl.getDialogShowingEnabled())) {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(preferenceKey, false);
            ConditionalOptionPaneUtil.setDialogReturnValue(preferenceKey, ret);
        }
        return ret == trueOption;
    }

    public static void showMessageDialog(String preferenceKey, Component parent, Object message, String title, int messageType) {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey)) {
            return;
        }
        MessagePanel pnl = new MessagePanel(false, message);
        JOptionPane.showMessageDialog(parent, pnl, title, messageType);
        if (!pnl.getDialogShowingEnabled()) {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(preferenceKey, false);
        }
    }

    private static class MessagePanel
    extends JPanel {
        JCheckBox cbShowDialog = new JCheckBox(I18n.tr("Do not show again (remembers choice)"));

        public MessagePanel(boolean donotshow, Object message) {
            this.cbShowDialog.setSelected(donotshow);
            this.setLayout(new GridBagLayout());
            if (message instanceof Component) {
                this.add((Component)message, GBC.eop());
            } else {
                this.add((Component)new JLabel(message.toString()), GBC.eop());
            }
            this.add((Component)this.cbShowDialog, GBC.eol());
        }

        public boolean getDialogShowingEnabled() {
            return !this.cbShowDialog.isSelected();
        }
    }
}

