/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.ExtrudeAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.ZoomAction;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.ScrollViewport;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.dialogs.CommandStackDialog;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.FilterDialog;
import org.openstreetmap.josm.gui.dialogs.HistoryDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.RelationListDialog;
import org.openstreetmap.josm.gui.dialogs.SelectionListDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.UserListDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.Destroyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFrame
extends JPanel
implements Destroyable,
MapView.LayerChangeListener {
    public MapMode mapMode;
    private final List<MapMode> mapModes = new ArrayList<MapMode>();
    public MapView mapView;
    private JToolBar toolBarActions = new JToolBar(1);
    private JToolBar toolBarToggle = new JToolBar(1);
    public MapStatus statusLine;
    public ConflictDialog conflictDialog;
    public FilterDialog filterDialog;
    public RelationListDialog relationListDialog;
    public SelectionListDialog selectionListDialog;
    private List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    private final DialogsPanel dialogsPanel;
    public final ButtonGroup toolGroup = new ButtonGroup();
    public static final int DEF_TOGGLE_DLG_WIDTH = 330;
    private final Map<Layer, MapMode> lastMapMode = new HashMap<Layer, MapMode>();
    private static final CopyOnWriteArrayList<MapModeChangeListener> mapModeChangeListeners = new CopyOnWriteArrayList();

    public MapFrame(JPanel contentPane) {
        this.setSize(400, 400);
        this.setLayout(new BorderLayout());
        this.mapView = new MapView(contentPane);
        new FileDrop(this.mapView);
        Main.main.menu.viewMenu.setVisible(true);
        this.toolBarActions.setFloatable(false);
        this.addMapMode(new IconToggleButton(new SelectAction(this)));
        this.addMapMode(new IconToggleButton(new DrawAction(this)));
        this.addMapMode(new IconToggleButton(new ExtrudeAction(this)));
        this.addMapMode(new IconToggleButton(new ZoomAction(this)));
        this.addMapMode(new IconToggleButton(new DeleteAction(this)));
        this.toolGroup.setSelected(((AbstractButton)this.toolBarActions.getComponent(0)).getModel(), true);
        JSplitPane splitPane = new JSplitPane(1, true);
        this.dialogsPanel = new DialogsPanel(splitPane);
        splitPane.setLeftComponent(this.mapView);
        splitPane.setRightComponent(this.dialogsPanel);
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerSize(5);
        splitPane.setBorder(null);
        splitPane.setUI(new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    public void setBorder(Border b) {
                    }
                };
            }
        });
        splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), new Object());
        splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0), new Object());
        this.add((Component)splitPane, "Center");
        this.dialogsPanel.setLayout(new BoxLayout(this.dialogsPanel, 1));
        this.dialogsPanel.setPreferredSize(new Dimension(Main.pref.getInteger("toggleDialogs.width", 330), 0));
        this.dialogsPanel.setMinimumSize(new Dimension(24, 0));
        this.mapView.setMinimumSize(new Dimension(10, 0));
        this.toolBarToggle.setFloatable(false);
        LayerListDialog.createInstance(this);
        this.addToggleDialog(LayerListDialog.getInstance());
        this.addToggleDialog(new PropertiesDialog(this));
        this.selectionListDialog = new SelectionListDialog();
        this.addToggleDialog(this.selectionListDialog);
        this.relationListDialog = new RelationListDialog();
        this.addToggleDialog(this.relationListDialog);
        this.addToggleDialog(new CommandStackDialog(this));
        this.addToggleDialog(new UserListDialog());
        this.addToggleDialog(new HistoryDialog());
        this.conflictDialog = new ConflictDialog();
        this.addToggleDialog(this.conflictDialog);
        if (Main.pref.getBoolean("displayfilter", true)) {
            this.filterDialog = new FilterDialog();
            this.addToggleDialog(this.filterDialog);
        }
        this.addToggleDialog(new ChangesetDialog(this));
        this.statusLine = new MapStatus(this);
        MapView.addLayerChangeListener(this);
    }

    public void selectSelectTool(boolean onlyIfModeless) {
        if (onlyIfModeless && !Main.pref.getBoolean("modeless", false)) {
            return;
        }
        this.selectMapMode((MapMode)this.getDefaultButtonAction());
    }

    public void selectDrawTool(boolean onlyIfModeless) {
        if (onlyIfModeless && !Main.pref.getBoolean("modeless", false)) {
            return;
        }
        Action drawAction = ((AbstractButton)this.toolBarActions.getComponent(1)).getAction();
        this.selectMapMode((MapMode)drawAction);
    }

    @Override
    public void destroy() {
        int i;
        MapView.removeLayerChangeListener(this);
        this.dialogsPanel.destroy();
        for (i = 0; i < this.toolBarActions.getComponentCount(); ++i) {
            if (!(this.toolBarActions.getComponent(i) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarActions.getComponent(i))).destroy();
        }
        for (i = 0; i < this.toolBarToggle.getComponentCount(); ++i) {
            if (!(this.toolBarToggle.getComponent(i) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarToggle.getComponent(i))).destroy();
        }
        Main.main.menu.viewMenu.setVisible(false);
        if (this.statusLine.thread != null) {
            try {
                this.statusLine.thread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mapView.destroy();
    }

    public Action getDefaultButtonAction() {
        return ((AbstractButton)this.toolBarActions.getComponent(0)).getAction();
    }

    public void initializeDialogsPane() {
        this.dialogsPanel.initialize(this.allDialogs);
    }

    public IconToggleButton addToggleDialog(ToggleDialog dlg) {
        IconToggleButton button = new IconToggleButton(dlg.getToggleAction());
        this.toolBarToggle.add(button);
        this.allDialogs.add(dlg);
        if (this.dialogsPanel.initialized) {
            this.dialogsPanel.add(dlg);
        }
        return button;
    }

    public void addMapMode(IconToggleButton b) {
        this.toolBarActions.add(b);
        this.toolGroup.add(b);
        if (!(b.getAction() instanceof MapMode)) {
            throw new IllegalArgumentException("MapMode action must be subclass of MapMode");
        }
        this.mapModes.add((MapMode)b.getAction());
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean old = this.isVisible();
        super.setVisible(aFlag);
        if (old != aFlag) {
            this.firePropertyChange("visible", old, aFlag);
        }
    }

    public void selectMapMode(MapMode newMapMode) {
        MapMode oldMapMode = this.mapMode;
        if (newMapMode == oldMapMode) {
            return;
        }
        if (oldMapMode != null) {
            oldMapMode.exitMode();
        }
        this.mapMode = newMapMode;
        newMapMode.enterMode();
        this.lastMapMode.put(this.mapView.getActiveLayer(), newMapMode);
        MapFrame.fireMapModeChanged(oldMapMode, newMapMode);
    }

    public void fillPanel(Container panel) {
        panel.add((Component)this, "Center");
        JToolBar jb = new JToolBar(1);
        jb.setFloatable(false);
        jb.add(this.toolBarActions);
        jb.addSeparator(new Dimension(0, 10));
        jb.add(this.toolBarToggle);
        if (Main.pref.getBoolean("sidetoolbar.visible", true)) {
            if (Main.pref.getBoolean("sidetoolbar.scrollable", true)) {
                final ScrollViewport svp = new ScrollViewport(jb, 3);
                panel.add((Component)svp, "West");
                jb.addMouseWheelListener(new MouseWheelListener(){

                    public void mouseWheelMoved(MouseWheelEvent e) {
                        svp.scroll(0, e.getUnitsToScroll() * 5);
                    }
                });
            } else {
                panel.add((Component)jb, "West");
            }
        }
        if (this.statusLine != null && Main.pref.getBoolean("statusline.visible", true)) {
            panel.add((Component)this.statusLine, "South");
        }
    }

    public <T> T getToggleDialog(Class<T> type) {
        return this.dialogsPanel.getToggleDialog(type);
    }

    public int getToggleDlgWidth() {
        return this.dialogsPanel.getWidth();
    }

    public static void addMapModeChangeListener(MapModeChangeListener listener) {
        if (listener != null) {
            mapModeChangeListeners.addIfAbsent(listener);
        }
    }

    public static void removeMapModeChangeListener(MapModeChangeListener listener) {
        mapModeChangeListeners.remove(listener);
    }

    protected static void fireMapModeChanged(MapMode oldMapMode, MapMode newMapMode) {
        for (MapModeChangeListener l : mapModeChangeListeners) {
            l.mapModeChange(oldMapMode, newMapMode);
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        boolean modeChanged = false;
        if (this.mapMode == null || !this.mapMode.layerIsSupported(newLayer)) {
            MapMode newMapMode = this.lastMapMode.get(newLayer);
            boolean bl = modeChanged = newMapMode != this.mapMode;
            if (newMapMode != null) {
                this.selectMapMode(newMapMode);
            }
        }
        if (!modeChanged && this.mapMode != null) {
            this.mapMode.exitMode();
            this.mapMode.enterMode();
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        this.lastMapMode.remove(oldLayer);
    }

    public static interface MapModeChangeListener {
        public void mapModeChange(MapMode var1, MapMode var2);
    }
}

