/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PreferenceDialog
extends JDialog {
    private PreferenceTabbedPane tpPreferences;
    private boolean canceled;

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add(new SideButton(new OKAction()));
        pnl.add(new SideButton(new CancelAction()));
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Preferences"))));
        return pnl;
    }

    protected void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.tpPreferences = new PreferenceTabbedPane();
        c.add((Component)this.tpPreferences, "Center");
        this.tpPreferences.buildGui();
        this.tpPreferences.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        c.add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Preferences"));
    }

    public PreferenceDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), I18n.tr("Preferences"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(700, 800))).applySafe(this);
        } else if (!visible && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Save the preferences and close the dialog"));
        }

        public void actionPerformed(ActionEvent evt) {
            for (PreferenceTabbedPane.ValidationListener listener : ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners) {
                if (listener.validatePreferences()) continue;
                return;
            }
            PreferenceDialog.this.tpPreferences.savePreferences();
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
            PreferenceDialog.this.setCanceled(false);
            PreferenceDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the preferences dialog and discard preference updates"));
        }

        public void cancel() {
            PreferenceDialog.this.setCanceled(true);
            PreferenceDialog.this.setVisible(false);
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
        }

        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }
}

